/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui.statuspanel;

import aim4.config.Debug;
import aim4.gui.StatusPanelInterface;
import aim4.gui.component.FormattedLabel;
import aim4.vehicle.AutoVehicleSimView;
import aim4.vehicle.VehicleSimView;
import aim4.vehicle.VinRegistry;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

public class VehicleInfoPanel
extends JPanel
implements StatusPanelInterface {
    private static final long serialVersionUID = 1L;
    private FormattedLabel vehicleVINLabel = new FormattedLabel("VIN: ", "%6d", 6);
    private FormattedLabel vehicleSpecLabel = new FormattedLabel("Vehicle Type: ", "%-15s", 15);
    private FormattedLabel vehicleVelocityLabel = new FormattedLabel("Velocity: ", "%5.2f m/s", 9);
    private FormattedLabel vehicleAccelerationLabel = new FormattedLabel("Acceleration: ", "%5.2f m/s/s", 11);
    private FormattedLabel vehicleTransmittedLabel = new FormattedLabel("Data Transmitted: ", "%5.2f kB", 8);
    private FormattedLabel vehicleReceivedLabel = new FormattedLabel("Data received: ", "%5.2f kB", 8);

    public VehicleInfoPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        gridbag.setConstraints(this.vehicleVINLabel, c);
        this.add(this.vehicleVINLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this.vehicleSpecLabel, c);
        this.add(this.vehicleSpecLabel);
        c.gridwidth = 1;
        gridbag.setConstraints(this.vehicleVelocityLabel, c);
        this.add(this.vehicleVelocityLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this.vehicleAccelerationLabel, c);
        this.add(this.vehicleAccelerationLabel);
        c.gridwidth = 1;
        gridbag.setConstraints(this.vehicleTransmittedLabel, c);
        this.add(this.vehicleTransmittedLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this.vehicleReceivedLabel, c);
        this.add(this.vehicleReceivedLabel);
    }

    @Override
    public void update() {
        VehicleSimView v = VinRegistry.getVehicleFromVIN(Debug.getTargetVIN());
        if (v != null) {
            this.vehicleVINLabel.update(v.getVIN());
            this.vehicleSpecLabel.update(v.getSpec().getName());
            this.vehicleVelocityLabel.update(v.getVelocity());
            this.vehicleAccelerationLabel.update(v.getAcceleration());
            if (v instanceof AutoVehicleSimView) {
                AutoVehicleSimView v2 = (AutoVehicleSimView)v;
                this.vehicleTransmittedLabel.update((double)v2.getBitsTransmitted() / 8192.0);
                this.vehicleReceivedLabel.update((double)v2.getBitsReceived() / 8192.0);
            }
        } else {
            this.clear();
        }
    }

    @Override
    public void clear() {
        this.vehicleVINLabel.clear();
        this.vehicleSpecLabel.clear();
        this.vehicleVelocityLabel.clear();
        this.vehicleAccelerationLabel.clear();
        this.vehicleTransmittedLabel.clear();
        this.vehicleReceivedLabel.clear();
    }
}

