/*
 * Decompiled with CFR 0.152.
 */
package aim4.im;

import aim4.im.Intersection;
import aim4.im.TrackModel;
import aim4.map.Road;
import aim4.map.lane.Lane;
import aim4.util.Registry;
import aim4.util.Util;
import aim4.vehicle.VehicleSimView;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;

public class IntersectionManager {
    protected int id;
    protected double currentTime;
    private Intersection intersection;
    private TrackModel trackModel;

    public IntersectionManager(Intersection intersection, TrackModel trackModel, double currentTime, Registry<IntersectionManager> imRegistry) {
        assert (trackModel.getIntersection() == intersection);
        this.intersection = intersection;
        this.trackModel = trackModel;
        this.currentTime = currentTime;
        this.id = imRegistry.register(this);
        this.registerWithLanes();
    }

    private void registerWithLanes() {
        for (Lane lane : this.intersection.getLanes()) {
            lane.getLaneIM().registerIntersectionManager(this);
        }
    }

    public void act(double timeStep) {
        this.currentTime += timeStep;
    }

    public int getId() {
        return this.id;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public Intersection getIntersection() {
        return this.intersection;
    }

    public TrackModel getTrackModel() {
        return this.trackModel;
    }

    public boolean manages(Road r) {
        return this.intersection.getLanes().contains(r.getIndexLane());
    }

    public boolean manages(Lane l) {
        return this.intersection.getLanes().contains(l);
    }

    public boolean contains(VehicleSimView vehicle) {
        for (Point2D corner : vehicle.getCornerPoints()) {
            if (this.intersection.getArea().contains(corner)) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(Rectangle2D rectangle) {
        return this.intersection.getArea().intersects(rectangle);
    }

    public boolean intersectsPoint(Point2D point) {
        Rectangle2D intersectionBounds = this.intersection.getArea().getBounds2D();
        return intersectionBounds.getX() < point.getX() && intersectionBounds.getY() < point.getY() && intersectionBounds.getX() + intersectionBounds.getWidth() > point.getX() && intersectionBounds.getY() + intersectionBounds.getHeight() > point.getY();
    }

    public List<Lane> getSortedDepartureLanes(Lane arrivalLane, Road departure) {
        return this.trackModel.getSortedDepartureLanes(arrivalLane, departure);
    }

    public double traversalDistance(Road arrival, Road departure) {
        return this.trackModel.traversalDistance(arrival, departure);
    }

    public double traversalDistance(Lane arrival, Lane departure) {
        return this.trackModel.traversalDistance(arrival, departure);
    }

    public double traversalDistance(int arrivalID, int departureID) {
        return this.trackModel.traversalDistance(arrivalID, departureID);
    }

    public void printData(String outFileName) {
    }

    public void checkCurrentTime(double currentTime) {
        assert (Util.isDoubleEqual(currentTime, this.currentTime));
    }

    public List<? extends Shape> getDebugShapes() {
        return Collections.emptyList();
    }
}

