/*
 * Decompiled with CFR 0.152.
 */
package aim4.im;

import aim4.config.Constants;
import aim4.config.Debug;
import aim4.im.Intersection;
import aim4.map.Road;
import aim4.map.lane.Lane;
import aim4.map.track.WayPoint;
import aim4.util.GeomMath;
import aim4.util.Util;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RoadBasedIntersection
implements Intersection {
    public static final double EXPANSION_DISTANCE = 4.0;
    private static final double AREA_PLUS_OFFSET = 1.0E-6;
    private Area area;
    private Area areaPlus;
    private Rectangle2D boundingBox;
    private Point2D centroid;
    private List<Path2D> edges = new ArrayList<Path2D>();
    private List<Road> roads = new ArrayList<Road>();
    private List<Road> entryRoads = new ArrayList<Road>();
    private List<Road> exitRoads = new ArrayList<Road>();
    private List<Lane> lanes = new ArrayList<Lane>();
    private List<Point2D> points = new ArrayList<Point2D>();
    private Map<Lane, Double> headings = new HashMap<Lane, Double>();
    private Map<Lane, WayPoint> entryPoints = new LinkedHashMap<Lane, WayPoint>();
    private Map<Lane, WayPoint> exitPoints = new LinkedHashMap<Lane, WayPoint>();
    private Map<Lane, Double> entryHeadings = new HashMap<Lane, Double>();
    private Map<Lane, Double> exitHeadings = new HashMap<Lane, Double>();

    public RoadBasedIntersection(List<Road> roads) {
        this.roads = roads;
        this.extractLanes(roads);
        this.establishEntryAndExitPoints(this.findStrictIntersectionArea(roads));
        this.centroid = GeomMath.polygonalShapeCentroid(this.area);
        this.calcWayPoints();
        this.calcEdges();
        this.addWayPointsPath();
        this.boundingBox = this.area.getBounds2D();
        this.calcEntryRoads();
        this.calcExitRoads();
    }

    private void extractLanes(List<Road> roads) {
        for (Road road : roads) {
            for (Lane lane : road.getLanes()) {
                this.lanes.add(lane);
            }
        }
    }

    private Area findStrictIntersectionArea(List<Road> roads) {
        ArrayList<Area> roadAreas = new ArrayList<Area>(roads.size());
        for (Road road : roads) {
            Area roadArea = new Area();
            for (Lane lane : road.getLanes()) {
                roadArea.add(new Area(lane.getShape()));
            }
            roadAreas.add(roadArea);
        }
        Area strictIntersection = new Area();
        for (int i = 0; i < roadAreas.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (roads.get(i).getDual() == roads.get(j)) continue;
                Area ixn = new Area((Shape)roadAreas.get(i));
                ixn.intersect((Area)roadAreas.get(j));
                strictIntersection.add(ixn);
            }
        }
        return strictIntersection;
    }

    private void establishEntryAndExitPoints(Area strictIntersection) {
        HashMap<Lane, Double> entryFractions = new HashMap<Lane, Double>();
        HashMap<Lane, Double> exitFractions = new HashMap<Lane, Double>();
        LinkedList<Lane> intersectingLanes = new LinkedList<Lane>();
        List<Line2D> perimeterSegments = GeomMath.polygonalShapePerimeterSegments(strictIntersection);
        for (Line2D perimeterSegment : perimeterSegments) {
            for (Lane lane : this.lanes) {
                Point2D rightIntxn;
                Point2D centerIntxn;
                ArrayList<Double> intxns = new ArrayList<Double>(3);
                Point2D leftIntxn = lane.leftIntersectionPoint(perimeterSegment);
                if (leftIntxn != null) {
                    intxns.add(lane.normalizedDistanceAlongLane(leftIntxn));
                }
                if ((centerIntxn = lane.intersectionPoint(perimeterSegment)) != null) {
                    intxns.add(lane.normalizedDistanceAlongLane(centerIntxn));
                }
                if ((rightIntxn = lane.rightIntersectionPoint(perimeterSegment)) != null) {
                    intxns.add(lane.normalizedDistanceAlongLane(rightIntxn));
                }
                if (intxns.isEmpty()) continue;
                intersectingLanes.add(lane);
                double min = (Double)Collections.min(intxns);
                if (!entryFractions.containsKey(lane) || (Double)entryFractions.get(lane) > min) {
                    entryFractions.put(lane, min);
                }
                double max = (Double)Collections.max(intxns);
                if (exitFractions.containsKey(lane) && !((Double)exitFractions.get(lane) < max)) continue;
                exitFractions.put(lane, max);
            }
        }
        this.lanes = intersectingLanes;
        this.area = new Area();
        this.areaPlus = new Area();
        for (Lane lane : this.lanes) {
            double exitFrac;
            double entryFrac;
            double expansionOffset = 4.0 / lane.getLength();
            if (strictIntersection.contains(lane.getStartPoint())) {
                entryFrac = 0.0;
            } else {
                entryFrac = Math.max(0.0, (Double)entryFractions.get(lane) - expansionOffset);
                this.entryPoints.put(lane, new WayPoint(lane.getPointAtNormalizedDistance(entryFrac)));
                this.entryHeadings.put(lane, lane.getHeadingAtNormalizedDistance(entryFrac));
            }
            if (strictIntersection.contains(lane.getEndPoint())) {
                exitFrac = 1.0;
            } else {
                exitFrac = Math.min(1.0, (Double)exitFractions.get(lane) + expansionOffset);
                this.exitPoints.put(lane, new WayPoint(lane.getPointAtNormalizedDistance(exitFrac)));
                this.exitHeadings.put(lane, lane.getHeadingAtNormalizedDistance(exitFrac));
            }
            this.area.add(new Area(lane.getShape(entryFrac, exitFrac)));
            this.areaPlus.add(new Area(lane.getShape(entryFrac - 1.0E-6, exitFrac + 1.0E-6)));
        }
        this.area = GeomMath.filledArea(this.area);
        this.areaPlus = GeomMath.filledArea(this.areaPlus);
    }

    private void calcWayPoints() {
        TreeMap<Double, Point2D> circumferentialPointsByAngle = new TreeMap<Double, Point2D>();
        for (Point2D point2D : this.exitPoints.values()) {
            circumferentialPointsByAngle.put(GeomMath.angleToPoint(point2D, this.centroid), point2D);
        }
        for (Point2D point2D : this.entryPoints.values()) {
            circumferentialPointsByAngle.put(GeomMath.angleToPoint(point2D, this.centroid), point2D);
        }
        for (Point2D point2D : circumferentialPointsByAngle.values()) {
            this.points.add(point2D);
        }
    }

    private void calcEdges() {
        PathIterator iter = this.area.getBounds2D().getPathIterator(null);
        double[] coords = new double[6];
        double px = 0.0;
        double py = 0.0;
        Path2D.Double edge = null;
        while (!iter.isDone()) {
            int type = iter.currentSegment(coords);
            switch (type) {
                case 0: {
                    assert (edge == null);
                    px = coords[0];
                    py = coords[1];
                    break;
                }
                case 1: {
                    edge = new Path2D.Double();
                    ((Path2D)edge).moveTo(px, py);
                    ((Path2D)edge).lineTo(coords[0], coords[1]);
                    px = coords[0];
                    py = coords[1];
                    this.edges.add(edge);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new RuntimeException("RoadBasedIntersection::calcEdges(): unknown path iterator type.");
                }
            }
            iter.next();
        }
    }

    private void addWayPointsPath() {
        Path2D gp = null;
        for (Point2D p : this.points) {
            if (gp == null) {
                gp = new GeneralPath();
                ((Path2D.Float)gp).moveTo((float)p.getX(), (float)p.getY());
                continue;
            }
            ((Path2D.Float)gp).lineTo((float)p.getX(), (float)p.getY());
        }
        gp.closePath();
        this.area.add(new Area(gp));
    }

    @Override
    public List<Road> getRoads() {
        return this.roads;
    }

    @Override
    public List<Lane> getLanes() {
        return this.lanes;
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public Area getAreaPlus() {
        return this.areaPlus;
    }

    @Override
    public Point2D getCentroid() {
        return this.centroid;
    }

    @Override
    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public List<Path2D> getEdges() {
        return this.edges;
    }

    @Override
    public List<Road> getEntryRoads() {
        return this.entryRoads;
    }

    private void calcEntryRoads() {
        for (Lane lane : this.getEntryLanes()) {
            if (this.entryRoads.contains(Debug.currentMap.getRoad(lane))) continue;
            this.entryRoads.add(Debug.currentMap.getRoad(lane));
        }
    }

    @Override
    public List<Lane> getEntryLanes() {
        return new ArrayList<Lane>(this.entryPoints.keySet());
    }

    @Override
    public boolean isEnteredBy(Lane l) {
        return this.entryPoints.containsKey(l);
    }

    @Override
    public WayPoint getEntryPoint(Lane l) {
        return this.entryPoints.get(l);
    }

    @Override
    public double getEntryHeading(Lane l) {
        return this.entryHeadings.get(l);
    }

    @Override
    public List<Road> getExitRoads() {
        return this.exitRoads;
    }

    private void calcExitRoads() {
        for (Lane lane : this.getExitLanes()) {
            if (this.exitRoads.contains(Debug.currentMap.getRoad(lane))) continue;
            this.exitRoads.add(Debug.currentMap.getRoad(lane));
        }
    }

    @Override
    public List<Lane> getExitLanes() {
        return new ArrayList<Lane>(this.exitPoints.keySet());
    }

    @Override
    public boolean isExitedBy(Lane l) {
        return this.exitPoints.containsKey(l);
    }

    @Override
    public WayPoint getExitPoint(Lane l) {
        return this.exitPoints.get(l);
    }

    @Override
    public double getExitHeading(Lane l) {
        return this.exitHeadings.get(l);
    }

    @Override
    public Constants.TurnDirection calcTurnDirection(Lane currentLane, Lane departureLane) {
        Road currentRoad = Debug.currentMap.getRoad(currentLane);
        Road departureRoad = Debug.currentMap.getRoad(departureLane);
        if (departureRoad == currentRoad) {
            return Constants.TurnDirection.STRAIGHT;
        }
        if (departureRoad == currentRoad.getDual()) {
            return Constants.TurnDirection.U_TURN;
        }
        double entryHeading = this.getEntryHeading(currentLane);
        double exitHeading = this.getExitHeading(departureLane);
        double theta = GeomMath.canonicalAngle(exitHeading - entryHeading);
        if (Util.isDoubleZero(theta)) {
            return Constants.TurnDirection.STRAIGHT;
        }
        if (theta < Math.PI) {
            return Constants.TurnDirection.LEFT;
        }
        if (theta > Math.PI) {
            return Constants.TurnDirection.RIGHT;
        }
        return Constants.TurnDirection.U_TURN;
    }
}

