/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.RequestHandler;

import aim4.config.TrafficSignal;
import aim4.im.v2i.RequestHandler.TrafficSignalRequestHandler;
import aim4.im.v2i.policy.BasePolicy;
import aim4.im.v2i.policy.BasePolicyCallback;
import aim4.msg.i2v.Reject;
import aim4.msg.v2i.Request;
import aim4.sim.StatCollector;
import java.util.List;

public class Approx4PhasesTrafficSignalRequestHandler
implements TrafficSignalRequestHandler {
    private static final double DEFAULT_GREEN_LIGHT_DURATION = 15.0;
    private static final double DEFAULT_YELLOW_LIGHT_DURATION = 5.0;
    private double greenLightDuration = 15.0;
    private double yellowLightDuration = 5.0;
    private BasePolicyCallback basePolicy;

    public Approx4PhasesTrafficSignalRequestHandler(double greenLightDuration, double yellowLightDuration) {
        this.greenLightDuration = greenLightDuration;
        this.yellowLightDuration = yellowLightDuration;
    }

    public void setGreenLightDuration(double greenLightDuration) {
        this.greenLightDuration = greenLightDuration;
    }

    public void setYellowLightDuration(double yellowLightDuration) {
        this.yellowLightDuration = yellowLightDuration;
    }

    @Override
    public void setBasePolicyCallback(BasePolicyCallback basePolicy) {
        this.basePolicy = basePolicy;
    }

    @Override
    public void act(double timeStep) {
    }

    @Override
    public void processRequestMsg(Request msg) {
        List<Request.Proposal> proposals;
        int vin = msg.getVin();
        if (this.basePolicy.hasReservation(vin)) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.CONFIRMED_ANOTHER_REQUEST);
            return;
        }
        BasePolicy.ProposalFilterResult filterResult = BasePolicy.standardProposalsFilter(msg.getProposals(), this.basePolicy.getCurrentTime());
        if (filterResult.isNoProposalLeft()) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), filterResult.getReason());
        }
        if (!this.canEnterFromLane((proposals = filterResult.getProposals()).get(0).getArrivalLaneID())) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
            return;
        }
        BasePolicy.ReserveParam reserveParam = this.basePolicy.findReserveParam(msg, proposals);
        if (reserveParam != null) {
            this.basePolicy.sendComfirmMsg(msg.getRequestId(), reserveParam);
        } else {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
        }
    }

    @Override
    public StatCollector<?> getStatCollector() {
        return null;
    }

    @Override
    public TrafficSignal getSignal(int laneId) {
        double period = this.greenLightDuration + this.yellowLightDuration;
        int id = (int)Math.floor(this.basePolicy.getCurrentTime() / period);
        double t = this.basePolicy.getCurrentTime() - (double)id * period;
        int phaseId = id % 4;
        boolean canPass = false;
        if (phaseId == 0) {
            canPass = laneId == 9 || laneId == 6;
        } else if (phaseId == 1) {
            canPass = laneId == 7 || laneId == 8 || laneId == 10 || laneId == 11;
        } else if (phaseId == 2) {
            canPass = laneId == 0 || laneId == 3;
        } else if (phaseId == 3) {
            canPass = laneId == 4 || laneId == 5 || laneId == 1 || laneId == 2;
        } else {
            throw new RuntimeException("Error in isGreenTrafficLightNow()");
        }
        if (canPass) {
            if (t <= this.greenLightDuration) {
                return TrafficSignal.GREEN;
            }
            return TrafficSignal.YELLOW;
        }
        return TrafficSignal.RED;
    }

    private boolean canEnterFromLane(int laneId) {
        if (laneId == 2 || laneId == 11 || laneId == 5 || laneId == 8) {
            return true;
        }
        double period = this.greenLightDuration + this.yellowLightDuration;
        int id = (int)Math.floor(this.basePolicy.getCurrentTime() / period);
        double t = this.basePolicy.getCurrentTime() - (double)id * period;
        if (t <= this.greenLightDuration) {
            int phaseId = id % 4;
            if (phaseId == 0) {
                return laneId == 9 || laneId == 6;
            }
            if (phaseId == 1) {
                return laneId == 7 || laneId == 10;
            }
            if (phaseId == 2) {
                return laneId == 0 || laneId == 3;
            }
            if (phaseId == 3) {
                return laneId == 4 || laneId == 1;
            }
            throw new RuntimeException("Error in isGreenTrafficLightNow()");
        }
        return false;
    }
}

