/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.RequestHandler;

import aim4.config.TrafficSignal;
import aim4.im.v2i.RequestHandler.TrafficSignalRequestHandler;
import aim4.im.v2i.policy.BasePolicy;
import aim4.im.v2i.policy.BasePolicyCallback;
import aim4.msg.i2v.Reject;
import aim4.msg.v2i.Request;
import aim4.sim.StatCollector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApproxNPhasesTrafficSignalRequestHandler
implements TrafficSignalRequestHandler {
    private Map<Integer, SignalController> signalControllers = new HashMap<Integer, SignalController>();
    private BasePolicyCallback basePolicy;

    @Override
    public void act(double timeStep) {
    }

    @Override
    public void setBasePolicyCallback(BasePolicyCallback basePolicy) {
        this.basePolicy = basePolicy;
    }

    public void setSignalControllers(int laneId, SignalController signalController) {
        this.signalControllers.put(laneId, signalController);
    }

    @Override
    public void processRequestMsg(Request msg) {
        List<Request.Proposal> proposals;
        int vin = msg.getVin();
        if (this.basePolicy.hasReservation(vin)) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.CONFIRMED_ANOTHER_REQUEST);
            return;
        }
        BasePolicy.ProposalFilterResult filterResult = BasePolicy.standardProposalsFilter(msg.getProposals(), this.basePolicy.getCurrentTime());
        if (filterResult.isNoProposalLeft()) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), filterResult.getReason());
        }
        if (!this.canEnterFromLane((proposals = filterResult.getProposals()).get(0).getArrivalLaneID(), proposals.get(0).getDepartureLaneID())) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
            return;
        }
        BasePolicy.ReserveParam reserveParam = this.basePolicy.findReserveParam(msg, proposals);
        if (reserveParam != null) {
            this.basePolicy.sendComfirmMsg(msg.getRequestId(), reserveParam);
        } else {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
        }
    }

    @Override
    public TrafficSignal getSignal(int laneId) {
        return this.signalControllers.get(laneId).getSignal(this.basePolicy.getCurrentTime());
    }

    private boolean canEnterFromLane(int arrivalLaneId, int departureLaneId) {
        if (this.getSignal(arrivalLaneId) == TrafficSignal.GREEN) {
            return true;
        }
        if (arrivalLaneId == 2 && departureLaneId == 8) {
            return true;
        }
        if (arrivalLaneId == 11 && departureLaneId == 2) {
            return true;
        }
        if (arrivalLaneId == 5 && departureLaneId == 11) {
            return true;
        }
        return arrivalLaneId == 8 && departureLaneId == 5;
    }

    @Override
    public StatCollector<?> getStatCollector() {
        return null;
    }

    public static class CyclicSignalController
    implements SignalController {
        private double[] durations;
        private TrafficSignal[] signals;
        private double durationOffset;
        private double totalDuration;

        public CyclicSignalController(double[] durations, TrafficSignal[] signals) {
            this(durations, signals, 0.0);
        }

        public CyclicSignalController(double[] durations, TrafficSignal[] signals, double durationOffset) {
            this.durations = (double[])durations.clone();
            this.signals = (TrafficSignal[])signals.clone();
            this.durationOffset = durationOffset;
            this.totalDuration = 0.0;
            for (double d : durations) {
                this.totalDuration += d;
            }
        }

        @Override
        public TrafficSignal getSignal(double time) {
            double d = time - Math.floor((time + this.durationOffset) / this.totalDuration) * this.totalDuration;
            assert (0.0 <= d && d < this.totalDuration);
            double maxd = 0.0;
            for (int i = 0; i < this.durations.length; ++i) {
                if (!(d < (maxd += this.durations[i]))) continue;
                return this.signals[i];
            }
            assert (false) : "Error in CyclicLightController()";
            return null;
        }
    }

    public static interface SignalController {
        public TrafficSignal getSignal(double var1);
    }
}

