/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.RequestHandler;

import aim4.config.Debug;
import aim4.im.v2i.RequestHandler.RequestHandler;
import aim4.im.v2i.batch.ReorderingStrategy;
import aim4.im.v2i.policy.BasePolicy;
import aim4.im.v2i.policy.BasePolicyCallback;
import aim4.msg.i2v.Reject;
import aim4.msg.v2i.Request;
import aim4.sim.StatCollector;
import aim4.util.Util;
import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public class BatchModeRequestHandler
implements RequestHandler {
    private static final boolean IS_HIGHLIGHT_VEHICLE_IN_BATCH = true;
    private static final Color VEHICLE_IN_BATCH_COLOR = Color.GREEN;
    private BasePolicyCallback basePolicy;
    private ReorderingStrategy reorderingStrategy;
    private int nextIndexedProposalId;
    private NavigableSet<IndexedProposal> queue;
    private double nextProcessingTime;
    private double nextProposalDeadline;
    private RequestStatCollector requestSC = null;
    private Set<Integer> lastVinInBatch = new HashSet<Integer>();

    public BatchModeRequestHandler(ReorderingStrategy reorderingStrategy) {
        this(reorderingStrategy, null);
    }

    public BatchModeRequestHandler(ReorderingStrategy reorderingStrategy, RequestStatCollector requestSC) {
        this.reorderingStrategy = reorderingStrategy;
        this.queue = new TreeSet<IndexedProposal>();
        this.requestSC = requestSC;
        this.nextIndexedProposalId = 0;
    }

    @Override
    public void setBasePolicyCallback(BasePolicyCallback basePolicy) {
        this.basePolicy = basePolicy;
        this.reorderingStrategy.setInitialTime(basePolicy.getCurrentTime());
        this.nextProcessingTime = this.reorderingStrategy.getNextProcessingTime();
        this.nextProposalDeadline = this.reorderingStrategy.getNextProposalDeadline();
    }

    @Override
    public void act(double timeStep) {
        if (Util.isDoubleEqualOrGreater(this.basePolicy.getCurrentTime(), this.nextProcessingTime)) {
            Set<Integer> vinInBatch = this.processBatch();
            for (int vin : this.lastVinInBatch) {
                Debug.removeVehicleColor(vin);
            }
            for (int vin : vinInBatch) {
                Debug.setVehicleColor(vin, VEHICLE_IN_BATCH_COLOR);
            }
            this.lastVinInBatch = vinInBatch;
            this.nextProcessingTime = this.reorderingStrategy.getNextProcessingTime();
            this.nextProposalDeadline = this.reorderingStrategy.getNextProposalDeadline();
            this.tryReserveForProposalsBeforeTime(this.nextProposalDeadline);
        }
    }

    @Override
    public void processRequestMsg(Request msg) {
        int vin = msg.getVin();
        if (this.requestSC != null) {
            this.requestSC.incrTotalNumOfRequest();
        }
        if (this.basePolicy.hasReservation(vin)) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.CONFIRMED_ANOTHER_REQUEST);
            if (this.requestSC != null) {
                this.requestSC.incrNumOfConfirmedAnotherRequest();
            }
            return;
        }
        this.removeProposalsByVIN(vin);
        double currentTime = this.basePolicy.getCurrentTime();
        List<Request.Proposal> proposals = msg.getProposals();
        BasePolicy.ProposalFilterResult filterResult = BasePolicy.standardProposalsFilter(proposals, currentTime);
        if (filterResult.isNoProposalLeft()) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), filterResult.getReason());
            return;
        }
        if (this.isAllProposalsLate(msg)) {
            BasePolicy.ReserveParam reserveParam = this.basePolicy.findReserveParam(msg, filterResult.getProposals());
            if (reserveParam != null) {
                this.basePolicy.sendComfirmMsg(msg.getRequestId(), reserveParam);
            } else {
                this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
            }
            if (this.requestSC != null) {
                this.requestSC.incrNumOfLateRequest();
            }
        } else {
            this.putProposalsIntoQueue(msg, currentTime);
            if (this.requestSC != null) {
                this.requestSC.incrNumOfQueuedRequest();
            }
        }
    }

    @Override
    public StatCollector<?> getStatCollector() {
        return this.requestSC;
    }

    private Set<Integer> processBatch() {
        HashSet<Integer> vinInBatch = new HashSet<Integer>();
        double currentTime = this.basePolicy.getCurrentTime();
        assert (this.queue.size() == 0 || ((IndexedProposal)this.queue.first()).getProposal().getArrivalTime() >= this.nextProposalDeadline);
        List<IndexedProposal> batch = this.reorderingStrategy.getBatch(currentTime, this.queue, this.basePolicy.getTrackMode());
        for (IndexedProposal iProposal : batch) {
            this.tryReserve(iProposal);
            vinInBatch.add(iProposal.getRequest().getVin());
        }
        return vinInBatch;
    }

    private void tryReserve(IndexedProposal iProposal) {
        ArrayList<Request.Proposal> l = new ArrayList<Request.Proposal>(1);
        l.add(iProposal.getProposal());
        Request msg = iProposal.getRequest();
        BasePolicy.ReserveParam reserveParam = this.basePolicy.findReserveParam(msg, l);
        if (reserveParam != null) {
            this.basePolicy.sendComfirmMsg(msg.getRequestId(), reserveParam);
            for (IndexedProposal iProposal2 : iProposal.getProposalGroup()) {
                this.queue.remove(iProposal2);
            }
        } else {
            this.queue.remove(iProposal);
            List<IndexedProposal> ipGroup = iProposal.getProposalGroup();
            if (ipGroup.remove(iProposal)) {
                if (ipGroup.isEmpty()) {
                    this.basePolicy.sendRejectMsg(msg.getVin(), msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
                }
            } else {
                throw new RuntimeException("BatchModeRequestHandler: Proposal Group error: unable to remove an indexed proposal.");
            }
        }
    }

    private void tryReserveForProposalsBeforeTime(double time) {
        IndexedProposal iProposal;
        Iterator<IndexedProposal> iter = this.queue.iterator();
        while (iter.hasNext() && (iProposal = iter.next()).getProposal().getArrivalTime() < time) {
            iter.remove();
            this.tryReserve(iProposal);
        }
    }

    private void removeProposalsByVIN(int vin) {
        IndexedProposal selectedIndexedProposal = null;
        for (IndexedProposal iProposal : this.queue) {
            if (iProposal.getRequest().getVin() != vin) continue;
            selectedIndexedProposal = iProposal;
        }
        if (selectedIndexedProposal != null) {
            for (IndexedProposal ip : selectedIndexedProposal.getProposalGroup()) {
                this.queue.remove(ip);
            }
        }
    }

    private boolean isAllProposalsLate(Request msg) {
        for (Request.Proposal proposal : msg.getProposals()) {
            if (!(proposal.getArrivalTime() >= this.nextProposalDeadline)) continue;
            return false;
        }
        return true;
    }

    private void putProposalsIntoQueue(Request msg, double currentTime) {
        LinkedList<IndexedProposal> proposalGroup = new LinkedList<IndexedProposal>();
        for (Request.Proposal proposal : msg.getProposals()) {
            if (!(proposal.getArrivalTime() >= this.nextProposalDeadline)) continue;
            IndexedProposal iProposal = new IndexedProposal(this.nextIndexedProposalId, proposal, msg, proposalGroup, currentTime);
            ++this.nextIndexedProposalId;
            proposalGroup.add(iProposal);
            this.queue.add(iProposal);
        }
    }

    public void printQueue() {
        boolean shouldPrintNextProcessingTime = true;
        boolean shouldPrintNextProposalDeadline = true;
        System.out.printf("--- Queue BEGIN ---\n", new Object[0]);
        for (IndexedProposal iProposal : this.queue) {
            double arrivalTime = iProposal.getProposal().getArrivalTime();
            if (shouldPrintNextProcessingTime && arrivalTime > this.nextProcessingTime) {
                System.out.printf("  --- nextBatchProcessingTime = %.2f ---\n", this.nextProcessingTime);
                shouldPrintNextProcessingTime = false;
            }
            if (shouldPrintNextProposalDeadline && arrivalTime > this.nextProposalDeadline) {
                System.out.printf("  --- nextProposalDeadline = %.2f ---\n", this.nextProposalDeadline);
                shouldPrintNextProposalDeadline = false;
            }
            int vin = iProposal.getRequest().getVin();
            System.out.printf("vin %d %s\n", vin, iProposal);
        }
        if (shouldPrintNextProcessingTime) {
            System.out.printf("  --- nextProcessingTime = %.2f ---\n", this.nextProcessingTime);
        }
        if (shouldPrintNextProposalDeadline) {
            System.out.printf("  --- nextProposalDeadline = %.2f ---\n", this.nextProposalDeadline);
        }
        System.out.printf("--- Queue END ---\n", new Object[0]);
    }

    public static class RequestStatCollector
    implements StatCollector<BatchModeRequestHandler> {
        int totalNumOfRequest = 0;
        int numOfConfirmedAnotherRequest = 0;
        int numOfLateRequest = 0;
        int numOfQueuedRequest = 0;

        public void incrTotalNumOfRequest() {
            ++this.totalNumOfRequest;
        }

        public void incrNumOfConfirmedAnotherRequest() {
            ++this.numOfConfirmedAnotherRequest;
        }

        public void incrNumOfLateRequest() {
            ++this.numOfLateRequest;
        }

        public void incrNumOfQueuedRequest() {
            ++this.numOfQueuedRequest;
        }

        @Override
        public void collect(BatchModeRequestHandler obj) {
        }

        @Override
        public void print(PrintStream outfile) {
            outfile.printf("totalNumOfRequest,%d\n", this.totalNumOfRequest);
            outfile.printf("numOfConfirmedAnotherRequest,%d\n", this.numOfConfirmedAnotherRequest);
            outfile.printf("numOfLateRequest,%d\n", this.numOfLateRequest);
            outfile.printf("numOfQueuedRequest,%d\n", this.numOfQueuedRequest);
        }
    }

    public static class IndexedProposal
    implements Comparator<IndexedProposal>,
    Comparable<IndexedProposal> {
        private int id;
        private Request.Proposal proposal;
        private Request request;
        private List<IndexedProposal> proposalGroup;
        private double submissionTime;

        public IndexedProposal(int id, Request.Proposal proposal, Request request, List<IndexedProposal> proposalGroup, double submissionTime) {
            this.id = id;
            this.proposal = proposal;
            this.request = request;
            this.proposalGroup = proposalGroup;
            this.submissionTime = submissionTime;
        }

        public Request.Proposal getProposal() {
            return this.proposal;
        }

        public Request getRequest() {
            return this.request;
        }

        public List<IndexedProposal> getProposalGroup() {
            return this.proposalGroup;
        }

        public double getSubmissionTime() {
            return this.submissionTime;
        }

        public boolean equals(IndexedProposal ip) {
            return this.id == ip.id && this.proposal.equals(ip.proposal);
        }

        @Override
        public int compare(IndexedProposal ip1, IndexedProposal ip2) {
            if (ip1.proposal.getArrivalTime() < ip2.proposal.getArrivalTime()) {
                return -1;
            }
            if (ip1.proposal.getArrivalTime() > ip2.proposal.getArrivalTime()) {
                return 1;
            }
            return ip1.id - ip2.id;
        }

        @Override
        public int compareTo(IndexedProposal ip) {
            return this.compare(this, ip);
        }

        public String toString() {
            return this.proposal.toString() + ":id" + this.id;
        }
    }
}

