/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.RequestHandler;

import aim4.im.v2i.RequestHandler.RequestHandler;
import aim4.im.v2i.policy.BasePolicy;
import aim4.im.v2i.policy.BasePolicyCallback;
import aim4.msg.i2v.Reject;
import aim4.msg.v2i.Request;
import aim4.sim.StatCollector;
import java.util.List;
import java.util.ListIterator;

public class GoStraightRequestHandler
implements RequestHandler {
    private static final double SWITCH_TIME_INTERVAL = 20.0;
    private BasePolicyCallback basePolicy;
    private double nextSwitchTime;
    private boolean isGoStraight;

    @Override
    public void setBasePolicyCallback(BasePolicyCallback basePolicy) {
        this.basePolicy = basePolicy;
        this.nextSwitchTime = basePolicy.getCurrentTime() + 20.0;
        this.isGoStraight = true;
    }

    @Override
    public void act(double timeStep) {
        if (this.basePolicy.getCurrentTime() > this.nextSwitchTime) {
            this.isGoStraight = !this.isGoStraight;
            this.nextSwitchTime = this.basePolicy.getCurrentTime() + 20.0;
        }
    }

    @Override
    public void processRequestMsg(Request msg) {
        int vin = msg.getVin();
        if (this.basePolicy.hasReservation(vin)) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.CONFIRMED_ANOTHER_REQUEST);
            return;
        }
        BasePolicy.ProposalFilterResult filterResult = BasePolicy.standardProposalsFilter(msg.getProposals(), this.basePolicy.getCurrentTime());
        if (filterResult.isNoProposalLeft()) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), filterResult.getReason());
        }
        List<Request.Proposal> proposals = filterResult.getProposals();
        this.removeProposalWithIncorrectTurnDirection(proposals);
        if (proposals.isEmpty()) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
            return;
        }
        BasePolicy.ReserveParam reserveParam = this.basePolicy.findReserveParam(msg, proposals);
        if (reserveParam != null) {
            this.basePolicy.sendComfirmMsg(msg.getRequestId(), reserveParam);
        } else {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
        }
    }

    @Override
    public StatCollector<?> getStatCollector() {
        return null;
    }

    private void removeProposalWithIncorrectTurnDirection(List<Request.Proposal> proposals) {
        ListIterator<Request.Proposal> tpIter = proposals.listIterator();
        while (tpIter.hasNext()) {
            Request.Proposal p = (Request.Proposal)tpIter.next();
            if (this.isGoStraight) {
                if (p.getArrivalLaneID() != p.getDepartureLaneID()) continue;
                tpIter.remove();
                continue;
            }
            if (p.getArrivalLaneID() == p.getDepartureLaneID()) continue;
            tpIter.remove();
        }
    }
}

