/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.reservation;

import java.util.HashMap;
import java.util.Map;

public class AdmissionControlZone {
    private static final double MIN_DIST_BETWEEN_VEHICLES = 0.5;
    private double maxSize;
    private double currentSize = 0.0;
    private Map<Integer, Double> vinToReservationLength = new HashMap<Integer, Double>();

    public AdmissionControlZone(double maxSize) {
        this.maxSize = maxSize;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public double getCurrentSize() {
        return this.currentSize;
    }

    public boolean isAdmissible(int vin, double vehicleLength, double stoppingDistance) {
        if (!this.vinToReservationLength.containsKey(vin)) {
            return this.currentSize + vehicleLength + stoppingDistance <= this.maxSize;
        }
        return false;
    }

    public void admit(int vin, double vehicleLength, double stoppingDistance) {
        double reservationLength;
        if (!this.vinToReservationLength.containsKey(vin)) {
            assert (this.currentSize + vehicleLength + stoppingDistance <= this.maxSize);
            reservationLength = vehicleLength + 0.5;
            this.currentSize += reservationLength;
        } else {
            throw new RuntimeException("Error in ACZ: admitting vehicle " + vin + " already not exists in ACZ.");
        }
        this.vinToReservationLength.put(vin, reservationLength);
    }

    public void cancel(int vin) {
        if (this.vinToReservationLength.containsKey(vin)) {
            this.currentSize -= this.vinToReservationLength.remove(vin).doubleValue();
        } else {
            throw new RuntimeException("Error in ACZ: canceling vehicle " + vin + " does not exist in ACZ.");
        }
    }

    public void away(int vin) {
        if (this.vinToReservationLength.containsKey(vin)) {
            this.currentSize -= this.vinToReservationLength.remove(vin).doubleValue();
        } else {
            throw new RuntimeException("Error in ACZ: departing vehicle " + vin + " does not exist in ACZ.");
        }
    }
}

