/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.reservation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class ReservationArray {
    private static final boolean SHOULD_CHECK_CONSISTENCY = false;
    private final int numOfTiles;
    private NavigableMap<Integer, int[]> grids;
    private NavigableMap<Integer, Map<Integer, Set<Integer>>> timeToRidToTid;
    private Map<Integer, NavigableMap<Integer, Set<Integer>>> ridToTimeToTid;

    public ReservationArray(int numOfTiles) {
        this.numOfTiles = numOfTiles;
        this.grids = new TreeMap<Integer, int[]>();
        this.timeToRidToTid = new TreeMap<Integer, Map<Integer, Set<Integer>>>();
        this.ridToTimeToTid = new HashMap<Integer, NavigableMap<Integer, Set<Integer>>>();
    }

    public int getNumberOfTiles() {
        return this.numOfTiles;
    }

    public boolean isReserved(int dt, int tid) {
        if (this.grids.containsKey(dt)) {
            return ((int[])this.grids.get(dt))[tid] >= 0;
        }
        return false;
    }

    public int getReservationId(int dt, int tid) {
        if (this.grids.containsKey(dt)) {
            return ((int[])this.grids.get(dt))[tid];
        }
        return -1;
    }

    public boolean hasReservation(int rid) {
        return this.ridToTimeToTid.containsKey(rid);
    }

    public int getLastReservedDiscreteTime() {
        try {
            return (Integer)this.grids.lastKey();
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    public int getLastReservedDiscreteTime(int rid) {
        if (this.ridToTimeToTid.containsKey(rid)) {
            try {
                return (Integer)this.ridToTimeToTid.get(rid).lastKey();
            }
            catch (NoSuchElementException e) {
                return -1;
            }
        }
        return -1;
    }

    public boolean reserve(int rid, Collection<? extends TimeTile> workingList) {
        for (TimeTile timeTile : workingList) {
            int n = timeTile.getDiscreteTime();
            if (!this.grids.containsKey(n) || ((int[])this.grids.get(n))[timeTile.getTileId()] < 0) continue;
            return false;
        }
        int timeBegin = 0;
        try {
            timeBegin = (Integer)this.grids.firstKey();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (TimeTile timeTile : workingList) {
            Set<Integer> tidSet;
            int dt = timeTile.getDiscreteTime();
            int tid = timeTile.getTileId();
            if (dt < timeBegin) continue;
            int[] grid = (int[])this.grids.get(dt);
            if (grid == null) {
                grid = new int[this.numOfTiles];
                for (int i = 0; i < this.numOfTiles; ++i) {
                    grid[i] = -1;
                }
                this.grids.put(dt, grid);
            }
            grid[tid] = rid;
            HashMap<Integer, HashSet<Integer>> ridToTid = (HashMap<Integer, HashSet<Integer>>)this.timeToRidToTid.get(dt);
            if (ridToTid == null) {
                ridToTid = new HashMap<Integer, HashSet<Integer>>();
                this.timeToRidToTid.put(dt, ridToTid);
            }
            if ((tidSet = (HashSet<Integer>)ridToTid.get(rid)) == null) {
                tidSet = new HashSet<Integer>();
                ridToTid.put(rid, (HashSet<Integer>)tidSet);
            }
            tidSet.add(tid);
            NavigableMap<Integer, Set<Integer>> timeToTid = this.ridToTimeToTid.get(rid);
            if (timeToTid == null) {
                timeToTid = new TreeMap<Integer, Set<Integer>>();
                this.ridToTimeToTid.put(rid, timeToTid);
            }
            if ((tidSet = (Set)timeToTid.get(dt)) == null) {
                tidSet = new HashSet();
                timeToTid.put(dt, tidSet);
            }
            tidSet.add(tid);
        }
        return true;
    }

    public boolean cancel(int rid) {
        NavigableMap<Integer, Set<Integer>> timeToTid = this.ridToTimeToTid.remove(rid);
        if (timeToTid != null) {
            Iterator iterator = timeToTid.keySet().iterator();
            while (iterator.hasNext()) {
                int dt = (Integer)iterator.next();
                if (this.timeToRidToTid.containsKey(dt)) {
                    ((Map)this.timeToRidToTid.get(dt)).remove(rid);
                }
                if (!this.grids.containsKey(dt)) continue;
                int[] grid = (int[])this.grids.get(dt);
                Iterator iterator2 = ((Set)timeToTid.get(dt)).iterator();
                while (iterator2.hasNext()) {
                    int tid = (Integer)iterator2.next();
                    grid[tid] = -1;
                }
            }
            return true;
        }
        return false;
    }

    public void cleanUp(int dt) {
        try {
            while ((Integer)this.grids.firstKey() < dt) {
                int dt1 = (Integer)this.grids.firstKey();
                this.grids.remove(dt1);
                this.timeToRidToTid.remove(dt1);
            }
        }
        catch (NoSuchElementException dt1) {
            // empty catch block
        }
        LinkedList<Integer> removeRid = new LinkedList<Integer>();
        for (int rid : this.ridToTimeToTid.keySet()) {
            NavigableMap<Integer, Set<Integer>> timeToTid = this.ridToTimeToTid.get(rid);
            try {
                while ((Integer)timeToTid.firstKey() < dt) {
                    timeToTid.remove(timeToTid.firstKey());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (!timeToTid.isEmpty()) continue;
            removeRid.add(rid);
        }
        for (int rid : removeRid) {
            this.ridToTimeToTid.remove(rid);
        }
    }

    public List<Integer> getReservedTilesAtTime(int dt) {
        Map ridToTid = (Map)this.timeToRidToTid.get(dt);
        if (ridToTid != null) {
            LinkedList<Integer> dts = new LinkedList<Integer>();
            Iterator iterator = ridToTid.keySet().iterator();
            while (iterator.hasNext()) {
                int rid = (Integer)iterator.next();
                dts.addAll((Collection)ridToTid.get(rid));
            }
            return dts;
        }
        return new LinkedList<Integer>();
    }

    public Set<Integer> getVinOfReservedTilesAtTime(int dt) {
        Map ridToTid = (Map)this.timeToRidToTid.get(dt);
        if (ridToTid != null) {
            return Collections.unmodifiableSet(ridToTid.keySet());
        }
        return new HashSet<Integer>();
    }

    private boolean checkConsistency() {
        int tid;
        Iterator iterator;
        int rid;
        int dt;
        Iterator<Object> iterator2 = this.grids.keySet().iterator();
        while (iterator2.hasNext()) {
            dt = (Integer)iterator2.next();
            int[] tids = (int[])this.grids.get(dt);
            for (int tid2 = 0; tid2 < this.numOfTiles; ++tid2) {
                rid = tids[tid2];
                if (rid < 0) continue;
                assert (this.timeToRidToTid.get(dt) != null);
                assert (((Map)this.timeToRidToTid.get(dt)).get(rid) != null);
                if (!((Set)((Map)this.timeToRidToTid.get(dt)).get(rid)).contains(tid2)) {
                    throw new RuntimeException("ReservationArray::checkConsistency():grids > timeToRidToTid");
                }
                assert (this.ridToTimeToTid.get(rid) != null);
                assert (this.ridToTimeToTid.get(rid).get(dt) != null);
                if (((Set)this.ridToTimeToTid.get(rid).get(dt)).contains(tid2)) continue;
                throw new RuntimeException("ReservationArray::checkConsistency():grids > ridToTimeToTid");
            }
        }
        iterator2 = this.timeToRidToTid.keySet().iterator();
        while (iterator2.hasNext()) {
            dt = (Integer)iterator2.next();
            Map ridToTid = (Map)this.timeToRidToTid.get(dt);
            Iterator iterator3 = ridToTid.keySet().iterator();
            while (iterator3.hasNext()) {
                rid = (Integer)iterator3.next();
                iterator = ((Set)ridToTid.get(rid)).iterator();
                while (iterator.hasNext()) {
                    tid = (Integer)iterator.next();
                    if (((int[])this.grids.get(dt))[tid] == rid) continue;
                    throw new RuntimeException("ReservationArray::checkConsistency():timeToRidToTid > grids");
                }
            }
        }
        iterator2 = this.ridToTimeToTid.keySet().iterator();
        while (iterator2.hasNext()) {
            int rid2 = (Integer)iterator2.next();
            NavigableMap<Integer, Set<Integer>> timeToTid = this.ridToTimeToTid.get(rid2);
            Iterator iterator4 = timeToTid.keySet().iterator();
            while (iterator4.hasNext()) {
                int dt2 = (Integer)iterator4.next();
                iterator = ((Set)timeToTid.get(dt2)).iterator();
                while (iterator.hasNext()) {
                    tid = (Integer)iterator.next();
                    if (((int[])this.grids.get(dt2))[tid] == rid2) continue;
                    throw new RuntimeException("ReservationArray::checkConsistency():ridToTimeToTid > grids");
                }
            }
        }
        return true;
    }

    public static class TimeTile {
        private int dt;
        private int tid;

        public TimeTile(int dt, int tid) {
            this.dt = dt;
            this.tid = tid;
        }

        public int getTileId() {
            return this.tid;
        }

        public int getDiscreteTime() {
            return this.dt;
        }

        public boolean equals(TimeTile tt) {
            return this.tid == tt.tid && this.dt == tt.dt;
        }

        public String toString() {
            return "TT(" + this.tid + "," + this.dt + ")";
        }
    }
}

