/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.reservation;

import aim4.config.Constants;
import aim4.im.v2i.reservation.ReservationArray;
import java.util.List;
import java.util.Set;

public class ReservationGrid
extends ReservationArray {
    private static final int TILE_RESERVATION_TABLE_CLEAN_UP_PERIOD = 30;
    private final int xNum;
    private final int yNum;
    private final double gridTimeStep;

    public ReservationGrid(int xNum, int yNum, double gridTimeStep) {
        super(xNum * yNum);
        this.xNum = xNum;
        this.yNum = yNum;
        this.gridTimeStep = gridTimeStep;
    }

    public void cleanUp(double currentTime) {
        int currentDiscreteTime = this.calcDiscreteTime(currentTime);
        if (currentDiscreteTime % 30 == 0) {
            this.cleanUp(currentDiscreteTime);
        }
    }

    public int getXnum() {
        return this.xNum;
    }

    public int getYnum() {
        return this.yNum;
    }

    public int calcX(int tid) {
        return tid % this.xNum;
    }

    public int calcY(int tid) {
        return tid / this.xNum;
    }

    public int calcTileId(int x, int y) {
        return x + y * this.xNum;
    }

    public int getxNum() {
        return this.xNum;
    }

    public int getyNum() {
        return this.yNum;
    }

    public double getGridTimeStep() {
        return this.gridTimeStep;
    }

    public int calcDiscreteTime(double time) {
        return (int)(time / this.gridTimeStep);
    }

    public double calcRemainingTime(double time) {
        return time - this.gridTimeStep * (double)this.calcDiscreteTime(time);
    }

    public double calcTime(int discreteTime) {
        return (double)discreteTime * this.gridTimeStep;
    }

    public double getLastReservedTime() {
        return (double)super.getLastReservedDiscreteTime() * this.gridTimeStep;
    }

    public List<Integer> getReservedTilesAtTime(double time) {
        return super.getReservedTilesAtTime(this.calcDiscreteTime(time));
    }

    public Set<Integer> getVinOfReservedTilesAtTime(double time) {
        return super.getVinOfReservedTilesAtTime(this.calcDiscreteTime(time));
    }

    public class TimeTile
    extends ReservationArray.TimeTile {
        public TimeTile(int dt, int tid) {
            super(dt, tid);
        }

        public double getTime() {
            return (double)this.getDiscreteTime() * ReservationGrid.this.gridTimeStep;
        }

        @Override
        public String toString() {
            return "TT(" + this.getTileId() + "," + Constants.TWO_DEC.format(this.getTime()) + ")";
        }
    }
}

