/*
 * Decompiled with CFR 0.152.
 */
package aim4.map;

import aim4.vehicle.VehicleSimView;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataCollectionLine {
    private static final double NO_REPEAT_TIME_PERIOD = 1.0;
    private String name;
    private int id;
    private Line2D line;
    private Map<Integer, List<Double>> vinToTime;
    private boolean isNoRepeat;

    public DataCollectionLine(String name, int id, Point2D p1, Point2D p2, boolean isNoRepeat) {
        this.name = name;
        this.id = id;
        this.vinToTime = new HashMap<Integer, List<Double>>();
        this.line = new Line2D.Double(p1, p2);
        this.isNoRepeat = isNoRepeat;
    }

    public Shape getShape() {
        return this.line;
    }

    public boolean intersect(VehicleSimView v, double time, Point2D p1, Point2D p2) {
        int vin = v.getVIN();
        if (!this.isNoRepeat || !this.vinToTime.containsKey(vin) || this.vinToTime.get(vin).get(this.vinToTime.get(vin).size() - 1) + 1.0 < time) {
            if (this.line.intersectsLine(p1.getX(), p1.getY(), p2.getX(), p2.getY())) {
                if (!this.vinToTime.containsKey(vin)) {
                    LinkedList<Double> times = new LinkedList<Double>();
                    times.add(time);
                    this.vinToTime.put(vin, times);
                } else {
                    this.vinToTime.get(vin).add(time);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Set<Integer> getAllVIN() {
        return this.vinToTime.keySet();
    }

    public List<Double> getTimes(int vin) {
        return this.vinToTime.get(vin);
    }
}

