/*
 * Decompiled with CFR 0.152.
 */
package aim4.map;

import aim4.config.Debug;
import aim4.config.TrafficSignalPhase;
import aim4.im.RoadBasedIntersection;
import aim4.im.RoadBasedTrackModel;
import aim4.im.v2i.RequestHandler.Approx4PhasesTrafficSignalRequestHandler;
import aim4.im.v2i.RequestHandler.ApproxNPhasesTrafficSignalRequestHandler;
import aim4.im.v2i.RequestHandler.ApproxSimpleTrafficSignalRequestHandler;
import aim4.im.v2i.RequestHandler.ApproxStopSignRequestHandler;
import aim4.im.v2i.RequestHandler.BatchModeRequestHandler;
import aim4.im.v2i.RequestHandler.FCFSRequestHandler;
import aim4.im.v2i.V2IManager;
import aim4.im.v2i.batch.RoadBasedReordering;
import aim4.im.v2i.policy.BasePolicy;
import aim4.im.v2i.reservation.ReservationGridManager;
import aim4.map.GridMap;
import aim4.map.Road;
import aim4.map.SpawnPoint;
import aim4.map.TrafficVolume;
import aim4.map.destination.DestinationSelector;
import aim4.map.destination.RandomDestinationSelector;
import aim4.map.destination.RatioDestinationSelector;
import aim4.map.destination.TurnBasedDestinationSelector;
import aim4.map.lane.Lane;
import aim4.util.Util;
import aim4.vehicle.VehicleSpec;
import aim4.vehicle.VehicleSpecDatabase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class GridMapUtil {
    public static SpawnPoint.SpawnSpecGenerator nullSpawnSpecGenerator = new SpawnPoint.SpawnSpecGenerator(){

        @Override
        public List<SpawnPoint.SpawnSpec> act(SpawnPoint spawnPoint, double timeStep) {
            return new ArrayList<SpawnPoint.SpawnSpec>();
        }
    };

    public static void setFCFSManagers(GridMap layout, double currentTime, ReservationGridManager.Config config) {
        layout.removeAllManagers();
        for (int column = 0; column < layout.getColumns(); ++column) {
            for (int row = 0; row < layout.getRows(); ++row) {
                List<Road> roads = layout.getRoads(column, row);
                RoadBasedIntersection intersection = new RoadBasedIntersection(roads);
                RoadBasedTrackModel trajectoryModel = new RoadBasedTrackModel(intersection);
                V2IManager im = new V2IManager(intersection, trajectoryModel, currentTime, config, layout.getImRegistry());
                im.setPolicy(new BasePolicy(im, new FCFSRequestHandler()));
                layout.setManager(column, row, im);
            }
        }
    }

    public static void setBatchManagers(GridMap layout, double currentTime, ReservationGridManager.Config config, double processingInterval) {
        layout.removeAllManagers();
        for (int column = 0; column < layout.getColumns(); ++column) {
            for (int row = 0; row < layout.getRows(); ++row) {
                List<Road> roads = layout.getRoads(column, row);
                RoadBasedIntersection intersection = new RoadBasedIntersection(roads);
                RoadBasedTrackModel trajectoryModel = new RoadBasedTrackModel(intersection);
                V2IManager im = new V2IManager(intersection, trajectoryModel, currentTime, config, layout.getImRegistry());
                BatchModeRequestHandler rh = new BatchModeRequestHandler(new RoadBasedReordering(processingInterval), new BatchModeRequestHandler.RequestStatCollector());
                im.setPolicy(new BasePolicy(im, rh));
                layout.setManager(column, row, im);
            }
        }
    }

    public static void setApproxSimpleTrafficLightManagers(GridMap layout, double currentTime, ReservationGridManager.Config config, double greenLightDuration, double yellowLightDuration) {
        layout.removeAllManagers();
        for (int column = 0; column < layout.getColumns(); ++column) {
            for (int row = 0; row < layout.getRows(); ++row) {
                List<Road> roads = layout.getRoads(column, row);
                RoadBasedIntersection intersection = new RoadBasedIntersection(roads);
                RoadBasedTrackModel trajectoryModel = new RoadBasedTrackModel(intersection);
                V2IManager im = new V2IManager(intersection, trajectoryModel, currentTime, config, layout.getImRegistry());
                ApproxSimpleTrafficSignalRequestHandler requestHandler = new ApproxSimpleTrafficSignalRequestHandler(greenLightDuration, yellowLightDuration);
                im.setPolicy(new BasePolicy(im, requestHandler));
                layout.setManager(column, row, im);
            }
        }
    }

    public static void setApprox4PhasesTrafficLightManagers(GridMap layout, double currentTime, ReservationGridManager.Config config, double greenLightDuration, double yellowLightDuration) {
        layout.removeAllManagers();
        for (int column = 0; column < layout.getColumns(); ++column) {
            for (int row = 0; row < layout.getRows(); ++row) {
                List<Road> roads = layout.getRoads(column, row);
                RoadBasedIntersection intersection = new RoadBasedIntersection(roads);
                RoadBasedTrackModel trajectoryModel = new RoadBasedTrackModel(intersection);
                V2IManager im = new V2IManager(intersection, trajectoryModel, currentTime, config, layout.getImRegistry());
                Approx4PhasesTrafficSignalRequestHandler requestHandler = new Approx4PhasesTrafficSignalRequestHandler(greenLightDuration, yellowLightDuration);
                im.setPolicy(new BasePolicy(im, requestHandler));
                layout.setManager(column, row, im);
            }
        }
    }

    public static void setApproxNPhasesTrafficLightManagers(GridMap layout, double currentTime, ReservationGridManager.Config config, String trafficSignalPhaseFileName) {
        layout.removeAllManagers();
        for (int column = 0; column < layout.getColumns(); ++column) {
            for (int row = 0; row < layout.getRows(); ++row) {
                List<Road> roads = layout.getRoads(column, row);
                RoadBasedIntersection intersection = new RoadBasedIntersection(roads);
                RoadBasedTrackModel trajectoryModel = new RoadBasedTrackModel(intersection);
                V2IManager im = new V2IManager(intersection, trajectoryModel, currentTime, config, layout.getImRegistry());
                ApproxNPhasesTrafficSignalRequestHandler requestHandler = new ApproxNPhasesTrafficSignalRequestHandler();
                TrafficSignalPhase phase = TrafficSignalPhase.makeFromFile(layout, trafficSignalPhaseFileName);
                for (Road road : im.getIntersection().getEntryRoads()) {
                    for (Lane lane : road.getLanes()) {
                        ApproxNPhasesTrafficSignalRequestHandler.CyclicSignalController controller = phase.calcCyclicSignalController(road);
                        requestHandler.setSignalControllers(lane.getId(), controller);
                    }
                }
                im.setPolicy(new BasePolicy(im, requestHandler));
                layout.setManager(column, row, im);
            }
        }
    }

    public static void setApproxStopSignManagers(GridMap layout, double currentTime, ReservationGridManager.Config config) {
        layout.removeAllManagers();
        for (int column = 0; column < layout.getColumns(); ++column) {
            for (int row = 0; row < layout.getRows(); ++row) {
                List<Road> roads = layout.getRoads(column, row);
                RoadBasedIntersection intersection = new RoadBasedIntersection(roads);
                RoadBasedTrackModel trajectoryModel = new RoadBasedTrackModel(intersection);
                V2IManager im = new V2IManager(intersection, trajectoryModel, currentTime, config, layout.getImRegistry());
                ApproxStopSignRequestHandler requestHandler = new ApproxStopSignRequestHandler();
                im.setPolicy(new BasePolicy(im, requestHandler));
                layout.setManager(column, row, im);
            }
        }
    }

    public static void setUniformRandomSpawnPoints(GridMap map, double trafficLevel) {
        for (SpawnPoint sp : map.getSpawnPoints()) {
            sp.setVehicleSpecChooser(new UniformSpawnSpecGenerator(trafficLevel, new RandomDestinationSelector(map)));
        }
    }

    public static void setUniformTurnBasedSpawnPoints(GridMap map, double trafficLevel) {
        for (SpawnPoint sp : map.getSpawnPoints()) {
            sp.setVehicleSpecChooser(new UniformSpawnSpecGenerator(trafficLevel, new TurnBasedDestinationSelector(map)));
        }
    }

    public static void setUniformRatioSpawnPoints(GridMap map, String trafficVolumeFileName) {
        TrafficVolume trafficVolume = TrafficVolume.makeFromFile(map, trafficVolumeFileName);
        RatioDestinationSelector selector = new RatioDestinationSelector(map, trafficVolume);
        for (SpawnPoint sp : map.getSpawnPoints()) {
            int laneId = sp.getLane().getId();
            double trafficLevel = trafficVolume.getLeftTurnVolume(laneId) + trafficVolume.getThroughVolume(laneId) + trafficVolume.getRightTurnVolume(laneId);
            sp.setVehicleSpecChooser(new UniformSpawnSpecGenerator(trafficLevel, selector));
        }
    }

    public static void setDirectionalSpawnPoints(GridMap layout, double hTrafficLevel, double vTrafficLevel) {
        for (SpawnPoint sp : layout.getHorizontalSpawnPoints()) {
            sp.setVehicleSpecChooser(new UniformSpawnSpecGenerator(hTrafficLevel, new RandomDestinationSelector(layout)));
        }
        for (SpawnPoint sp : layout.getVerticalSpawnPoints()) {
            sp.setVehicleSpecChooser(new UniformSpawnSpecGenerator(vTrafficLevel, new RandomDestinationSelector(layout)));
        }
    }

    public static void setBaselineSpawnPoints(GridMap layout, double traversalTime) {
        int totalNumOfLanes = 0;
        int minNumOfLanes = Integer.MAX_VALUE;
        for (Road r : layout.getRoads()) {
            int n = r.getLanes().size();
            totalNumOfLanes += n;
            if (n >= minNumOfLanes) continue;
            minNumOfLanes = n;
        }
        double numOfTraversals = VehicleSpecDatabase.getNumOfSpec() * (totalNumOfLanes - minNumOfLanes);
        for (SpawnPoint sp : layout.getSpawnPoints()) {
            sp.setVehicleSpecChooser(new EnumerateSpawnSpecGenerator(sp, layout.getDestinationRoads(), (double)sp.getLane().getId() * traversalTime * numOfTraversals, traversalTime));
        }
    }

    public static class EnumerateSpawnSpecGenerator
    implements SpawnPoint.SpawnSpecGenerator {
        private List<Road> destinationRoads;
        int vehicleSpecId;
        int destinationRoadId;
        double nextSpawnTime;
        double spawnPeriod;

        public EnumerateSpawnSpecGenerator(SpawnPoint spawnPoint, List<Road> destinationRoads, double initSpawnTime, double spawnPeriod) {
            this.destinationRoads = new ArrayList<Road>(destinationRoads.size());
            for (Road road : destinationRoads) {
                if (Debug.currentMap.getRoad(spawnPoint.getLane()).getDual() == road) continue;
                this.destinationRoads.add(road);
            }
            this.vehicleSpecId = 0;
            this.destinationRoadId = 0;
            this.nextSpawnTime = initSpawnTime;
            this.spawnPeriod = spawnPeriod;
        }

        @Override
        public List<SpawnPoint.SpawnSpec> act(SpawnPoint spawnPoint, double timeStep) {
            ArrayList<SpawnPoint.SpawnSpec> result = new ArrayList<SpawnPoint.SpawnSpec>(1);
            if (spawnPoint.getCurrentTime() >= this.nextSpawnTime && this.vehicleSpecId < VehicleSpecDatabase.getNumOfSpec()) {
                VehicleSpec vehicleSpec = VehicleSpecDatabase.getVehicleSpecById(this.vehicleSpecId);
                Road destinationRoad = this.destinationRoads.get(this.destinationRoadId);
                result.add(new SpawnPoint.SpawnSpec(spawnPoint.getCurrentTime(), vehicleSpec, destinationRoad));
                this.nextSpawnTime += this.spawnPeriod;
                ++this.destinationRoadId;
                if (this.destinationRoadId >= this.destinationRoads.size()) {
                    this.destinationRoadId = 0;
                    ++this.vehicleSpecId;
                }
            }
            return result;
        }
    }

    public static class OnlyOneSpawnSpecGenerator
    implements SpawnPoint.SpawnSpecGenerator {
        private VehicleSpec vehicleSpec;
        private Road destinationRoad;
        private boolean isDone;

        public OnlyOneSpawnSpecGenerator(int vehicleSpecId, Road destinationRoad) {
            this.vehicleSpec = VehicleSpecDatabase.getVehicleSpecById(vehicleSpecId);
            this.destinationRoad = destinationRoad;
            this.isDone = false;
        }

        @Override
        public List<SpawnPoint.SpawnSpec> act(SpawnPoint spawnPoint, double timeStep) {
            ArrayList<SpawnPoint.SpawnSpec> result = new ArrayList<SpawnPoint.SpawnSpec>(1);
            if (!this.isDone) {
                this.isDone = true;
                result.add(new SpawnPoint.SpawnSpec(spawnPoint.getCurrentTime(), this.vehicleSpec, this.destinationRoad));
            }
            return result;
        }
    }

    public static class OneSpawnSpecGenerator
    implements SpawnPoint.SpawnSpecGenerator {
        private VehicleSpec vehicleSpec;
        private DestinationSelector destinationSelector;
        private double prob;

        public OneSpawnSpecGenerator(int vehicleSpecId, double trafficLevel, DestinationSelector destinationSelector) {
            this.vehicleSpec = VehicleSpecDatabase.getVehicleSpecById(vehicleSpecId);
            this.destinationSelector = destinationSelector;
            this.prob = trafficLevel * 0.004;
            assert (this.prob <= 1.0);
        }

        @Override
        public List<SpawnPoint.SpawnSpec> act(SpawnPoint spawnPoint, double timeStep) {
            double initTime;
            LinkedList<SpawnPoint.SpawnSpec> result = new LinkedList<SpawnPoint.SpawnSpec>();
            for (double time = initTime = spawnPoint.getCurrentTime(); time < initTime + timeStep; time += 0.004) {
                if (!(Util.random.nextDouble() < this.prob)) continue;
                Road destinationRoad = this.destinationSelector.selectDestination(spawnPoint.getLane());
                result.add(new SpawnPoint.SpawnSpec(spawnPoint.getCurrentTime(), this.vehicleSpec, destinationRoad));
            }
            return result;
        }
    }

    public static class UniformSpawnSpecGenerator
    implements SpawnPoint.SpawnSpecGenerator {
        private List<Double> proportion;
        private DestinationSelector destinationSelector;
        private double prob;

        public UniformSpawnSpecGenerator(double trafficLevel, DestinationSelector destinationSelector) {
            int n = VehicleSpecDatabase.getNumOfSpec();
            this.proportion = new ArrayList<Double>(n);
            double p = 1.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                this.proportion.add(p);
            }
            this.destinationSelector = destinationSelector;
            this.prob = trafficLevel * 0.004;
            assert (this.prob <= 1.0);
        }

        @Override
        public List<SpawnPoint.SpawnSpec> act(SpawnPoint spawnPoint, double timeStep) {
            double initTime;
            LinkedList<SpawnPoint.SpawnSpec> result = new LinkedList<SpawnPoint.SpawnSpec>();
            for (double time = initTime = spawnPoint.getCurrentTime(); time < initTime + timeStep; time += 0.004) {
                if (!(Util.random.nextDouble() < this.prob)) continue;
                int i = Util.randomIndex(this.proportion);
                VehicleSpec vehicleSpec = VehicleSpecDatabase.getVehicleSpecById(i);
                Road destinationRoad = this.destinationSelector.selectDestination(spawnPoint.getLane());
                result.add(new SpawnPoint.SpawnSpec(spawnPoint.getCurrentTime(), vehicleSpec, destinationRoad));
            }
            return result;
        }
    }
}

