/*
 * Decompiled with CFR 0.152.
 */
package aim4.map;

import aim4.map.BasicMap;
import aim4.map.lane.Lane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Road {
    private String name;
    private List<Lane> lanes;
    private Road dual;
    private BasicMap map;

    public Road(String name, BasicMap map) {
        this(name, new ArrayList<Lane>(), map);
    }

    public Road(String name, List<Lane> lanes, BasicMap map) {
        this.name = name;
        this.lanes = new ArrayList<Lane>(lanes);
        this.map = map;
        if (lanes.size() > 1) {
            for (int i = 0; i < lanes.size() - 1; ++i) {
                lanes.get(i).setRightNeighbor(lanes.get(i + 1));
                lanes.get(i + 1).setLeftNeighbor(lanes.get(i));
            }
        }
    }

    public double getMaximumConnectedSpeedLimit() {
        return this.map.getMaximumSpeedLimit();
    }

    public List<Lane> getLanes() {
        return Collections.unmodifiableList(this.lanes);
    }

    public Lane getIndexLane() {
        if (this.lanes.isEmpty()) {
            return null;
        }
        return this.lanes.get(0);
    }

    public Road getDual() {
        return this.dual;
    }

    public void setDual(Road dual) {
        this.dual = dual;
        dual.dual = this;
    }

    public boolean hasDual() {
        return this.dual != null;
    }

    public void addTheRightMostLane(Lane lane) {
        if (!this.lanes.isEmpty()) {
            Lane rightmost = this.lanes.get(this.lanes.size() - 1);
            rightmost.setRightNeighbor(lane);
            lane.setLeftNeighbor(rightmost);
        }
        this.lanes.add(lane);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }
}

