/*
 * Decompiled with CFR 0.152.
 */
package aim4.map;

import aim4.map.Road;
import aim4.map.lane.Lane;
import aim4.vehicle.VehicleSpec;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class SpawnPoint {
    private double currentTime;
    private Point2D pos;
    private double heading;
    private double steeringAngle;
    private double acceleration;
    private Lane lane;
    private Rectangle2D noVehicleZone;
    private SpawnSpecGenerator vehicleSpecChooser;

    public SpawnPoint(double currentTime, Point2D pos, double heading, double steeringAngle, double acceleration, Lane lane, Rectangle2D noVehicleZone, SpawnSpecGenerator vehicleSpecChooser) {
        this.currentTime = currentTime;
        this.pos = pos;
        this.heading = heading;
        this.steeringAngle = steeringAngle;
        this.acceleration = acceleration;
        this.lane = lane;
        this.noVehicleZone = noVehicleZone;
        this.vehicleSpecChooser = vehicleSpecChooser;
    }

    public SpawnPoint(double currentTime, Point2D pos, double heading, double steeringAngle, double acceleration, Lane lane, Rectangle2D noVehicleZone) {
        this.currentTime = currentTime;
        this.pos = pos;
        this.heading = heading;
        this.steeringAngle = steeringAngle;
        this.acceleration = acceleration;
        this.lane = lane;
        this.noVehicleZone = noVehicleZone;
        this.vehicleSpecChooser = null;
    }

    public List<SpawnSpec> act(double timeStep) {
        assert (this.vehicleSpecChooser != null);
        List<SpawnSpec> spawnSpecs = this.vehicleSpecChooser.act(this, timeStep);
        this.currentTime += timeStep;
        return spawnSpecs;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public Point2D getPosition() {
        return this.pos;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getSteeringAngle() {
        return this.steeringAngle;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public Lane getLane() {
        return this.lane;
    }

    public Rectangle2D getNoVehicleZone() {
        return this.noVehicleZone;
    }

    public void setVehicleSpecChooser(SpawnSpecGenerator vehicleSpecChooser) {
        this.vehicleSpecChooser = vehicleSpecChooser;
    }

    public static interface SpawnSpecGenerator {
        public List<SpawnSpec> act(SpawnPoint var1, double var2);
    }

    public static class SpawnSpec {
        double spawnTime;
        VehicleSpec vehicleSpec;
        Road destinationRoad;

        public SpawnSpec(double spawnTime, VehicleSpec vehicleSpec, Road destinationRoad) {
            this.spawnTime = spawnTime;
            this.vehicleSpec = vehicleSpec;
            this.destinationRoad = destinationRoad;
        }

        public double getSpawnTime() {
            return this.spawnTime;
        }

        public VehicleSpec getVehicleSpec() {
            return this.vehicleSpec;
        }

        public Road getDestinationRoad() {
            return this.destinationRoad;
        }
    }
}

