/*
 * Decompiled with CFR 0.152.
 */
package aim4.map.destination;

import aim4.config.Debug;
import aim4.map.BasicMap;
import aim4.map.Road;
import aim4.map.SpawnPoint;
import aim4.map.TrafficVolume;
import aim4.map.destination.DestinationSelector;
import aim4.map.lane.Lane;
import aim4.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RatioDestinationSelector
implements DestinationSelector {
    private List<Road> destinationRoads;
    private TrafficVolume trafficVolume;
    private Map<Integer, Double> leftTurnProb;
    private Map<Integer, Double> rightTurnProb;

    public RatioDestinationSelector(BasicMap map, TrafficVolume trafficVolume) {
        this.destinationRoads = map.getDestinationRoads();
        this.trafficVolume = trafficVolume;
        this.leftTurnProb = new HashMap<Integer, Double>();
        this.rightTurnProb = new HashMap<Integer, Double>();
        for (SpawnPoint sp : map.getSpawnPoints()) {
            int laneId = sp.getLane().getId();
            this.leftTurnProb.put(laneId, trafficVolume.getLeftTurnVolume(laneId) / trafficVolume.getThroughVolume(laneId));
            this.rightTurnProb.put(laneId, trafficVolume.getRightTurnVolume(laneId) / trafficVolume.getThroughVolume(laneId));
        }
    }

    @Override
    public Road selectDestination(Lane currentLane) {
        Road currentRoad = Debug.currentMap.getRoad(currentLane);
        int laneId = currentLane.getId();
        double prob = Util.random.nextDouble();
        if (prob < this.leftTurnProb.get(laneId)) {
            return this.trafficVolume.getLeftTurnRoad(currentRoad);
        }
        if (prob >= 1.0 - this.rightTurnProb.get(laneId)) {
            return this.trafficVolume.getRightTurnRoad(currentRoad);
        }
        return currentRoad;
    }
}

