/*
 * Decompiled with CFR 0.152.
 */
package aim4.map.destination;

import aim4.config.Debug;
import aim4.map.BasicMap;
import aim4.map.Road;
import aim4.map.destination.DestinationSelector;
import aim4.map.lane.Lane;
import java.util.List;

public class TurnBasedDestinationSelector
implements DestinationSelector {
    private List<Road> destinationRoads;

    public TurnBasedDestinationSelector(BasicMap layout) {
        this.destinationRoads = layout.getDestinationRoads();
    }

    @Override
    public Road selectDestination(Lane currentLane) {
        Road currentRoad = Debug.currentMap.getRoad(currentLane);
        boolean hasLeft = currentLane.hasLeftNeighbor();
        boolean hasRight = currentLane.hasRightNeighbor();
        if (hasLeft && hasRight) {
            return currentRoad;
        }
        if (!hasLeft && hasRight) {
            if (currentRoad.getName().equals("1st Street E")) {
                return this.destinationRoads.get(2);
            }
            if (currentRoad.getName().equals("1st Street W")) {
                return this.destinationRoads.get(3);
            }
            if (currentRoad.getName().equals("1st Avenue N")) {
                return this.destinationRoads.get(1);
            }
            if (currentRoad.getName().equals("1st Avenue S")) {
                return this.destinationRoads.get(0);
            }
            throw new RuntimeException("Error in TurnBasedDestination");
        }
        if (hasLeft && !hasRight) {
            if (currentRoad.getName().equals("1st Street E")) {
                return this.destinationRoads.get(3);
            }
            if (currentRoad.getName().equals("1st Street W")) {
                return this.destinationRoads.get(2);
            }
            if (currentRoad.getName().equals("1st Avenue N")) {
                return this.destinationRoads.get(0);
            }
            if (currentRoad.getName().equals("1st Avenue S")) {
                return this.destinationRoads.get(1);
            }
            throw new RuntimeException("Error in TurnBasedDestination");
        }
        return currentRoad;
    }
}

