/*
 * Decompiled with CFR 0.152.
 */
package aim4.map.lane;

import aim4.im.IntersectionManager;
import aim4.map.lane.Lane;
import aim4.map.track.WayPoint;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class LaneIM {
    private Lane lane;
    private SortedMap<Double, IntersectionManager> intersectionManagers = new TreeMap<Double, IntersectionManager>();
    private Map<IntersectionManager, IntersectionManager> memoGetSubsequentIntersectionManager = null;

    public LaneIM(Lane lane) {
        this.lane = lane;
    }

    public void registerIntersectionManager(IntersectionManager im) {
        if (im.manages(this.lane)) {
            this.memoGetSubsequentIntersectionManager = null;
            Point2D exitPoint = im.getIntersection().getExitPoint(this.lane);
            if (exitPoint == null) {
                exitPoint = this.lane.getEndPoint();
            }
            double normalizedDistanceToExit = this.lane.normalizedDistanceAlongLane(exitPoint);
            this.intersectionManagers.put(normalizedDistanceToExit, im);
        }
    }

    public IntersectionManager firstIntersectionManager() {
        if (this.intersectionManagers.isEmpty()) {
            if (this.lane.hasNextLane()) {
                return this.lane.getNextLane().getLaneIM().firstIntersectionManager();
            }
            return null;
        }
        return (IntersectionManager)this.intersectionManagers.get(this.intersectionManagers.firstKey());
    }

    public double distanceToFirstIntersection() {
        if (this.intersectionManagers.isEmpty()) {
            if (this.lane.hasNextLane()) {
                return this.lane.getLength() + this.lane.getNextLane().getLaneIM().distanceToFirstIntersection();
            }
            return Double.MAX_VALUE;
        }
        IntersectionManager firstIM = (IntersectionManager)this.intersectionManagers.get(this.intersectionManagers.firstKey());
        WayPoint entry = firstIM.getIntersection().getEntryPoint(this.lane);
        if (entry == null) {
            return 0.0;
        }
        return this.lane.getStartPoint().distance(entry);
    }

    public Lane laneToFirstIntersection() {
        if (this.intersectionManagers.isEmpty()) {
            if (this.lane.hasNextLane()) {
                return this.lane.getNextLane().getLaneIM().laneToFirstIntersection();
            }
            return null;
        }
        return this.lane;
    }

    public IntersectionManager lastIntersectionManager() {
        if (this.intersectionManagers.isEmpty()) {
            if (this.lane.hasPrevLane()) {
                return this.lane.getPrevLane().getLaneIM().lastIntersectionManager();
            }
            return null;
        }
        return (IntersectionManager)this.intersectionManagers.get(this.intersectionManagers.lastKey());
    }

    public double remainingDistanceFromLastIntersection() {
        if (this.intersectionManagers.isEmpty()) {
            if (this.lane.hasPrevLane()) {
                return this.lane.getLength() + this.lane.getPrevLane().getLaneIM().remainingDistanceFromLastIntersection();
            }
            return Double.MAX_VALUE;
        }
        return (1.0 - this.intersectionManagers.lastKey()) * this.lane.getLength();
    }

    public IntersectionManager nextIntersectionManager(Point2D p) {
        double index = this.lane.normalizedDistanceAlongLane(p);
        SortedMap<Double, IntersectionManager> remaining = this.intersectionManagers.tailMap(index);
        if (remaining.isEmpty()) {
            if (this.lane.hasNextLane()) {
                return this.lane.getNextLane().getLaneIM().firstIntersectionManager();
            }
            return null;
        }
        return (IntersectionManager)remaining.get(remaining.firstKey());
    }

    public double distanceToNextIntersection(Point2D p) {
        double index = this.lane.normalizedDistanceAlongLane(p);
        SortedMap<Double, IntersectionManager> remaining = this.intersectionManagers.tailMap(index);
        if (remaining.isEmpty()) {
            if (this.lane.hasNextLane()) {
                return (1.0 - index) * this.lane.getLength() + this.lane.getNextLane().getLaneIM().distanceToFirstIntersection();
            }
            return Double.MAX_VALUE;
        }
        IntersectionManager nextIM = (IntersectionManager)remaining.get(remaining.firstKey());
        WayPoint entry = nextIM.getIntersection().getEntryPoint(this.lane);
        if (entry == null) {
            return 0.0;
        }
        double entryFraction = this.lane.normalizedDistanceAlongLane(entry);
        return Math.max(0.0, (entryFraction - index) * this.lane.getLength());
    }

    public Lane laneToNextIntersection(Point2D p) {
        double index = this.lane.normalizedDistanceAlongLane(p);
        SortedMap<Double, IntersectionManager> remaining = this.intersectionManagers.tailMap(index);
        if (remaining.isEmpty()) {
            if (this.lane.hasNextLane()) {
                return this.lane.getNextLane().getLaneIM().laneToFirstIntersection();
            }
            return null;
        }
        return this.lane;
    }

    public double distanceFromPrevIntersection(Point2D p) {
        double index = this.lane.normalizedDistanceAlongLane(p);
        SortedMap<Double, IntersectionManager> preceding = this.intersectionManagers.headMap(index);
        if (preceding.isEmpty()) {
            if (this.lane.hasPrevLane()) {
                return index * this.lane.getLength() + this.lane.getNextLane().getLaneIM().remainingDistanceFromLastIntersection();
            }
            return Double.MAX_VALUE;
        }
        return (index - preceding.lastKey()) * this.lane.getLength();
    }

    public IntersectionManager nextIntersectionManager(IntersectionManager im) {
        if (this.memoGetSubsequentIntersectionManager == null) {
            this.memoGetSubsequentIntersectionManager = new HashMap<IntersectionManager, IntersectionManager>();
            IntersectionManager lastIM = null;
            for (IntersectionManager currIM : this.intersectionManagers.values()) {
                if (lastIM != null) {
                    this.memoGetSubsequentIntersectionManager.put(lastIM, currIM);
                }
                lastIM = currIM;
            }
            if (lastIM != null && this.lane.hasNextLane()) {
                this.memoGetSubsequentIntersectionManager.put(lastIM, this.lane.getNextLane().getLaneIM().firstIntersectionManager());
            }
        }
        return this.memoGetSubsequentIntersectionManager.get(im);
    }

    public double distanceToNextIntersectionManager(IntersectionManager im) {
        IntersectionManager nextIM = this.nextIntersectionManager(im);
        if (nextIM == null) {
            return 0.0;
        }
        if (nextIM.getIntersection().isEnteredBy(this.lane)) {
            return im.getIntersection().getExitPoint(this.lane).distance(nextIM.getIntersection().getEntryPoint(this.lane));
        }
        double totalDist = this.remainingDistanceFromLastIntersection();
        Lane currLane = this.lane.getNextLane();
        while (!nextIM.getIntersection().isEnteredBy(currLane)) {
            totalDist += currLane.getLength();
            currLane = currLane.getNextLane();
        }
        return totalDist += currLane.getLaneIM().distanceToFirstIntersection();
    }

    public double timeToNextIntersectionManager(IntersectionManager im, double maxVelocity) {
        IntersectionManager nextIM = this.nextIntersectionManager(im);
        if (nextIM == null) {
            return 0.0;
        }
        if (nextIM.getIntersection().isEnteredBy(this.lane)) {
            return im.getIntersection().getExitPoint(this.lane).distance(nextIM.getIntersection().getEntryPoint(this.lane)) / Math.min(this.lane.getSpeedLimit(), maxVelocity);
        }
        double totalTime = this.remainingDistanceFromLastIntersection() / this.lane.getSpeedLimit();
        Lane currLane = this.lane.getNextLane();
        while (!nextIM.getIntersection().isEnteredBy(currLane)) {
            totalTime += currLane.getLength() / Math.min(currLane.getSpeedLimit(), maxVelocity);
            currLane = currLane.getNextLane();
        }
        return totalTime += currLane.getLaneIM().distanceToFirstIntersection() / Math.min(currLane.getSpeedLimit(), maxVelocity);
    }
}

