/*
 * Decompiled with CFR 0.152.
 */
package aim4.map.lane;

import aim4.map.lane.AbstractLane;
import aim4.util.GeomMath;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class LineSegmentLane
extends AbstractLane {
    private double length;
    private double squaredLaneLength;
    private double width;
    private double halfWidth;
    private Line2D line;
    private Shape laneShape;
    private Point2D laneVector;
    private double heading;
    private Line2D leftBorder;
    private Line2D rightBorder;

    public LineSegmentLane(Line2D line, double width, double speedLimit) {
        super(speedLimit);
        this.line = line;
        this.width = width;
        this.halfWidth = width / 2.0;
        this.laneVector = GeomMath.subtract(line.getP2(), line.getP1());
        this.squaredLaneLength = GeomMath.dotProduct(this.laneVector, this.laneVector);
        this.length = Math.sqrt(this.squaredLaneLength);
        this.heading = GeomMath.canonicalAngle(Math.atan2(line.getY2() - line.getY1(), line.getX2() - line.getX1()));
        this.laneShape = this.calculateLaneShape();
        double xDifferential = this.halfWidth * Math.cos(this.heading + 1.5707963267948966);
        double yDifferential = this.halfWidth * Math.sin(this.heading + 1.5707963267948966);
        this.leftBorder = new Line2D.Double(line.getX1() - xDifferential, line.getY1() - yDifferential, line.getX2() - xDifferential, line.getY2() - yDifferential);
        this.rightBorder = new Line2D.Double(line.getX1() + xDifferential, line.getY1() + yDifferential, line.getX2() + xDifferential, line.getY2() + yDifferential);
    }

    public LineSegmentLane(Point2D p1, Point2D p2, double width, double speedLimit) {
        this(new Line2D.Double(p1, p2), width, speedLimit);
    }

    public LineSegmentLane(double x1, double y1, double x2, double y2, double width, double speedLimit) {
        this(new Line2D.Double(x1, y1, x2, y2), width, speedLimit);
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public Point2D getStartPoint() {
        return this.line.getP1();
    }

    @Override
    public Point2D getEndPoint() {
        return this.line.getP2();
    }

    @Override
    public Point2D getPointAtNormalizedDistance(double normalizedDistance) {
        return new Point2D.Double(this.line.getX1() + normalizedDistance * this.laneVector.getX(), this.line.getY1() + normalizedDistance * this.laneVector.getY());
    }

    @Override
    public Point2D nearestPoint(Point2D p) {
        double fraction = this.normalizedDistanceAlongLane(p);
        if (fraction <= 0.0) {
            return this.line.getP1();
        }
        if (fraction >= 1.0) {
            return this.line.getP2();
        }
        return this.getPointAtNormalizedDistance(fraction);
    }

    @Override
    public double nearestDistance(Point2D pos) {
        return this.line.ptSegDist(pos);
    }

    @Override
    public Point2D getLeadPoint(Point2D pos, double leadDist) {
        double fraction = this.normalizedDistanceAlongLane(pos);
        Point2D pp = this.getPointAtNormalizedDistance(fraction);
        return new Point2D.Double(pp.getX() + leadDist * Math.cos(this.heading), pp.getY() + leadDist * Math.sin(this.heading));
    }

    @Override
    public double distanceAlongLane(Point2D pos) {
        Point2D w = GeomMath.subtract(pos, this.line.getP1());
        return GeomMath.dotProduct(w, this.laneVector) / this.length;
    }

    @Override
    public double remainingDistanceAlongLane(Point2D pos) {
        return this.length - this.distanceAlongLane(pos);
    }

    @Override
    public double normalizedDistanceAlongLane(Point2D pos) {
        Point2D w = GeomMath.subtract(pos, this.line.getP1());
        return GeomMath.dotProduct(w, this.laneVector) / this.squaredLaneLength;
    }

    @Override
    public double normalizedDistance(double distance) {
        return distance / this.length;
    }

    @Override
    public double getInitialHeading() {
        return this.heading;
    }

    @Override
    public double getTerminalHeading() {
        return this.heading;
    }

    @Override
    public double getHeadingAtNormalizedDistance(double normalizedDistance) {
        return this.heading;
    }

    @Override
    public Point2D intersectionPoint(Line2D l) {
        if (this.line.intersectsLine(l)) {
            return GeomMath.findLineLineIntersection(this.line, l);
        }
        return null;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public Shape getShape() {
        return this.laneShape;
    }

    @Override
    public Shape getShape(double startFraction, double endFraction) {
        if (startFraction < 0.0 || endFraction < 0.0 || startFraction > 1.0 || endFraction > 1.0) {
            throw new IllegalArgumentException("Normalized distances must be between 0 and 1! Got: startFraction = " + startFraction + ", endFraction = " + endFraction + ".");
        }
        GeneralPath result = new GeneralPath();
        double xDifferential = this.halfWidth * Math.cos(this.heading + 1.5707963267948966);
        double yDifferential = this.halfWidth * Math.sin(this.heading + 1.5707963267948966);
        Point2D p1 = this.getPointAtNormalizedDistance(startFraction);
        Point2D p2 = this.getPointAtNormalizedDistance(endFraction);
        result.moveTo((float)(p1.getX() + xDifferential), (float)(p1.getY() + yDifferential));
        result.lineTo((float)(p2.getX() + xDifferential), (float)(p2.getY() + yDifferential));
        result.lineTo((float)(p2.getX() - xDifferential), (float)(p2.getY() - yDifferential));
        result.lineTo((float)(p1.getX() - xDifferential), (float)(p1.getY() - yDifferential));
        result.closePath();
        return result;
    }

    @Override
    public boolean contains(Point2D pos) {
        return this.nearestDistance(pos) < this.halfWidth;
    }

    @Override
    public Shape leftBorder() {
        return this.leftBorder;
    }

    @Override
    public Shape rightBorder() {
        return this.rightBorder;
    }

    @Override
    public Point2D leftIntersectionPoint(Line2D l) {
        if (this.leftBorder.intersectsLine(l)) {
            return GeomMath.findLineLineIntersection(this.leftBorder, l);
        }
        return null;
    }

    @Override
    public Point2D rightIntersectionPoint(Line2D l) {
        if (this.rightBorder.intersectsLine(l)) {
            return GeomMath.findLineLineIntersection(this.rightBorder, l);
        }
        return null;
    }

    private Shape calculateLaneShape() {
        GeneralPath result = new GeneralPath();
        double xDifferential = this.halfWidth * Math.cos(this.heading + 1.5707963267948966);
        double yDifferential = this.halfWidth * Math.sin(this.heading + 1.5707963267948966);
        result.moveTo((float)(this.line.getX1() + xDifferential), (float)(this.line.getY1() + yDifferential));
        result.lineTo((float)(this.line.getX2() + xDifferential), (float)(this.line.getY2() + yDifferential));
        result.lineTo((float)(this.line.getX2() - xDifferential), (float)(this.line.getY2() - yDifferential));
        result.lineTo((float)(this.line.getX1() - xDifferential), (float)(this.line.getY1() - yDifferential));
        result.closePath();
        return result;
    }
}

