/*
 * Decompiled with CFR 0.152.
 */
package aim4.map.track;

import aim4.config.Constants;
import aim4.map.track.Track;
import aim4.map.track.TrackPosition;
import aim4.map.track.WayPoint;
import aim4.util.GeomMath;
import aim4.util.Util;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ArcTrack
implements Track {
    private WayPoint p1;
    private WayPoint p2;
    private Point2D center;
    private double radius;
    private double thetaStart;
    private double thetaEnd;
    private double thetaDiff;
    private Arc2D arc;

    public ArcTrack(WayPoint p1, WayPoint p2, Point2D center, boolean isClockwiseDirection) {
        this.p1 = p1;
        this.p2 = p2;
        this.center = center;
        this.radius = center.distance(p1);
        assert (this.radius > 0.0);
        assert (Util.isDoubleEqual(this.radius, center.distance(p2)));
        this.thetaStart = GeomMath.canonicalAngle(GeomMath.angleToPoint(p1, center));
        this.thetaEnd = GeomMath.canonicalAngle(GeomMath.angleToPoint(p2, center));
        this.thetaDiff = this.thetaEnd >= this.thetaStart ? this.thetaEnd - this.thetaStart : Math.PI * 2 + this.thetaEnd - this.thetaStart;
        if (!isClockwiseDirection) {
            this.thetaDiff -= Math.PI * 2;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(center.getX() - this.radius, center.getY() - this.radius, 2.0 * this.radius, 2.0 * this.radius);
        this.arc = new Arc2D.Double(bounds, Math.toDegrees(-this.thetaStart), Math.toDegrees(-this.thetaDiff), 0);
    }

    @Override
    public WayPoint getStartWayPoint() {
        return this.p1;
    }

    @Override
    public WayPoint getEndWayPoint() {
        return this.p2;
    }

    @Override
    public double getLength() {
        return Math.abs(this.thetaDiff * this.radius);
    }

    @Override
    public TrackPosition getPosition(double dist) {
        if (0.0 <= dist && dist <= this.getLength()) {
            return new Position(dist);
        }
        return null;
    }

    @Override
    public Shape getShape() {
        return this.arc;
    }

    public class Position
    implements TrackPosition {
        double theta;

        public Position(double dist) {
            this.theta = ArcTrack.this.thetaDiff >= 0.0 ? dist / ArcTrack.this.radius : -dist / ArcTrack.this.radius;
        }

        @Override
        public double getX() {
            return ArcTrack.this.center.getX() + ArcTrack.this.radius * Math.cos(ArcTrack.this.thetaStart + this.theta);
        }

        @Override
        public double getY() {
            return ArcTrack.this.center.getY() + ArcTrack.this.radius * Math.sin(ArcTrack.this.thetaStart + this.theta);
        }

        @Override
        public double getTangentSlope() {
            if (ArcTrack.this.thetaDiff >= 0.0) {
                return GeomMath.canonicalAngle(ArcTrack.this.thetaStart + this.theta + 1.5707963267948966);
            }
            return GeomMath.canonicalAngle(ArcTrack.this.thetaStart + this.theta - 1.5707963267948966);
        }

        @Override
        public double move(double dist) {
            if (this.theta != ArcTrack.this.thetaDiff) {
                if (ArcTrack.this.thetaDiff >= 0.0) {
                    this.theta += dist / ArcTrack.this.radius;
                    if (this.theta <= ArcTrack.this.thetaDiff) {
                        return 0.0;
                    }
                    double d = (this.theta - ArcTrack.this.thetaDiff) * ArcTrack.this.radius;
                    this.theta = ArcTrack.this.thetaDiff;
                    return d;
                }
                this.theta -= dist / ArcTrack.this.radius;
                if (this.theta >= ArcTrack.this.thetaDiff) {
                    return 0.0;
                }
                double d = (ArcTrack.this.thetaDiff - this.theta) * ArcTrack.this.radius;
                this.theta = ArcTrack.this.thetaDiff;
                return d;
            }
            return dist;
        }

        public String toString() {
            return "ArcTrack.Position(theta=" + Constants.TWO_DEC.format(this.theta) + ")";
        }
    }
}

