/*
 * Decompiled with CFR 0.152.
 */
package aim4.map.track;

import aim4.map.track.Track;
import aim4.map.track.TrackPosition;
import aim4.map.track.WayPoint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class PathTrack
implements Track {
    private LinkedList<WayPoint> points = new LinkedList();
    private LinkedList<Track> tracks = new LinkedList();
    private GeneralPath shape = new GeneralPath();
    private double length = 0.0;

    public void add(Track track) {
        if (this.points.size() == 0) {
            this.points.add(track.getStartWayPoint());
            this.points.add(track.getEndWayPoint());
        } else {
            assert (track.getStartWayPoint().getId() < 0 || this.points.getLast().getId() < 0 || track.getStartWayPoint().getId() == this.points.getLast().getId());
            this.points.add(track.getEndWayPoint());
        }
        this.tracks.add(track);
        this.shape.append(track.getShape(), false);
        this.length += track.getLength();
    }

    public void append(PathTrack track) {
        for (Track seg : track.getTracks()) {
            this.add(seg);
        }
    }

    public List<Track> getTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    @Override
    public WayPoint getStartWayPoint() {
        return this.points.getFirst();
    }

    @Override
    public WayPoint getEndWayPoint() {
        return this.points.getLast();
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public TrackPosition getPosition(double dist) {
        if (0.0 <= dist && dist <= this.length) {
            return new Position(dist);
        }
        return null;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    public class Position
    implements TrackPosition {
        TrackPosition pos;
        int trackId;

        public Position(double dist) {
            try {
                double d;
                this.trackId = 0;
                this.pos = ((Track)PathTrack.this.tracks.getFirst()).getPosition(0.0);
                if (dist > 0.0 && (d = this.move(dist)) == dist) {
                    throw new RuntimeException("Cannot create track position because the first track has zero length.");
                }
            }
            catch (NoSuchElementException e) {
                throw new RuntimeException("Cannot create track position because no track left in the path.");
            }
        }

        @Override
        public double getX() {
            return this.pos.getX();
        }

        @Override
        public double getY() {
            return this.pos.getY();
        }

        @Override
        public double getTangentSlope() {
            return this.pos.getTangentSlope();
        }

        @Override
        public final double move(double dist) {
            while (true) {
                double d;
                if ((d = this.pos.move(dist)) == 0.0) {
                    return 0.0;
                }
                if (d < dist) {
                    if (this.trackId < PathTrack.this.tracks.size() - 1) {
                        ++this.trackId;
                        this.pos = ((Track)PathTrack.this.tracks.get(this.trackId)).getPosition(0.0);
                        dist = d;
                        continue;
                    }
                    this.pos = null;
                    return d;
                }
                assert (d == dist);
                if (this.trackId >= PathTrack.this.tracks.size() - 1) break;
                ++this.trackId;
                this.pos = ((Track)PathTrack.this.tracks.get(this.trackId)).getPosition(0.0);
            }
            this.pos = null;
            return dist;
        }
    }
}

