/*
 * Decompiled with CFR 0.152.
 */
package aim4.msg.i2v;

import aim4.config.Constants;
import aim4.msg.i2v.I2VMessage;
import java.util.Queue;

public class Confirm
extends I2VMessage {
    private int reservationId;
    private int requestId;
    private double arrivalTime;
    private double earlyError;
    private double lateError;
    private double arrivalVelocity;
    private int arrivalLaneID;
    private int departureLaneID;
    private double aczDistance;
    private Queue<double[]> accProfile;

    public Confirm(int imId, int vin, int reservationID, int requestId, double arrivalTime, double earlyError, double lateError, double arrivalVelocity, int arrivalLaneID, int departureLaneID, double aczDistance, Queue<double[]> accProfile) {
        super(imId, vin);
        this.reservationId = reservationID;
        this.requestId = requestId;
        this.arrivalTime = arrivalTime;
        this.earlyError = earlyError;
        this.lateError = lateError;
        this.arrivalVelocity = arrivalVelocity;
        this.arrivalLaneID = arrivalLaneID;
        this.departureLaneID = departureLaneID;
        this.aczDistance = aczDistance;
        this.accProfile = accProfile;
        this.messageType = I2VMessage.Type.CONFIRM;
        this.size += 96 + (5 + 2 * accProfile.size()) * 64;
    }

    public int getReservationId() {
        return this.reservationId;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public double getArrivalTime() {
        return this.arrivalTime;
    }

    public double getEarlyError() {
        return this.earlyError;
    }

    public double getLateError() {
        return this.lateError;
    }

    public double getArrivalVelocity() {
        return this.arrivalVelocity;
    }

    public int getArrivalLaneID() {
        return this.arrivalLaneID;
    }

    public int getDepartureLaneID() {
        return this.departureLaneID;
    }

    public double getACZDistance() {
        return this.aczDistance;
    }

    public Queue<double[]> getAccelerationProfile() {
        return this.accProfile;
    }

    public String toString() {
        return "Confirm(im" + this.getImId() + " -> vin" + this.getVin() + ", reservationID=" + this.reservationId + ", requestID=" + this.requestId + ", arrivalLane=" + this.arrivalLaneID + ", departureLane=" + this.departureLaneID + ", arrTime=" + Constants.TWO_DEC.format(this.arrivalTime) + ", arrVelocity=" + Constants.TWO_DEC.format(this.arrivalVelocity) + ", aczDistance=" + Constants.TWO_DEC.format(this.aczDistance) + ", accProfile=" + this.accProfileToString() + ", earlyError=" + Constants.TWO_DEC.format(this.earlyError) + ", lateError=" + Constants.TWO_DEC.format(this.lateError) + ")";
    }

    private String accProfileToString() {
        String result = "[";
        boolean isFirst = true;
        for (double[] pair : this.accProfile) {
            if (isFirst) {
                isFirst = false;
            } else {
                result = result + " ";
            }
            result = result + "(" + Constants.TWO_DEC.format(pair[0]) + "," + Constants.TWO_DEC.format(pair[1]) + ")";
        }
        result = result + "]";
        return result;
    }
}

