/*
 * Decompiled with CFR 0.152.
 */
package aim4.msg.udp;

import aim4.config.Constants;
import aim4.msg.udp.Real2ProxyMsg;
import aim4.vehicle.AccelSchedule;
import java.awt.geom.Point2D;
import java.io.DataInputStream;
import java.io.IOException;

public class Real2ProxyPVUpdate
extends Real2ProxyMsg {
    public final int vin;
    public final Point2D position;
    public final double heading;
    public final double steeringAngle;
    public double velocity;
    public final double targetVelocity;
    public final double acceleration;
    public final AccelSchedule accelProfile;

    public Real2ProxyPVUpdate(DataInputStream dis, double receivedTime) throws IOException {
        super(Real2ProxyMsg.Type.PV_UPDATE, receivedTime);
        this.vin = dis.readInt();
        double x = dis.readFloat();
        double y = dis.readFloat();
        this.position = new Point2D.Double(x, y);
        this.heading = dis.readFloat();
        this.steeringAngle = dis.readFloat();
        this.velocity = dis.readFloat();
        this.targetVelocity = dis.readFloat();
        this.acceleration = dis.readFloat();
        this.accelProfile = null;
    }

    public String toString() {
        String s = "Real2ProxyPVUpdate(";
        s = s + "vin=" + this.vin + ", ";
        s = s + "receivedTime=" + Constants.TWO_DEC.format(this.receivedTime) + ", ";
        s = s + "position=(" + Constants.TWO_DEC.format(this.position.getX()) + "," + Constants.TWO_DEC.format(this.position.getY()) + "), ";
        s = s + "heading=" + Constants.TWO_DEC.format(this.heading) + ", ";
        s = s + "steeringAngle=" + Constants.TWO_DEC.format(this.steeringAngle) + ", ";
        s = s + "velocity=" + Constants.TWO_DEC.format(this.velocity) + ", ";
        s = s + "targetVelocity=" + Constants.TWO_DEC.format(this.targetVelocity) + ", ";
        s = s + "acceleration=" + Constants.TWO_DEC.format(this.acceleration) + ", ";
        s = s + "accelProfile=" + this.accelProfile;
        s = s + ")";
        return s;
    }
}

