/*
 * Decompiled with CFR 0.152.
 */
package aim4.msg.udp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class UdpHeader {
    public static final int MAX_MESSENGE_PACKAGE_LENGTH = 1024;
    public static final int LENGTH = 12;
    private float timestamp;
    private UdpMessageType messageType;
    private int checksum;

    public UdpHeader(DataInputStream dis) throws IOException {
        assert (dis.available() >= 12);
        this.timestamp = dis.readFloat();
        this.messageType = UdpMessageType.values()[dis.readInt()];
        this.checksum = dis.readInt();
    }

    public UdpHeader(float currentTime, UdpMessageType messageType) {
        this.timestamp = currentTime;
        this.messageType = messageType;
        this.checksum = 0;
    }

    public float getTimestamp() {
        return this.timestamp;
    }

    public UdpMessageType getMessageType() {
        return this.messageType;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public DataOutputStream writeToDataOutputStream(DataOutputStream dos) throws IOException {
        dos.writeFloat(this.timestamp);
        dos.writeInt(this.messageType.ordinal());
        dos.writeInt(this.checksum);
        return dos;
    }

    public static int computeChecksum(byte[] data) {
        return 0;
    }

    public String toString() {
        return "Timestamp=" + this.timestamp + "\tMessage type=" + (Object)((Object)this.messageType) + "\tchecksum=" + this.checksum;
    }

    public static enum UdpMessageType {
        PVUpdate,
        I2V_Confirm,
        I2V_Reject,
        I2V_Acknowledge,
        I2V_EmergencyStop,
        V2I_Request,
        V2I_Cancel,
        V2I_Done,
        I2V_DistToFrontVehicle;

    }
}

