/*
 * Decompiled with CFR 0.152.
 */
package aim4.noise;

import aim4.noise.BasicNoiseFunction;
import aim4.noise.NoiseFunction;
import aim4.util.Util;

public class DoubleGauge {
    private double value = 0.0;
    private double maxValue = Double.MAX_VALUE;
    private double minValue = Double.MIN_VALUE;
    private NoiseFunction noiseFunction = BasicNoiseFunction.noNoise;

    public DoubleGauge() {
    }

    public DoubleGauge(NoiseFunction noiseFunction) {
        this.noiseFunction = noiseFunction;
    }

    public DoubleGauge(double value) {
        this.value = value;
    }

    public DoubleGauge(double value, NoiseFunction noiseFunction) {
        this.value = value;
        this.noiseFunction = noiseFunction;
    }

    public DoubleGauge(double value, double minValue, double maxValue) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public DoubleGauge(double value, double minValue, double maxValue, NoiseFunction noiseFunction) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.noiseFunction = noiseFunction;
    }

    public double read() {
        return this.value;
    }

    public void record(double recValue) {
        double v = this.noiseFunction.apply(recValue);
        this.value = Util.constrain(v, this.minValue, this.maxValue);
    }
}

