/*
 * Decompiled with CFR 0.152.
 */
package aim4.sim;

import aim4.config.Debug;
import aim4.config.DebugPoint;
import aim4.driver.AutoDriver;
import aim4.driver.ProxyDriver;
import aim4.driver.pilot.V2IPilot;
import aim4.im.IntersectionManager;
import aim4.im.v2i.V2IManager;
import aim4.map.BasicMap;
import aim4.map.DataCollectionLine;
import aim4.map.Road;
import aim4.map.SpawnPoint;
import aim4.map.lane.Lane;
import aim4.msg.i2v.I2VMessage;
import aim4.msg.v2i.V2IMessage;
import aim4.sim.Simulator;
import aim4.vehicle.AutoVehicleSimView;
import aim4.vehicle.BasicAutoVehicle;
import aim4.vehicle.HumanDrivenVehicleSimView;
import aim4.vehicle.ProxyVehicleSimView;
import aim4.vehicle.VehicleSimView;
import aim4.vehicle.VehicleSpec;
import aim4.vehicle.VehicleUtil;
import aim4.vehicle.VinRegistry;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class AutoDriverOnlySimulator
implements Simulator {
    private BasicMap basicMap;
    private Map<Integer, VehicleSimView> vinToVehicles;
    private double currentTime;
    private int numOfCompletedVehicles;
    private int totalBitsTransmittedByCompletedVehicles;
    private int totalBitsReceivedByCompletedVehicles;

    public AutoDriverOnlySimulator(BasicMap basicMap) {
        this.basicMap = basicMap;
        this.vinToVehicles = new HashMap<Integer, VehicleSimView>();
        this.currentTime = 0.0;
        this.numOfCompletedVehicles = 0;
        this.totalBitsTransmittedByCompletedVehicles = 0;
        this.totalBitsReceivedByCompletedVehicles = 0;
    }

    @Override
    public synchronized AutoDriverOnlySimStepResult step(double timeStep) {
        this.spawnVehicles(timeStep);
        this.provideSensorInput();
        this.letDriversAct();
        this.letIntersectionManagersAct(timeStep);
        this.communication();
        this.moveVehicles(timeStep);
        List<Integer> completedVINs = this.cleanUpCompletedVehicles();
        this.currentTime += timeStep;
        this.checkClocks();
        return new AutoDriverOnlySimStepResult(completedVINs);
    }

    private void checkForCollisions() {
        Integer[] keys = this.vinToVehicles.keySet().toArray(new Integer[0]);
        for (int i = 0; i < keys.length - 1; ++i) {
            Integer[] keysToCompare = Arrays.copyOfRange(keys, i + 1, keys.length);
            VehicleSimView vehicle1 = this.vinToVehicles.get(keys[i]);
            for (int j = 0; j < keysToCompare.length; ++j) {
                VehicleSimView vehicle2 = this.vinToVehicles.get(keysToCompare[j]);
                if (!VehicleUtil.collision(vehicle1, vehicle2)) continue;
                throw new RuntimeException(String.format("There was a collision between vehicles %d and %d", vehicle1.getVIN(), vehicle2.getVIN()));
            }
        }
    }

    @Override
    public synchronized BasicMap getMap() {
        return this.basicMap;
    }

    @Override
    public synchronized double getSimulationTime() {
        return this.currentTime;
    }

    @Override
    public synchronized int getNumCompletedVehicles() {
        return this.numOfCompletedVehicles;
    }

    @Override
    public synchronized double getAvgBitsTransmittedByCompletedVehicles() {
        if (this.numOfCompletedVehicles > 0) {
            return (double)this.totalBitsTransmittedByCompletedVehicles / (double)this.numOfCompletedVehicles;
        }
        return 0.0;
    }

    @Override
    public synchronized double getAvgBitsReceivedByCompletedVehicles() {
        if (this.numOfCompletedVehicles > 0) {
            return (double)this.totalBitsReceivedByCompletedVehicles / (double)this.numOfCompletedVehicles;
        }
        return 0.0;
    }

    @Override
    public synchronized Set<VehicleSimView> getActiveVehicles() {
        return new HashSet<VehicleSimView>(this.vinToVehicles.values());
    }

    @Override
    public VehicleSimView getActiveVehicle(int vin) {
        return this.vinToVehicles.get(vin);
    }

    @Override
    public synchronized void addProxyVehicle(ProxyVehicleSimView vehicle) {
        Point2D pos = vehicle.getPosition();
        Lane minLane = null;
        double minDistance = -1.0;
        for (Road road : this.basicMap.getRoads()) {
            for (Lane lane : road.getLanes()) {
                double d = lane.nearestDistance(pos);
                if (minLane != null && !(d < minDistance)) continue;
                minLane = lane;
                minDistance = d;
            }
        }
        assert (minLane != null);
        ProxyDriver driver = vehicle.getDriver();
        if (driver != null) {
            driver.setCurrentLane(minLane);
            driver.setSpawnPoint(null);
            driver.setDestination(null);
        }
        this.vinToVehicles.put(vehicle.getVIN(), vehicle);
    }

    private void spawnVehicles(double timeStep) {
        for (SpawnPoint spawnPoint : this.basicMap.getSpawnPoints()) {
            Iterator<SpawnPoint.SpawnSpec> iterator;
            List<SpawnPoint.SpawnSpec> spawnSpecs = spawnPoint.act(timeStep);
            if (spawnSpecs.isEmpty() || !this.canSpawnVehicle(spawnPoint) || !(iterator = spawnSpecs.iterator()).hasNext()) continue;
            SpawnPoint.SpawnSpec spawnSpec = iterator.next();
            Lane lane = spawnPoint.getLane();
            Map<Lane, SortedMap<Double, VehicleSimView>> vehicleLists = this.computeVehicleLists();
            if (!vehicleLists.isEmpty() && !vehicleLists.get(lane).isEmpty()) {
                double initVelocity = Math.min(spawnSpec.getVehicleSpec().getMaxVelocity(), lane.getSpeedLimit());
                double distanceTillNextVehicle = vehicleLists.get(lane).firstKey();
                double stoppingDistance = VehicleUtil.calcDistanceToStop(initVelocity, spawnSpec.getVehicleSpec().getMaxDeceleration());
                double followingDistance = stoppingDistance + V2IPilot.MINIMUM_FOLLOWING_DISTANCE;
                if (!(distanceTillNextVehicle - Double.max(spawnPoint.getNoVehicleZone().getHeight(), spawnPoint.getNoVehicleZone().getWidth()) > followingDistance)) continue;
                VehicleSimView vehicle = this.makeVehicle(spawnPoint, spawnSpec);
                VinRegistry.registerVehicle(vehicle);
                this.vinToVehicles.put(vehicle.getVIN(), vehicle);
                continue;
            }
            VehicleSimView vehicle = this.makeVehicle(spawnPoint, spawnSpec);
            VinRegistry.registerVehicle(vehicle);
            this.vinToVehicles.put(vehicle.getVIN(), vehicle);
        }
    }

    private boolean canSpawnVehicle(SpawnPoint spawnPoint) {
        Rectangle2D noVehicleZone = spawnPoint.getNoVehicleZone();
        for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            if (!vehicle.getShape().intersects(noVehicleZone)) continue;
            return false;
        }
        return true;
    }

    private VehicleSimView makeVehicle(SpawnPoint spawnPoint, SpawnPoint.SpawnSpec spawnSpec) {
        VehicleSpec spec = spawnSpec.getVehicleSpec();
        Lane lane = spawnPoint.getLane();
        double initVelocity = Math.min(spec.getMaxVelocity(), lane.getSpeedLimit());
        BasicAutoVehicle vehicle = new BasicAutoVehicle(spec, spawnPoint.getPosition(), spawnPoint.getHeading(), spawnPoint.getSteeringAngle(), initVelocity, initVelocity, spawnPoint.getAcceleration(), spawnSpec.getSpawnTime());
        AutoDriver driver = new AutoDriver(vehicle, this.basicMap);
        driver.setCurrentLane(lane);
        driver.setSpawnPoint(spawnPoint);
        driver.setDestination(spawnSpec.getDestinationRoad());
        vehicle.setDriver(driver);
        return vehicle;
    }

    private Map<Lane, SortedMap<Double, VehicleSimView>> computeVehicleLists() {
        HashMap<Lane, SortedMap<Double, VehicleSimView>> vehicleLists = new HashMap<Lane, SortedMap<Double, VehicleSimView>>();
        for (Road road : this.basicMap.getRoads()) {
            for (Lane lane : road.getLanes()) {
                vehicleLists.put(lane, new TreeMap());
            }
        }
        for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            Set<Lane> lanes = vehicle.getDriver().getCurrentlyOccupiedLanes();
            for (Lane lane : lanes) {
                IntersectionManager im = lane.getLaneIM().nextIntersectionManager(vehicle.getPosition());
                if (im != null && im.intersectsPoint(vehicle.getPosition()) && im.intersectsPoint(vehicle.getPointAtRear())) continue;
                double dst = lane.distanceAlongLane(vehicle.getPosition());
                ((SortedMap)vehicleLists.get(lane)).put(dst, vehicle);
                for (Road road : Debug.currentMap.getRoads()) {
                    for (Lane otherLane : road.getLanes()) {
                        if (otherLane.getId() == lane.getId() || !otherLane.getShape().getBounds2D().intersects(vehicle.getShape().getBounds2D())) continue;
                        double dstAlongOtherLane = otherLane.distanceAlongLane(vehicle.getPosition());
                        ((SortedMap)vehicleLists.get(otherLane)).put(dstAlongOtherLane, vehicle);
                    }
                }
            }
        }
        for (Road road : this.basicMap.getRoads()) {
            for (Lane lane : road.getLanes()) {
                if (!vehicleLists.containsKey(lane)) continue;
                Lane currLane = lane;
                while (currLane.hasNextLane()) {
                    currLane = currLane.getNextLane();
                    ((SortedMap)vehicleLists.get(lane)).putAll((Map)vehicleLists.remove(currLane));
                }
            }
        }
        return vehicleLists;
    }

    private Map<VehicleSimView, VehicleSimView> computeNextVehicle(Map<Lane, SortedMap<Double, VehicleSimView>> vehicleLists) {
        HashMap<VehicleSimView, VehicleSimView> nextVehicle = new HashMap<VehicleSimView, VehicleSimView>();
        for (SortedMap<Double, VehicleSimView> vehicleList : vehicleLists.values()) {
            VehicleSimView lastVehicle = null;
            for (VehicleSimView currVehicle : vehicleList.values()) {
                if (lastVehicle != null) {
                    nextVehicle.put(lastVehicle, currVehicle);
                }
                lastVehicle = currVehicle;
            }
        }
        return nextVehicle;
    }

    private void provideSensorInput() {
        Map<Lane, SortedMap<Double, VehicleSimView>> vehicleLists = this.computeVehicleLists();
        Map<VehicleSimView, VehicleSimView> nextVehicle = this.computeNextVehicle(vehicleLists);
        this.provideIntervalInfo(nextVehicle);
        this.provideVehicleTrackingInfo(vehicleLists);
        this.provideTrafficSignal();
    }

    private void provideIntervalInfo(Map<VehicleSimView, VehicleSimView> nextVehicle) {
        block5: for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            if (!(vehicle instanceof AutoVehicleSimView)) continue;
            AutoVehicleSimView autoVehicle = (AutoVehicleSimView)vehicle;
            switch (autoVehicle.getLRFMode()) {
                case DISABLED: {
                    double interval = nextVehicle.containsKey(autoVehicle) ? this.calcInterval(autoVehicle, nextVehicle.get(autoVehicle)) : Double.MAX_VALUE;
                    autoVehicle.getIntervalometer().record(interval);
                    autoVehicle.setLRFSensing(false);
                    continue block5;
                }
                case LIMITED: {
                    autoVehicle.setLRFSensing(true);
                    continue block5;
                }
                case ENABLED: {
                    autoVehicle.setLRFSensing(true);
                    continue block5;
                }
            }
            throw new RuntimeException("Unknown LRF Mode: " + autoVehicle.getLRFMode().toString());
        }
    }

    private void provideVehicleTrackingInfo(Map<Lane, SortedMap<Double, VehicleSimView>> vehicleLists) {
        for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            double d;
            AutoVehicleSimView autoVehicle;
            if (!(vehicle instanceof AutoVehicleSimView) || !(autoVehicle = (AutoVehicleSimView)vehicle).isVehicleTracking()) continue;
            AutoDriver driver = autoVehicle.getDriver();
            Lane targetLane = autoVehicle.getTargetLaneForVehicleTracking();
            Point2D pos = autoVehicle.getPosition();
            double dst = targetLane.distanceAlongLane(pos);
            double frontDst = Double.MAX_VALUE;
            double rearDst = Double.MAX_VALUE;
            VehicleSimView frontVehicle = null;
            VehicleSimView rearVehicle = null;
            SortedMap<Double, VehicleSimView> vehiclesOnTargetLane = vehicleLists.get(targetLane);
            try {
                d = vehiclesOnTargetLane.tailMap(dst).firstKey();
                frontVehicle = (VehicleSimView)vehiclesOnTargetLane.get(d);
                frontDst = d - dst - frontVehicle.getSpec().getLength();
            }
            catch (NoSuchElementException e) {
                frontDst = Double.MAX_VALUE;
                frontVehicle = null;
            }
            try {
                d = vehiclesOnTargetLane.headMap(dst).lastKey();
                rearVehicle = (VehicleSimView)vehiclesOnTargetLane.get(d);
                rearDst = dst - d;
            }
            catch (NoSuchElementException e) {
                rearDst = Double.MAX_VALUE;
                rearVehicle = null;
            }
            autoVehicle.getFrontVehicleDistanceSensor().record(frontDst);
            autoVehicle.getRearVehicleDistanceSensor().record(rearDst);
            if (frontVehicle != null) {
                autoVehicle.getFrontVehicleSpeedSensor().record(frontVehicle.getVelocity());
            } else {
                autoVehicle.getFrontVehicleSpeedSensor().record(Double.MAX_VALUE);
            }
            if (rearVehicle != null) {
                autoVehicle.getRearVehicleSpeedSensor().record(rearVehicle.getVelocity());
            } else {
                autoVehicle.getRearVehicleSpeedSensor().record(Double.MAX_VALUE);
            }
            if (!Debug.isTargetVIN(driver.getVehicle().getVIN())) continue;
            Point2D p1 = targetLane.getPointAtNormalizedDistance(Math.max((dst - rearDst) / targetLane.getLength(), 0.0));
            Point2D p2 = targetLane.getPointAtNormalizedDistance(Math.min((frontDst + dst) / targetLane.getLength(), 1.0));
            Debug.addLongTermDebugPoint(new DebugPoint(p2, p1, "cl", Color.RED.brighter()));
        }
    }

    private void provideTrafficSignal() {
        for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            if (!(vehicle instanceof HumanDrivenVehicleSimView)) continue;
            HumanDrivenVehicleSimView manualVehicle = (HumanDrivenVehicleSimView)vehicle;
            this.provideTrafficLightSignal(manualVehicle);
        }
    }

    private double calcInterval(VehicleSimView vehicle, VehicleSimView nextVehicle) {
        Point2D pos = vehicle.getPosition();
        if (nextVehicle.getShape().contains(pos)) {
            return 0.0;
        }
        double interval = Double.MAX_VALUE;
        for (Line2D edge : nextVehicle.getEdges()) {
            double dst = edge.ptSegDist(pos);
            if (!(dst < interval)) continue;
            interval = dst;
        }
        return interval;
    }

    private void provideTrafficLightSignal(HumanDrivenVehicleSimView vehicle) {
    }

    private void letDriversAct() {
        for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            vehicle.getDriver().act();
        }
    }

    private void letIntersectionManagersAct(double timeStep) {
        for (IntersectionManager im : this.basicMap.getIntersectionManagers()) {
            im.act(timeStep);
        }
    }

    private void communication() {
        this.deliverV2IMessages();
        this.deliverI2VMessages();
    }

    private void deliverV2IMessages() {
        for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            if (!(vehicle instanceof AutoVehicleSimView)) continue;
            AutoVehicleSimView sender = (AutoVehicleSimView)vehicle;
            Queue<V2IMessage> v2iOutbox = sender.getV2IOutbox();
            while (!v2iOutbox.isEmpty()) {
                V2IMessage msg = v2iOutbox.poll();
                V2IManager receiver = (V2IManager)this.basicMap.getImRegistry().get(msg.getImId());
                double txDistance = sender.getPosition().distance(receiver.getIntersection().getCentroid());
                if (!this.transmit(txDistance, sender.getTransmissionPower())) continue;
                receiver.receive(msg);
            }
        }
    }

    private void deliverI2VMessages() {
        for (IntersectionManager im : this.basicMap.getIntersectionManagers()) {
            V2IManager senderIM = (V2IManager)im;
            Iterator<I2VMessage> i2vIter = senderIM.outboxIterator();
            while (i2vIter.hasNext()) {
                I2VMessage msg = i2vIter.next();
                AutoVehicleSimView vehicle = (AutoVehicleSimView)VinRegistry.getVehicleFromVIN(msg.getVin());
                double txDistance = senderIM.getIntersection().getCentroid().distance(vehicle.getPosition());
                if (!this.transmit(txDistance, senderIM.getTransmissionPower())) continue;
                vehicle.receive(msg);
            }
            senderIM.clearOutbox();
        }
    }

    private boolean transmit(double distance, double power) {
        return distance <= power;
    }

    private void moveVehicles(double timeStep) {
        for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            Point2D p1 = vehicle.getPosition();
            vehicle.move(timeStep);
            Point2D p2 = vehicle.getPosition();
            for (DataCollectionLine line : this.basicMap.getDataCollectionLines()) {
                line.intersect(vehicle, this.currentTime, p1, p2);
            }
            if (!Debug.isPrintVehicleStateOfVIN(vehicle.getVIN())) continue;
            vehicle.printState();
        }
    }

    private List<Integer> cleanUpCompletedVehicles() {
        LinkedList<Integer> completedVINs = new LinkedList<Integer>();
        Rectangle2D mapBoundary = this.basicMap.getDimensions();
        ArrayList<Integer> removedVINs = new ArrayList<Integer>(this.vinToVehicles.size());
        for (int vin : this.vinToVehicles.keySet()) {
            VehicleSimView v = this.vinToVehicles.get(vin);
            if (v.getShape().intersects(mapBoundary)) continue;
            if (v instanceof AutoVehicleSimView) {
                AutoVehicleSimView v2 = (AutoVehicleSimView)v;
                this.totalBitsTransmittedByCompletedVehicles += v2.getBitsTransmitted();
                this.totalBitsReceivedByCompletedVehicles += v2.getBitsReceived();
            }
            removedVINs.add(vin);
        }
        for (int vin : removedVINs) {
            this.vinToVehicles.remove(vin);
            completedVINs.add(vin);
            ++this.numOfCompletedVehicles;
        }
        return completedVINs;
    }

    private void checkClocks() {
        for (VehicleSimView vehicle : this.vinToVehicles.values()) {
            vehicle.checkCurrentTime(this.currentTime);
        }
        for (IntersectionManager im : this.basicMap.getIntersectionManagers()) {
            im.checkCurrentTime(this.currentTime);
        }
    }

    public static class AutoDriverOnlySimStepResult
    implements Simulator.SimStepResult {
        List<Integer> completedVINs;

        public AutoDriverOnlySimStepResult(List<Integer> completedVINs) {
            this.completedVINs = completedVINs;
        }

        public List<Integer> getCompletedVINs() {
            return this.completedVINs;
        }
    }
}

