/*
 * Decompiled with CFR 0.152.
 */
package aim4.sim;

import aim4.driver.ProxyDriver;
import aim4.msg.udp.Real2ProxyCancel;
import aim4.msg.udp.Real2ProxyDone;
import aim4.msg.udp.Real2ProxyMsg;
import aim4.msg.udp.Real2ProxyPVUpdate;
import aim4.msg.udp.Real2ProxyRequest;
import aim4.msg.udp.UdpHeader;
import aim4.sim.Simulator;
import aim4.vehicle.ProxyVehicle;
import aim4.vehicle.ProxyVehicleSimView;
import aim4.vehicle.VinRegistry;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;

public class UdpListener
implements Runnable {
    private static final int DEFAULT_LISTENER_UDP_PORT = 46000;
    private static final int DEFAULT_VEHICLE_UDP_PORT = 46042;
    private final int udpPort;
    private final Simulator sim;
    private DatagramSocket ds;
    private Map<SocketAddress, ProxyVehicleSimView> sa2ProxyVehicle;
    private volatile Thread blinker;

    public UdpListener(Simulator sim) {
        this(46000, sim);
    }

    public UdpListener(int udpPort, Simulator sim) {
        this.udpPort = udpPort;
        this.sim = sim;
        this.ds = null;
        this.sa2ProxyVehicle = new HashMap<SocketAddress, ProxyVehicleSimView>();
        this.blinker = null;
    }

    protected void finalize() throws Throwable {
        this.blinker = null;
        this.closeSocket();
        super.finalize();
    }

    public synchronized boolean hasStarted() {
        return this.blinker != null;
    }

    public synchronized void start() {
        assert (this.blinker == null);
        this.blinker = new Thread(this);
        this.blinker.start();
    }

    public synchronized void stop() {
        assert (this.blinker != null);
        this.blinker = null;
        this.closeSocket();
    }

    @Override
    public void run() {
        try {
            this.ds = new DatagramSocket(this.udpPort);
        }
        catch (SocketException e) {
            System.err.println("Cannot open UDP socket.\n");
            e.printStackTrace();
            return;
        }
        int numBytes = 1024;
        Thread thisThread = Thread.currentThread();
        while (this.blinker == thisThread) {
            DatagramPacket dp = new DatagramPacket(new byte[numBytes], numBytes);
            try {
                this.ds.receive(dp);
            }
            catch (IOException e) {
                break;
            }
            this.processIncomingDatagram(dp);
            Thread.yield();
        }
        this.closeSocket();
    }

    private synchronized void closeSocket() {
        if (this.ds != null) {
            if (this.ds.isConnected()) {
                this.ds.disconnect();
            }
            if (!this.ds.isClosed()) {
                this.ds.close();
            }
            this.ds = null;
            System.err.println("The UDP socket is closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncomingDatagram(DatagramPacket dp) {
        Simulator simulator = this.sim;
        synchronized (simulator) {
            SocketAddress sa = dp.getSocketAddress();
            Real2ProxyMsg msg = this.convertDatagramToReal2ProxyMsg(dp);
            if (!(msg instanceof Real2ProxyPVUpdate)) {
                System.err.printf("Proxy vehicle received a Real2Proxy msg: %s\n", msg);
            }
            if (msg == null) {
                System.err.println("Error: cannot parse the datagram package.");
                return;
            }
            if (this.sa2ProxyVehicle.containsKey(sa)) {
                this.sa2ProxyVehicle.get(sa).processReal2ProxyMsg(msg);
            } else if (msg.messageType == Real2ProxyMsg.Type.PV_UPDATE) {
                Real2ProxyPVUpdate pvUpdateMsg = (Real2ProxyPVUpdate)msg;
                ProxyVehicleSimView vehicle = this.makeProxyVehicle(pvUpdateMsg);
                if (VinRegistry.registerVehicleWithExistingVIN(vehicle, pvUpdateMsg.vin)) {
                    String address = sa.toString();
                    address = address.substring(1, address.indexOf(58));
                    vehicle.setSa(new InetSocketAddress(address, 46042));
                    this.sa2ProxyVehicle.put(sa, vehicle);
                    this.sim.addProxyVehicle(vehicle);
                    System.err.printf("A proxy vehicle is created at time %.2f (vin=%d).\n", this.sim.getSimulationTime(), vehicle.getVIN());
                } else {
                    System.err.println("Warning: the VIN of the UPD message has already been used by other vehicles.");
                }
            } else {
                System.err.println("Warning: first message from a new real vehicle must be a PVUpdate.");
            }
        }
    }

    private Real2ProxyMsg convertDatagramToReal2ProxyMsg(DatagramPacket dp) {
        byte[] data = dp.getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        UdpHeader header = null;
        try {
            header = new UdpHeader(dis);
        }
        catch (IOException e) {
            System.err.println("Error: Datagram has a corrupted header.");
            return null;
        }
        if (header.getChecksum() != UdpHeader.computeChecksum(data)) {
            System.err.println("Error: Datagram has a corrupted checksum.");
            return null;
        }
        Real2ProxyMsg msg = null;
        switch (header.getMessageType()) {
            case PVUpdate: {
                try {
                    msg = new Real2ProxyPVUpdate(dis, this.sim.getSimulationTime());
                }
                catch (IOException e) {
                    System.err.println("Error: Datagram has a corrupted body for a PV_UPDATE message.");
                }
                break;
            }
            case V2I_Request: {
                try {
                    msg = new Real2ProxyRequest(dis, this.sim.getSimulationTime());
                }
                catch (IOException e) {
                    System.err.println("Error: Datagram has a corrupted body for a REQUEST message.");
                }
                break;
            }
            case V2I_Cancel: {
                try {
                    msg = new Real2ProxyCancel(dis, this.sim.getSimulationTime());
                }
                catch (IOException e) {
                    System.err.println("Error: Datagram has a corrupted body for a CANCEL message.");
                }
                break;
            }
            case V2I_Done: {
                try {
                    msg = new Real2ProxyDone(dis, this.sim.getSimulationTime());
                }
                catch (IOException e) {
                    System.err.println("Error: Datagram has a corrupted body for a DONE message.");
                }
                break;
            }
            default: {
                System.err.println("Error: Unknown UDP message type");
            }
        }
        return msg;
    }

    private ProxyVehicleSimView makeProxyVehicle(Real2ProxyPVUpdate msg) {
        ProxyVehicle vehicle = new ProxyVehicle(msg.position, msg.heading, msg.steeringAngle, msg.velocity, msg.targetVelocity, msg.acceleration, msg.receivedTime);
        vehicle.setDriver(new ProxyDriver(vehicle, this.sim.getMap()));
        assert (vehicle.getDriver() != null);
        return vehicle;
    }
}

