/*
 * Decompiled with CFR 0.152.
 */
package aim4.sim.setup;

import aim4.config.Debug;
import aim4.driver.pilot.V2IPilot;
import aim4.im.v2i.reservation.ReservationGridManager;
import aim4.map.GridMap;
import aim4.map.GridMapUtil;
import aim4.sim.AutoDriverOnlySimulator;
import aim4.sim.Simulator;
import aim4.sim.setup.BasicSimSetup;
import aim4.sim.setup.SimSetup;

public class ApproxSimpleTrafficSignalSimSetup
extends BasicSimSetup
implements SimSetup {
    private double greenLightDuration = 30.0;
    private double yellowLightDuration = 30.0;

    public ApproxSimpleTrafficSignalSimSetup(BasicSimSetup basicSimSetup) {
        super(basicSimSetup);
    }

    public ApproxSimpleTrafficSignalSimSetup(int columns, int rows, double laneWidth, double speedLimit, int lanesPerRoad, double medianSize, double distanceBetween, double trafficLevel, double stopDistBeforeIntersection) {
        super(columns, rows, laneWidth, speedLimit, lanesPerRoad, medianSize, distanceBetween, trafficLevel, stopDistBeforeIntersection);
    }

    public void setGreenLightDuration(double greenLightDuration) {
        this.greenLightDuration = greenLightDuration;
    }

    public void setYellowLightDuration(double yellowLightDuration) {
        this.yellowLightDuration = yellowLightDuration;
    }

    @Override
    public Simulator getSimulator() {
        double currentTime = 0.0;
        GridMap layout = new GridMap(currentTime, this.numOfColumns, this.numOfRows, this.laneWidth, this.speedLimit, this.lanesPerRoad, this.medianSize, this.distanceBetween);
        ReservationGridManager.Config gridConfig = new ReservationGridManager.Config(0.02, 0.02, 0.1, 0.15, 0.15, true, 1.0);
        Debug.SHOW_VEHICLE_COLOR_BY_MSG_STATE = false;
        GridMapUtil.setApproxSimpleTrafficLightManagers(layout, currentTime, gridConfig, this.greenLightDuration, this.yellowLightDuration);
        if (this.numOfColumns == 1 && this.numOfRows == 1) {
            GridMapUtil.setUniformTurnBasedSpawnPoints(layout, this.trafficLevel);
        } else {
            GridMapUtil.setUniformRandomSpawnPoints(layout, this.trafficLevel);
        }
        V2IPilot.DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION = this.stopDistBeforeIntersection;
        return new AutoDriverOnlySimulator(layout);
    }
}

