/*
 * Decompiled with CFR 0.152.
 */
package aim4.sim.setup;

import aim4.config.Debug;
import aim4.config.SimConfig;
import aim4.driver.pilot.V2IPilot;
import aim4.im.v2i.reservation.ReservationGridManager;
import aim4.map.GridMap;
import aim4.map.GridMapUtil;
import aim4.sim.AutoDriverOnlySimulator;
import aim4.sim.Simulator;
import aim4.sim.setup.BasicSimSetup;
import aim4.sim.setup.SimSetup;

public class ApproxStopSignSimSetup
extends BasicSimSetup
implements SimSetup {
    private String trafficVolumeFileName = null;

    public ApproxStopSignSimSetup(BasicSimSetup basicSimSetup) {
        super(basicSimSetup);
    }

    public ApproxStopSignSimSetup(int columns, int rows, double laneWidth, double speedLimit, int lanesPerRoad, double medianSize, double distanceBetween, double trafficLevel, double stopDistBeforeIntersection) {
        super(columns, rows, laneWidth, speedLimit, lanesPerRoad, medianSize, distanceBetween, trafficLevel, stopDistBeforeIntersection);
    }

    public void setTrafficVolume(String trafficVolumeFileName) {
        this.trafficVolumeFileName = trafficVolumeFileName;
    }

    @Override
    public Simulator getSimulator() {
        double currentTime = 0.0;
        GridMap layout = new GridMap(currentTime, this.numOfColumns, this.numOfRows, this.laneWidth, this.speedLimit, this.lanesPerRoad, this.medianSize, this.distanceBetween);
        ReservationGridManager.Config gridConfig = new ReservationGridManager.Config(0.02, 0.02, 0.0, 0.0, 0.0, true, 1.0);
        SimConfig.MUST_STOP_BEFORE_INTERSECTION = true;
        Debug.SHOW_VEHICLE_COLOR_BY_MSG_STATE = false;
        GridMapUtil.setApproxStopSignManagers(layout, currentTime, gridConfig);
        if (this.trafficVolumeFileName == null) {
            if (this.numOfColumns == 1 && this.numOfRows == 1) {
                GridMapUtil.setUniformTurnBasedSpawnPoints(layout, this.trafficLevel);
            } else {
                GridMapUtil.setUniformRandomSpawnPoints(layout, this.trafficLevel);
            }
        } else {
            GridMapUtil.setUniformRatioSpawnPoints(layout, this.trafficVolumeFileName);
        }
        V2IPilot.DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION = this.stopDistBeforeIntersection;
        return new AutoDriverOnlySimulator(layout);
    }
}

