/*
 * Decompiled with CFR 0.152.
 */
package aim4.util;

import aim4.util.Registry;
import java.util.ArrayList;

public class ArrayListRegistry<T>
implements Registry<T> {
    private static final int INITIAL_CAPACITY = 10;
    private int initId;
    private int nextId;
    private ArrayList<T> idToObj = new ArrayList(10);

    public ArrayListRegistry() {
        this(0);
    }

    public ArrayListRegistry(int initId) {
        this.initId = initId;
        this.nextId = initId;
    }

    @Override
    public int register(T obj) {
        int id = this.nextId++;
        this.idToObj.add(obj);
        return id;
    }

    @Override
    public boolean isIdExist(int id) {
        return this.initId <= id && id < this.nextId;
    }

    @Override
    public T get(int id) {
        if (this.isIdExist(id)) {
            return this.idToObj.get(id - this.initId);
        }
        return null;
    }

    @Override
    public int getNewId() {
        int id = this.nextId++;
        this.idToObj.add(null);
        return id;
    }

    @Override
    public void set(int id, T obj) {
        assert (this.isIdExist(id));
        this.idToObj.set(id - this.initId, obj);
    }

    @Override
    public void setNull(int id) {
        this.idToObj.set(id - this.initId, null);
    }
}

