/*
 * Decompiled with CFR 0.152.
 */
package aim4.util;

import aim4.util.Registry;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class WeakRefRegistry<T>
implements Registry<T> {
    private int initId;
    private int nextId;
    private Map<Integer, WeakReference<T>> idToObj = new HashMap<Integer, WeakReference<T>>();

    public WeakRefRegistry() {
        this(0);
    }

    public WeakRefRegistry(int initId) {
        this.initId = initId;
        this.nextId = initId;
    }

    @Override
    public int register(T obj) {
        int id = this.nextId++;
        this.idToObj.put(id, new WeakReference<T>(obj));
        return id;
    }

    @Override
    public boolean isIdExist(int id) {
        return this.initId <= id && id < this.nextId;
    }

    @Override
    public T get(int id) {
        WeakReference<T> wr = this.idToObj.get(id);
        if (wr == null) {
            return null;
        }
        Object obj = wr.get();
        if (obj == null) {
            this.idToObj.remove(id);
            return null;
        }
        return obj;
    }

    @Override
    public int getNewId() {
        int id = this.nextId++;
        this.idToObj.put(id, null);
        return id;
    }

    @Override
    public void set(int id, T obj) {
        assert (this.idToObj.containsKey(id));
        this.idToObj.put(id, new WeakReference<T>(obj));
    }

    @Override
    public void setNull(int id) {
        this.idToObj.remove(id);
    }
}

