/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import aim4.util.Util;
import aim4.vehicle.AccelSchedule;
import java.util.LinkedList;
import java.util.List;

public class AccelProfile {
    private List<DurAccel> durAccelList = new LinkedList<DurAccel>();

    public void add(double dur, double acc) {
        if (!Util.isDoubleZero(dur)) {
            this.durAccelList.add(new DurAccel(dur, acc));
        }
    }

    public int size() {
        return this.durAccelList.size();
    }

    public List<DurAccel> getDurAccelList() {
        return this.durAccelList;
    }

    public AccelSchedule toAccelSchedule(double initTime) {
        AccelSchedule accelProfile = new AccelSchedule();
        double t = initTime;
        for (DurAccel durAccel : this.durAccelList) {
            accelProfile.add(t, durAccel.getAcceleration());
            t += durAccel.getDuration();
        }
        return accelProfile;
    }

    public AccelSchedule toAccelSchedule(double initTime, double lastAccel) {
        AccelSchedule accelProfile = new AccelSchedule();
        double t = initTime;
        for (DurAccel durAccel : this.durAccelList) {
            accelProfile.add(t, durAccel.getAcceleration());
            t += durAccel.getDuration();
        }
        accelProfile.add(t, lastAccel);
        return accelProfile;
    }

    public static class DurAccel {
        private double duration;
        private double acceleration;

        public DurAccel(double duration, double acceleration) {
            this.duration = duration;
            this.acceleration = acceleration;
        }

        public double getDuration() {
            return this.duration;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public void setDuration(double duration) {
            this.duration = duration;
        }

        public void setAcceleration(double acceleration) {
            this.acceleration = acceleration;
        }
    }
}

