/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import aim4.config.Debug;
import aim4.driver.AutoDriver;
import aim4.map.lane.Lane;
import aim4.msg.i2v.I2VMessage;
import aim4.msg.v2i.V2IMessage;
import aim4.noise.DoubleGauge;
import aim4.vehicle.AutoVehicleDriverView;
import aim4.vehicle.AutoVehicleSimView;
import aim4.vehicle.BasicVehicle;
import aim4.vehicle.VehicleSpec;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class BasicAutoVehicle
extends BasicVehicle
implements AutoVehicleSimView {
    private static final double SENSOR_RANGE_MULT_B = 1.5;
    private static final double SENSOR_RANGE_MULT_S = 0.25;
    public static final double DEFAULT_TRANSMISSION_POWER = 250.0;
    private AutoDriver driver;
    private double transmissionPower = 250.0;
    private Queue<V2IMessage> v2iOutbox = new LinkedList<V2IMessage>();
    private Queue<I2VMessage> i2vInbox = new LinkedList<I2VMessage>();
    protected int bitsReceived;
    private int bitsTransmitted;
    private DoubleGauge intervalometer = new DoubleGauge();
    private AutoVehicleDriverView.LRFMode lrfMode = AutoVehicleDriverView.LRFMode.DISABLED;
    private boolean lrfSensing = false;
    private DoubleGauge lrfAngle = new DoubleGauge();
    private DoubleGauge lrfDistance = new DoubleGauge();
    private boolean vehicleTracking = false;
    private Lane vehicleTrackingTargetLane = null;
    private DoubleGauge frontVehicleDistanceSensor = new DoubleGauge();
    private DoubleGauge rearVehicleDistanceSensor = new DoubleGauge();
    private DoubleGauge frontVehicleSpeedSensor = new DoubleGauge();
    private DoubleGauge rearVehicleSpeedSensor = new DoubleGauge();
    private V2IMessage lastV2IMessage;

    public BasicAutoVehicle(VehicleSpec spec, Point2D pos, double heading, double steeringAngle, double velocity, double targetVelocity, double acceleration, double currentTime) {
        super(spec, pos, heading, velocity, steeringAngle, acceleration, targetVelocity, currentTime);
    }

    @Override
    public AutoDriver getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(AutoDriver driver) {
        this.driver = driver;
    }

    @Override
    public DoubleGauge getIntervalometer() {
        return this.intervalometer;
    }

    public void setLRFMode(AutoVehicleDriverView.LRFMode mode) {
        this.lrfMode = mode;
    }

    @Override
    public AutoVehicleDriverView.LRFMode getLRFMode() {
        return this.lrfMode;
    }

    @Override
    public boolean isLRFSensing() {
        return this.lrfSensing;
    }

    @Override
    public void setLRFSensing(boolean sensing) {
        this.lrfSensing = sensing;
    }

    public DoubleGauge getLRFAngle() {
        return this.lrfAngle;
    }

    @Override
    public DoubleGauge getLRFDistance() {
        return this.lrfDistance;
    }

    @Override
    public boolean isVehicleTracking() {
        return this.vehicleTracking;
    }

    @Override
    public void setVehicleTracking(boolean sensing) {
        this.vehicleTracking = sensing;
    }

    @Override
    public void setTargetLaneForVehicleTracking(Lane lane) {
        this.vehicleTrackingTargetLane = lane;
    }

    @Override
    public Lane getTargetLaneForVehicleTracking() {
        return this.vehicleTrackingTargetLane;
    }

    @Override
    public DoubleGauge getFrontVehicleDistanceSensor() {
        return this.frontVehicleDistanceSensor;
    }

    @Override
    public DoubleGauge getRearVehicleDistanceSensor() {
        return this.rearVehicleDistanceSensor;
    }

    @Override
    public DoubleGauge getFrontVehicleSpeedSensor() {
        return this.frontVehicleSpeedSensor;
    }

    @Override
    public DoubleGauge getRearVehicleSpeedSensor() {
        return this.rearVehicleSpeedSensor;
    }

    public void setTransmissionPower(double transmissionPower) {
        this.transmissionPower = transmissionPower;
    }

    @Override
    public double getTransmissionPower() {
        return this.transmissionPower;
    }

    @Override
    public Queue<V2IMessage> getV2IOutbox() {
        return this.v2iOutbox;
    }

    @Override
    public List<I2VMessage> pollAllMessagesFromI2VInbox() {
        ArrayList<I2VMessage> msgs = new ArrayList<I2VMessage>(this.i2vInbox);
        this.i2vInbox.clear();
        return msgs;
    }

    @Override
    public void send(V2IMessage msg) {
        if (Debug.isPrintVehicleOutboxMessageOfVIN(msg.getVin())) {
            System.err.printf("vin %d sends message: %s\n", this.vin, msg);
        }
        this.v2iOutbox.add(msg);
        this.bitsTransmitted += msg.getSize();
        this.lastV2IMessage = msg;
    }

    @Override
    public void receive(I2VMessage msg) {
        this.i2vInbox.add(msg);
        this.bitsReceived += msg.getSize();
    }

    @Override
    public int getBitsReceived() {
        return this.bitsReceived;
    }

    @Override
    public int getBitsTransmitted() {
        return this.bitsTransmitted;
    }

    @Override
    public V2IMessage getLastV2IMessage() {
        return this.lastV2IMessage;
    }
}

