/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import aim4.config.Constants;
import aim4.config.Debug;
import aim4.driver.Driver;
import aim4.map.track.TrackPosition;
import aim4.noise.DoubleGauge;
import aim4.util.GeomMath;
import aim4.util.GeomUtil;
import aim4.util.Util;
import aim4.vehicle.AccelSchedule;
import aim4.vehicle.VehicleSimView;
import aim4.vehicle.VehicleSpec;
import aim4.vehicle.VinRegistry;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;

public abstract class BasicVehicle
implements VehicleSimView {
    private static final double MIN_STEERING_THRESHOLD = 1.0E-5;
    protected int vin = -1;
    protected VehicleSpec spec;
    protected Movement movement;
    protected double currentTime;
    private DoubleGauge clock = new DoubleGauge();
    private DoubleGauge xometer = new DoubleGauge();
    private DoubleGauge yometer = new DoubleGauge();
    private DoubleGauge compass = new DoubleGauge();
    private DoubleGauge speedometer = new DoubleGauge();
    private Point2D memoGaugePosition;
    private Point2D memoGaugePointBetweenFrontWheels;
    private Shape memoGetShape;
    private Shape memoGaugeShape;

    public BasicVehicle(VehicleSpec spec, Point2D pos, double heading, double velocity, double steeringAngle, double acceleration, double targetVelocity, double currentTime) {
        this.spec = spec;
        this.movement = new MoveToTargetVelocityMovement(spec, pos, heading, velocity, steeringAngle, acceleration, targetVelocity);
        this.updateGaugesAndMemos();
        this.currentTime = currentTime;
        this.clock.record(currentTime);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.vin >= 0) {
            VinRegistry.unregisterVehicle(this.vin);
            this.vin = -1;
        }
    }

    @Override
    public int getVIN() {
        return this.vin;
    }

    @Override
    public void setVIN(int vin) {
        this.vin = vin;
    }

    @Override
    public VehicleSpec getSpec() {
        return this.spec;
    }

    @Override
    public double gaugeTime() {
        return this.clock.read();
    }

    @Override
    public abstract Driver getDriver();

    @Override
    public Point2D getPosition() {
        return this.movement.getPosition();
    }

    @Override
    public double getHeading() {
        return this.movement.getHeading();
    }

    public double getSteeringAngle() {
        if (this.movement instanceof PhysicalMovement) {
            PhysicalMovement m2 = (PhysicalMovement)this.movement;
            NonAccelMovement m3 = m2.getNonAccelMovement();
            if (m3 instanceof SteeringMovement) {
                return ((SteeringMovement)m3).getSteeringAngle();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double getVelocity() {
        return this.movement.getVelocity();
    }

    @Override
    public double getAcceleration() {
        if (this.movement instanceof MovementWithAccel) {
            return ((MovementWithAccel)this.movement).getAcceleration();
        }
        if (this.movement instanceof AccelScheduleMovement) {
            return ((AccelScheduleMovement)this.movement).getAcceleration();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AccelSchedule getAccelSchedule() {
        if (this.movement instanceof AccelScheduleMovement) {
            return ((AccelScheduleMovement)this.movement).getAccelSchedule();
        }
        return null;
    }

    @Override
    public Point2D gaugePosition() {
        return this.memoGaugePosition;
    }

    @Override
    public double gaugeVelocity() {
        return this.speedometer.read();
    }

    @Override
    public double gaugeHeading() {
        return this.compass.read();
    }

    @Override
    public Shape getShape() {
        return this.memoGetShape;
    }

    @Override
    public Shape gaugeShape() {
        return this.memoGaugeShape;
    }

    @Override
    public Shape getShape(double extra) {
        Point2D[] points = this.spec.getCornerPoints(extra, this.movement.getPosition(), this.movement.getHeading());
        return GeomUtil.convertPointsToShape(points);
    }

    @Override
    public List<Line2D> getEdges() {
        return GeomMath.polygonalShapePerimeterSegments(this.getShape());
    }

    @Override
    public Point2D getPointAtMiddleFront(double delta) {
        Point2D.Double p = new Point2D.Double(this.movement.getPosition().getX() + delta * Math.cos(this.movement.getHeading()), this.movement.getPosition().getY() + delta * Math.sin(this.movement.getHeading()));
        return p;
    }

    @Override
    public Point2D gaugePointAtMiddleFront(double delta) {
        Point2D mp = this.gaugePosition();
        double h = this.gaugeHeading();
        Point2D.Double p = new Point2D.Double(mp.getX() + delta * Math.cos(h), mp.getY() + delta * Math.sin(h));
        return p;
    }

    @Override
    public Point2D gaugePointBetweenFrontWheels() {
        return this.memoGaugePointBetweenFrontWheels;
    }

    @Override
    public Point2D getCenterPoint() {
        return this.spec.getCenterPoint(this.movement.getPosition(), this.movement.getHeading());
    }

    @Override
    public Point2D[] getCornerPoints() {
        return this.spec.getCornerPoints(this.movement.getPosition(), this.movement.getHeading());
    }

    public Point2D[] gaugeCornerPoints() {
        return this.spec.getCornerPoints(this.gaugePosition(), this.gaugeHeading());
    }

    @Override
    public Point2D getPointAtRear() {
        return this.spec.getPointAtRear(this.movement.getPosition(), this.movement.getHeading());
    }

    @Override
    public Point2D gaugePointAtRear() {
        return this.spec.getPointAtRear(this.gaugePosition(), this.gaugeHeading());
    }

    @Override
    public Point2D gaugeRearLeftCornerPoint() {
        return this.spec.getRearLeftCornerPoint(this.gaugePosition(), this.gaugeHeading());
    }

    @Override
    public Point2D gaugeRearRightCornerPoint() {
        return this.spec.getRearRightCornerPoint(this.gaugePosition(), this.gaugeHeading());
    }

    @Override
    public Shape[] getWheelShapes() {
        return this.spec.getWheelShapes(this.movement.getPosition(), this.movement.getHeading(), 0.0);
    }

    @Override
    public void move(double timeStep) {
        this.movement.move(this.currentTime, timeStep);
        this.currentTime += timeStep;
        this.updateGaugesAndMemos();
    }

    @Override
    public void turnTowardPoint(Point2D p) {
        NonAccelMovement m4;
        if (Debug.isPrintVehicleHighLevelControlOfVIN(this.vin)) {
            System.err.printf("vin %d turnTowardPoint()\n", this.vin);
        }
        double angle = GeomMath.angleToPoint(p, this.memoGaugePointBetweenFrontWheels);
        double newSteeringAngle = Util.recenter(angle - this.movement.getHeading(), -Math.PI, Math.PI);
        Movement m2 = this.movement;
        if (m2 instanceof AccelScheduleMovement) {
            m2 = ((AccelScheduleMovement)this.movement).getBaseMovement();
        }
        if (m2 instanceof PhysicalMovement) {
            PhysicalMovement m3 = (PhysicalMovement)m2;
            m4 = m3.getNonAccelMovement();
            if (!(m4 instanceof SteeringMovement)) {
                throw new UnsupportedOperationException();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        SteeringMovement m5 = (SteeringMovement)m4;
        m5.setSteeringAngleWithBound(newSteeringAngle);
    }

    @Override
    public void coast() {
        if (Debug.isPrintVehicleHighLevelControlOfVIN(this.vin)) {
            System.err.printf("vin %d coast()\n", this.vin);
        }
        this.switchToMoveToTargetVelocityMovement().coast();
    }

    @Override
    public void slowToStop() {
        if (Debug.isPrintVehicleHighLevelControlOfVIN(this.vin)) {
            System.err.printf("vin %d slowToStop()\n", this.vin);
        }
        this.switchToMoveToTargetVelocityMovement().slowToStop();
    }

    public void setMaxAccelWithMaxTargetVelocity() {
        if (Debug.isPrintVehicleHighLevelControlOfVIN(this.vin)) {
            System.err.printf("vin %d accelerate()\n", this.vin);
        }
        this.switchToMoveToTargetVelocityMovement().setMaxAccelWithMaxTargetVelocity();
    }

    @Override
    public void setTargetVelocityWithMaxAccel(double targetVelocity) {
        if (Debug.isPrintVehicleHighLevelControlOfVIN(this.vin)) {
            System.err.printf("vin %d accelToTargetVelocity()\n", this.vin);
        }
        this.switchToMoveToTargetVelocityMovement().setTargetVelocityWithMaxAccel(targetVelocity);
    }

    @Override
    public void setAccelWithMaxTargetVelocity(double acceleration) {
        if (Debug.isPrintVehicleHighLevelControlOfVIN(this.vin)) {
            System.err.printf("vin %d setAccelWithExtremeTargetVelocity()\n", this.vin);
        }
        this.switchToMoveToTargetVelocityMovement().setAccelWithMaxTargetVelocity(acceleration);
    }

    @Override
    public void setAccelSchedule(AccelSchedule accelSchedule) {
        if (Debug.isPrintVehicleHighLevelControlOfVIN(this.vin)) {
            System.err.printf("vin %d set accelerate schedule = %s\n", this.vin, accelSchedule);
        }
        this.switchToAccelScheduleMovement().setAccelSchedule(accelSchedule);
    }

    @Override
    public void removeAccelSchedule() {
        if (Debug.isPrintVehicleHighLevelControlOfVIN(this.vin)) {
            System.err.printf("vin %d removeAccelSchedule()\n", this.vin);
        }
        this.switchToMoveToTargetVelocityMovement();
    }

    private AccelScheduleMovement switchToAccelScheduleMovement() {
        if (this.movement instanceof AccelScheduleMovement) {
            return (AccelScheduleMovement)this.movement;
        }
        if (this.movement instanceof MovementWithAccel) {
            AccelScheduleMovement m = new AccelScheduleMovement((MovementWithAccel)this.movement);
            this.movement = m;
            return m;
        }
        throw new RuntimeException("Cannot switch to AccelScheduleMovement");
    }

    private MoveToTargetVelocityMovement switchToMoveToTargetVelocityMovement() {
        if (this.movement instanceof MoveToTargetVelocityMovement) {
            return (MoveToTargetVelocityMovement)this.movement;
        }
        if (this.movement instanceof AccelScheduleMovement) {
            MovementWithAccel m = ((AccelScheduleMovement)this.movement).getBaseMovement();
            assert (m instanceof MovementWithAccel);
            this.movement = m;
            return (MoveToTargetVelocityMovement)m;
        }
        throw new RuntimeException("Cannot switch to MoveToTargetVelocityMovement");
    }

    private void updateGaugesAndMemos() {
        this.clock.record(this.currentTime);
        this.xometer.record(this.movement.getPosition().getX());
        this.yometer.record(this.movement.getPosition().getY());
        this.compass.record(this.movement.getHeading());
        this.speedometer.record(this.movement.getVelocity());
        this.memoGaugePosition = new Point2D.Double(this.xometer.read(), this.yometer.read());
        this.memoGetShape = GeomUtil.convertPointsToShape(this.getCornerPoints());
        this.memoGaugeShape = GeomUtil.convertPointsToShape(this.gaugeCornerPoints());
        this.memoGaugePointBetweenFrontWheels = this.spec.getPointBetweenFrontWheels(this.gaugePosition(), this.gaugeHeading());
    }

    @Override
    public void checkCurrentTime(double currentTime) {
        if (!Util.isDoubleEqual(currentTime, this.currentTime, 1.0E-6)) {
            System.err.printf("currentTime = %.10f\n", currentTime);
            System.err.printf("this.currentTime = %.10f\n", this.currentTime);
        }
        assert (Util.isDoubleEqual(currentTime, this.currentTime, 1.0E-6));
    }

    @Override
    public void printState() {
        System.err.printf("State of vin %d: %s\n", this.vin, this.movement.toString());
    }

    public static class AccelScheduleMovement
    implements Movement {
        private MovementWithAccel baseMovement;
        private AccelSchedule accelSchedule;

        public AccelScheduleMovement(MovementWithAccel baseMovement) {
            this(baseMovement, null);
        }

        public AccelScheduleMovement(MovementWithAccel baseMovement, AccelSchedule accelSchedule) {
            this.baseMovement = baseMovement;
            this.accelSchedule = accelSchedule;
        }

        @Override
        public Point2D getPosition() {
            return this.baseMovement.getPosition();
        }

        @Override
        public double getHeading() {
            return this.baseMovement.getHeading();
        }

        @Override
        public double getVelocity() {
            return this.baseMovement.getVelocity();
        }

        public double getAcceleration() {
            return this.baseMovement.getAcceleration();
        }

        public MovementWithAccel getBaseMovement() {
            return this.baseMovement;
        }

        public AccelSchedule getAccelSchedule() {
            return this.accelSchedule;
        }

        public void setAccelSchedule(AccelSchedule accelSchedule) {
            this.accelSchedule = accelSchedule;
        }

        @Override
        public void move(double currentTime, double timeStep) {
            if (this.accelSchedule != null) {
                List<AccelSchedule.TimeAccel> tas = this.accelSchedule.getList();
                Iterator<AccelSchedule.TimeAccel> iter = tas.iterator();
                if (iter.hasNext()) {
                    AccelSchedule.TimeAccel ta = iter.next();
                    if (ta.getTime() > currentTime) {
                        double dur = ta.getTime() - currentTime;
                        if (dur < timeStep) {
                            this.baseMovement.move(currentTime, dur);
                            this.move(currentTime + dur, timeStep - dur);
                        } else {
                            this.baseMovement.move(currentTime, timeStep);
                        }
                    } else if (Util.isDoubleEqual(ta.getTime(), currentTime)) {
                        this.baseMovement.setAccelerationWithBound(ta.getAcceleration());
                        iter.remove();
                        if (iter.hasNext()) {
                            ta = iter.next();
                            double dur = ta.getTime() - currentTime;
                            if (dur < timeStep) {
                                this.baseMovement.move(currentTime, dur);
                                this.move(currentTime + dur, timeStep - dur);
                            } else {
                                this.baseMovement.move(currentTime, timeStep);
                            }
                        } else {
                            this.accelSchedule = null;
                            this.baseMovement.move(currentTime, timeStep);
                        }
                    } else {
                        iter.remove();
                        this.move(currentTime, timeStep);
                    }
                } else {
                    this.accelSchedule = null;
                    this.baseMovement.move(currentTime, timeStep);
                }
            } else {
                this.baseMovement.move(currentTime, timeStep);
            }
        }

        public String toString() {
            return this.baseMovement.toString() + ", accelSchedule=" + this.accelSchedule;
        }
    }

    public static class MoveToTargetVelocityMovement
    extends PhysicalMovement {
        private double targetVelocity;

        public MoveToTargetVelocityMovement(VehicleSpec spec, Point2D position, double heading, double velocity, double steeringAngle, double acceleration, double targetVelocity) {
            this(new SteeringMovement(spec, position, heading, velocity, steeringAngle), acceleration, targetVelocity);
        }

        public MoveToTargetVelocityMovement(NonAccelMovement basicMovement, double acceleration, double targetVelocity) {
            super(basicMovement, acceleration);
            this.targetVelocity = targetVelocity;
        }

        public void setTargetVelocityWithBound(double targetVelocity) {
            this.targetVelocity = Util.constrain(targetVelocity, this.spec.getMinVelocity(), this.spec.getMaxVelocity());
        }

        @Override
        public void setAccelerationWithBound(double acceleration) {
            super.setAccelerationWithBound(acceleration);
            double acceleration2 = this.getAcceleration();
            this.targetVelocity = Util.isDoubleZero(acceleration2) ? this.getVelocity() : (acceleration2 > 0.0 ? this.spec.getMaxVelocity() : this.spec.getMinVelocity());
        }

        @Override
        public void coast() {
            this.setAccelerationWithBound(0.0);
            this.setTargetVelocityWithBound(this.getVelocity());
        }

        public void slowToStop() {
            if (this.getVelocity() > 0.0) {
                this.setAccelerationWithBound(this.spec.getMaxDeceleration());
            } else if (this.getVelocity() < 0.0) {
                this.setAccelerationWithBound(this.spec.getMaxAcceleration());
            } else {
                this.setAccelerationWithBound(0.0);
            }
            this.setTargetVelocityWithBound(0.0);
        }

        public void setMaxAccelWithMaxTargetVelocity() {
            this.setAccelerationWithBound(this.spec.getMaxAcceleration());
            this.setTargetVelocityWithBound(this.spec.getMaxVelocity());
        }

        public void setTargetVelocityWithMaxAccel(double targetVelocity) {
            if (this.getVelocity() < targetVelocity) {
                this.setAccelerationWithBound(this.spec.getMaxAcceleration());
                this.setTargetVelocityWithBound(targetVelocity);
            } else if (this.getVelocity() > targetVelocity) {
                this.setAccelerationWithBound(this.spec.getMaxDeceleration());
                this.setTargetVelocityWithBound(targetVelocity);
            } else {
                this.setAccelerationWithBound(0.0);
            }
        }

        public void setAccelWithMaxTargetVelocity(double acceleration) {
            this.setAccelerationWithBound(acceleration);
            if (acceleration > 0.0) {
                this.setTargetVelocityWithBound(this.spec.getMaxVelocity());
            } else if (acceleration < 0.0) {
                this.setTargetVelocityWithBound(this.spec.getMinVelocity());
            } else {
                this.setTargetVelocityWithBound(this.getVelocity());
            }
        }

        @Override
        public void move(double currentTime, double timeStep) {
            double velocity = this.getVelocity();
            double acceleration = this.getAcceleration();
            if (Util.isDoubleZero(acceleration)) {
                this.moveWithoutAcceleration(currentTime, timeStep);
            } else if (acceleration > 0.0) {
                if (velocity >= this.targetVelocity) {
                    this.moveWithoutAcceleration(currentTime, timeStep);
                } else {
                    double requestedChange = this.targetVelocity - velocity;
                    double maxChange = acceleration * timeStep;
                    if (requestedChange >= maxChange) {
                        this.setVelocityWithBound(velocity + maxChange / 2.0);
                        this.moveWithoutAcceleration(currentTime, timeStep);
                        this.setVelocityWithBound(velocity + maxChange);
                    } else {
                        double accelDuration = requestedChange / acceleration;
                        this.setVelocityWithBound(velocity + requestedChange / 2.0);
                        this.moveWithoutAcceleration(currentTime, accelDuration);
                        this.setVelocityWithBound(velocity + requestedChange);
                        this.moveWithoutAcceleration(currentTime + accelDuration, timeStep - accelDuration);
                    }
                }
            } else if (velocity <= this.targetVelocity) {
                this.moveWithoutAcceleration(currentTime, timeStep);
            } else {
                double requestedChange = this.targetVelocity - velocity;
                double maxChange = acceleration * timeStep;
                if (requestedChange <= maxChange) {
                    this.setVelocityWithBound(velocity + maxChange / 2.0);
                    this.moveWithoutAcceleration(currentTime, timeStep);
                    this.setVelocityWithBound(velocity + maxChange);
                } else {
                    double accelDuration = requestedChange / acceleration;
                    this.setVelocityWithBound(velocity + requestedChange / 2.0);
                    this.moveWithoutAcceleration(currentTime, accelDuration);
                    this.setVelocityWithBound(velocity + requestedChange);
                    this.moveWithoutAcceleration(currentTime + accelDuration, timeStep - accelDuration);
                }
            }
        }

        @Override
        public String toString() {
            return super.toString() + ", targetVelocity=" + Constants.TWO_DEC.format(this.targetVelocity);
        }
    }

    public static class PhysicalMovement
    implements MovementWithAccel {
        protected final VehicleSpec spec;
        private NonAccelMovement nonAccelMovement;
        private double acceleration;

        public PhysicalMovement(NonAccelMovement nonAccelMovement, double acceleration) {
            this.spec = nonAccelMovement.getVehicleSpec();
            this.nonAccelMovement = nonAccelMovement;
            this.acceleration = acceleration;
        }

        @Override
        public Point2D getPosition() {
            return this.nonAccelMovement.getPosition();
        }

        @Override
        public double getHeading() {
            return this.nonAccelMovement.getHeading();
        }

        @Override
        public double getVelocity() {
            return this.nonAccelMovement.getVelocity();
        }

        @Override
        public double getAcceleration() {
            return this.acceleration;
        }

        public NonAccelMovement getNonAccelMovement() {
            return this.nonAccelMovement;
        }

        @Override
        public void setAccelerationWithBound(double acceleration) {
            this.acceleration = Util.constrain(acceleration, this.spec.getMaxDeceleration(), this.spec.getMaxAcceleration());
        }

        public void coast() {
            this.setAccelerationWithBound(0.0);
        }

        @Override
        public void move(double currentTime, double timeStep) {
            if (Util.isDoubleZero(this.acceleration)) {
                this.nonAccelMovement.move(currentTime, timeStep);
            } else {
                double maxChange = this.acceleration * timeStep;
                double velocity = this.nonAccelMovement.getVelocity();
                this.nonAccelMovement.setVelocityWithBound(velocity + maxChange / 2.0);
                this.nonAccelMovement.move(currentTime, timeStep);
                this.nonAccelMovement.setVelocityWithBound(velocity + maxChange);
            }
        }

        protected void moveWithoutAcceleration(double currentTime, double timeStep) {
            this.nonAccelMovement.move(currentTime, timeStep);
        }

        protected void setVelocityWithBound(double velocity) {
            this.nonAccelMovement.setVelocityWithBound(velocity);
        }

        public String toString() {
            return this.nonAccelMovement.toString() + ", acceleration=" + Constants.TWO_DEC.format(this.acceleration);
        }
    }

    public static interface MovementWithAccel
    extends Movement {
        public double getAcceleration();

        public void setAccelerationWithBound(double var1);
    }

    public static class TrackMovement
    extends NonAccelMovement {
        private TrackPosition trackPosition;
        private MovementFactory movementFactory;
        private Movement baseMovement;

        public TrackMovement(VehicleSpec spec, Point2D position, double heading, double velocity, TrackPosition trackPosition, MovementFactory baseMovementFactory) {
            super(spec, position, heading, velocity);
            this.trackPosition = trackPosition;
            this.movementFactory = baseMovementFactory;
            this.baseMovement = null;
        }

        @Override
        public void move(double currentTime, double timeStep) {
            if (this.baseMovement == null) {
                double dist = this.velocity * timeStep;
                double remainDist = this.trackPosition.move(dist);
                if (remainDist == 0.0) {
                    this.position = new Point2D.Double(this.trackPosition.getX(), this.trackPosition.getY());
                    this.heading = this.trackPosition.getTangentSlope();
                } else {
                    double remainTime = remainDist / this.velocity;
                    this.baseMovement = this.movementFactory.make(new Point2D.Double(this.trackPosition.getX(), this.trackPosition.getY()), this.trackPosition.getTangentSlope(), this.velocity);
                    this.baseMovement.move(currentTime + timeStep - remainTime, remainTime);
                    this.position = this.baseMovement.getPosition();
                    this.velocity = this.baseMovement.getVelocity();
                    this.heading = this.baseMovement.getHeading();
                }
            } else {
                this.baseMovement.move(currentTime, timeStep);
                this.position = this.baseMovement.getPosition();
                this.velocity = this.baseMovement.getVelocity();
                this.heading = this.baseMovement.getHeading();
            }
        }

        @Override
        public String toString() {
            return super.toString() + ", trackPosition =" + this.trackPosition;
        }
    }

    public static class SteeringMovement
    extends NonAccelMovement {
        private double steeringAngle;

        public SteeringMovement(VehicleSpec spec, Point2D position, double heading, double velocity, double steeringAngle) {
            super(spec, position, heading, velocity);
            this.steeringAngle = steeringAngle;
        }

        public double getSteeringAngle() {
            return this.steeringAngle;
        }

        public void setSteeringAngleWithBound(double steeringAngle) {
            this.steeringAngle = Util.constrain(steeringAngle, -1.0 * this.spec.getMaxSteeringAngle(), this.spec.getMaxSteeringAngle());
        }

        @Override
        public void move(double currentTime, double timeStep) {
            if (Math.abs(this.steeringAngle) < 1.0E-5) {
                double endX = this.position.getX() + this.velocity * Math.cos(this.heading) * timeStep;
                double endY = this.position.getY() + this.velocity * Math.sin(this.heading) * timeStep;
                this.position = new Point2D.Double(endX, endY);
            } else {
                double rotationRate = this.velocity * (Math.tan(this.steeringAngle) / this.spec.getWheelbase());
                double endHeading = GeomMath.canonicalAngle(this.heading + rotationRate * timeStep);
                Point2D p = this.spec.getPointBetweenRearWheels(this.position, this.heading);
                double endXdelta = p.getX() - this.spec.getWheelbase() / Math.tan(this.steeringAngle) * (Math.sin(this.heading) - Math.sin(endHeading));
                double endYdelta = p.getY() - this.spec.getWheelbase() / Math.tan(this.steeringAngle) * (Math.cos(endHeading) - Math.cos(this.heading));
                double endX = endXdelta + this.spec.getRearAxleDisplacement() * Math.cos(endHeading);
                double endY = endYdelta + this.spec.getRearAxleDisplacement() * Math.sin(endHeading);
                this.position = new Point2D.Double(endX, endY);
                this.heading = endHeading;
            }
        }

        @Override
        public String toString() {
            return super.toString() + ", steeringAngle=" + Constants.TWO_DEC.format(this.steeringAngle);
        }
    }

    public static abstract class NonAccelMovement
    implements Movement {
        protected final VehicleSpec spec;
        protected Point2D position;
        protected double heading;
        protected double velocity;

        public NonAccelMovement(VehicleSpec spec, Point2D position, double heading, double velocity) {
            this.spec = spec;
            this.position = position;
            this.heading = heading;
            this.velocity = velocity;
        }

        public final VehicleSpec getVehicleSpec() {
            return this.spec;
        }

        @Override
        public Point2D getPosition() {
            return this.position;
        }

        @Override
        public double getHeading() {
            return this.heading;
        }

        @Override
        public double getVelocity() {
            return this.velocity;
        }

        protected void setVelocityWithBound(double velocity) {
            this.velocity = Util.constrain(velocity, this.spec.getMinVelocity(), this.spec.getMaxVelocity());
        }

        public String toString() {
            return "Pos=(" + Constants.ONE_DEC.format(this.position.getX()) + "," + Constants.ONE_DEC.format(this.position.getY()) + "),Heading=" + Constants.TWO_DEC.format(this.heading) + ",Velocity=" + Constants.TWO_DEC.format(this.velocity);
        }
    }

    public static interface MovementFactory {
        public Movement make(Point2D var1, double var2, double var4);
    }

    public static interface Movement {
        public Point2D getPosition();

        public double getHeading();

        public double getVelocity();

        public void move(double var1, double var3);
    }
}

