/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import aim4.driver.ProxyDriver;
import aim4.im.IntersectionManager;
import aim4.map.lane.Lane;
import aim4.msg.i2v.Confirm;
import aim4.msg.i2v.I2VMessage;
import aim4.msg.i2v.Reject;
import aim4.msg.udp.Proxy2RealAdapter;
import aim4.msg.udp.Real2ProxyCancel;
import aim4.msg.udp.Real2ProxyMsg;
import aim4.msg.udp.Real2ProxyPVUpdate;
import aim4.msg.udp.Real2ProxyRequest;
import aim4.msg.v2i.Cancel;
import aim4.msg.v2i.Done;
import aim4.msg.v2i.Request;
import aim4.msg.v2i.V2IMessage;
import aim4.vehicle.BasicAutoVehicle;
import aim4.vehicle.BasicVehicle;
import aim4.vehicle.ProxyVehicleSimView;
import aim4.vehicle.VehicleSpecDatabase;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.LinkedList;

public class ProxyVehicle
extends BasicAutoVehicle
implements ProxyVehicleSimView {
    private static final double DEFAULT_ARRIVAL_TIME_DELAY = 0.04;
    private static final boolean IS_SEND_INTERVALOMETER_READING = false;
    private static final double SEND_INTERVALOMETER_READING_PERIOD = 1.0;
    ProxyDriver driver = null;
    SocketAddress sa = null;
    private double lastTimeStamp = Double.MIN_VALUE;
    private int nextRequestId = 0;
    private Real2ProxyPVUpdate pvUpdate = null;
    private double nextIntervalometerReadingTime;
    private double lastUpdateTime = -1.0;

    public ProxyVehicle(Point2D pos, double heading, double steeringAngle, double velocity, double targetVelocity, double acceleration, double currentTime) {
        super(VehicleSpecDatabase.getVehicleSpecByName("MARVIN"), pos, heading, steeringAngle, velocity, targetVelocity, acceleration, currentTime);
        this.nextIntervalometerReadingTime = currentTime;
    }

    @Override
    public ProxyDriver getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(ProxyDriver driver) {
        this.driver = driver;
    }

    @Override
    public SocketAddress getSa() {
        return this.sa;
    }

    @Override
    public void setSa(SocketAddress sa) {
        this.sa = sa;
    }

    @Override
    public void processReal2ProxyMsg(Real2ProxyMsg msg) {
        if (this.lastTimeStamp <= msg.receivedTime) {
            IntersectionManager currentIM = this.getDriver().getCurrentLane().getLaneIM().nextIntersectionManager(this.gaugePosition());
            V2IMessage v2iMsg = null;
            switch (msg.messageType) {
                case PV_UPDATE: {
                    this.pvUpdate = (Real2ProxyPVUpdate)msg;
                    break;
                }
                case REQUEST: {
                    v2iMsg = this.convertReal2ProxyRequestToRequest((Real2ProxyRequest)msg);
                    break;
                }
                case CANCEL: {
                    v2iMsg = new Cancel(this.getVIN(), currentIM.getId(), ((Real2ProxyCancel)msg).reservationId);
                    break;
                }
                case DONE: {
                    v2iMsg = new Done(this.getVIN(), currentIM.getId(), 0);
                    break;
                }
                default: {
                    assert (false) : "Unknown message Real2ProxyMsg type";
                    break;
                }
            }
            if (v2iMsg != null) {
                System.err.printf("Proxy vehicle is sending a V2I message to IM: %s\n.", v2iMsg);
                super.send(v2iMsg);
            }
            this.lastTimeStamp = msg.receivedTime;
        } else {
            System.err.printf("The incoming Real2Proxy messages are out of order.\n", new Object[0]);
            System.err.printf("lastTimeStamp = %.2f\n", this.lastTimeStamp);
            System.err.printf("msg.receivedTime = %.2f\n", msg.receivedTime);
        }
    }

    @Override
    public void receive(I2VMessage msg) {
        this.bitsReceived += msg.getSize();
        DatagramPacket dp = null;
        switch (msg.getMessageType()) {
            case CONFIRM: {
                try {
                    dp = Proxy2RealAdapter.toDatagramPacket((Confirm)msg, this.sa, this.gaugeTime());
                }
                catch (IOException e) {
                    System.err.println("Failed to convert confirm message to a datagram");
                    e.printStackTrace();
                }
                System.err.printf("Sending a confirm message to real vehicle: %s\n", (Confirm)msg);
                break;
            }
            case REJECT: {
                try {
                    dp = Proxy2RealAdapter.toDatagramPacket((Reject)msg, this.sa, this.gaugeTime());
                }
                catch (IOException e) {
                    System.err.println("Failed to convert reject message to a datagram");
                    e.printStackTrace();
                }
                System.err.printf("Sending a reject message to real vehicle: %s\n", (Reject)msg);
                break;
            }
            default: {
                assert (false) : "Cannot create the UdpAdaptor for a I2VMessage because the adaptor message has not been implemented yet";
                break;
            }
        }
        try {
            DatagramSocket ds = new DatagramSocket();
            ds.send(dp);
            ds.close();
        }
        catch (IOException e) {
            System.err.println("Failed to send a datagram to a real vehicle.");
            e.printStackTrace();
        }
    }

    @Override
    public void move(double timeStep) {
        if (this.pvUpdate == null) {
            super.move(timeStep);
        } else {
            if (this.lastUpdateTime >= 0.0) {
                double actualVelocity;
                double timeDiff = this.currentTime - this.lastUpdateTime;
                double xDiff = this.pvUpdate.position.getX() - this.movement.getPosition().getX();
                double yDiff = this.pvUpdate.position.getY() - this.movement.getPosition().getY();
                double dist = Math.sqrt(xDiff * xDiff + yDiff * yDiff);
                this.pvUpdate.velocity = actualVelocity = dist / timeDiff;
            }
            this.lastUpdateTime = this.currentTime;
            this.updateState(this.pvUpdate);
            this.pvUpdate = null;
            this.currentTime += timeStep;
        }
    }

    private void updateState(Real2ProxyPVUpdate up) {
        this.movement = new BasicVehicle.MoveToTargetVelocityMovement(this.spec, up.position, up.heading, up.velocity, up.steeringAngle, up.acceleration, up.targetVelocity);
    }

    private Request convertReal2ProxyRequestToRequest(Real2ProxyRequest msg) {
        assert (msg.vin == this.vin);
        IntersectionManager currentIM = this.getDriver().getCurrentLane().getLaneIM().nextIntersectionManager(this.gaugePosition());
        Lane arrivalLane = this.getDriver().getCurrentLane();
        double maxTurnVelocity = 7.5;
        LinkedList<Request.Proposal> proposals = new LinkedList<Request.Proposal>();
        proposals.add(new Request.Proposal(arrivalLane.getId(), msg.departureLaneId, msg.receivedTime + (double)msg.arrivalTimeSpan + 0.04, this.movement.getVelocity(), maxTurnVelocity));
        System.err.printf("msg.arrivalVelocity = %.5f\n", Float.valueOf(msg.arrivalVelocity));
        System.err.printf("this.velocity       = %.5f\n\n", this.movement.getVelocity());
        Request request = new Request(this.vin, currentIM.getId(), this.nextRequestId, new Request.VehicleSpecForRequestMsg(this.spec), proposals);
        ++this.nextRequestId;
        return request;
    }
}

