/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import aim4.map.Road;
import aim4.map.SpawnPoint;
import aim4.vehicle.VehicleSimView;
import aim4.vehicle.VehicleSpec;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class VinRegistry {
    private static int vinGenerator = 1000;
    private static Map<Integer, WeakReference<VehicleSimView>> vinToVehicle = new HashMap<Integer, WeakReference<VehicleSimView>>();
    private static Map<Integer, VehicleSpec> vinToVehicleSpec = new HashMap<Integer, VehicleSpec>();
    private static Map<Integer, SpawnPoint> vinToSpawnPoint = new HashMap<Integer, SpawnPoint>();
    private static Map<Integer, Road> vinToDestRoad = new HashMap<Integer, Road>();

    public static void reset() {
        vinGenerator = 1000;
        vinToVehicle = new HashMap<Integer, WeakReference<VehicleSimView>>();
        vinToVehicleSpec = new HashMap<Integer, VehicleSpec>();
        vinToSpawnPoint = new HashMap<Integer, SpawnPoint>();
        vinToDestRoad = new HashMap<Integer, Road>();
    }

    public static int registerVehicle(VehicleSimView vehicle) {
        assert (vinToVehicle.get(vinGenerator) == null);
        int vin = vinGenerator++;
        vinToVehicle.put(vin, new WeakReference<VehicleSimView>(vehicle));
        vinToVehicleSpec.put(vin, vehicle.getSpec());
        vinToSpawnPoint.put(vin, vehicle.getDriver().getSpawnPoint());
        vinToDestRoad.put(vin, vehicle.getDriver().getDestination());
        vehicle.setVIN(vin);
        return vin;
    }

    public static boolean registerVehicleWithExistingVIN(VehicleSimView vehicle, int vin) {
        assert (vin >= 0);
        if (vinToVehicle.containsKey(vin)) {
            return false;
        }
        assert (vehicle.getVIN() < 0);
        vinToVehicle.put(vin, new WeakReference<VehicleSimView>(vehicle));
        vinToVehicleSpec.put(vin, vehicle.getSpec());
        if (vehicle.getDriver() != null) {
            vinToSpawnPoint.put(vin, vehicle.getDriver().getSpawnPoint());
            vinToDestRoad.put(vin, vehicle.getDriver().getDestination());
        } else {
            vinToSpawnPoint.put(vin, null);
            vinToDestRoad.put(vin, null);
        }
        vehicle.setVIN(vin);
        if (vin >= vinGenerator) {
            vinGenerator = vin + 1;
        }
        return true;
    }

    public static void unregisterVehicle(int vin) {
        if (!vinToVehicle.containsKey(vin)) {
            throw new RuntimeException("VehicleRegistry:unregisterVehicle: Cannot unregister a vehicle twice");
        }
        vinToVehicle.remove(vin);
    }

    public static boolean isVINexist(int vin) {
        return vinToVehicleSpec.containsKey(vin);
    }

    public static VehicleSimView getVehicleFromVIN(int vin) {
        WeakReference<VehicleSimView> wr = vinToVehicle.get(vin);
        if (wr == null) {
            return null;
        }
        VehicleSimView v = (VehicleSimView)wr.get();
        if (v == null) {
            vinToVehicle.remove(vin);
        }
        return v;
    }

    public static VehicleSpec getVehicleSpecFromVIN(int vin) {
        return vinToVehicleSpec.get(vin);
    }

    public static SpawnPoint getSpawnPointFromVIN(int vin) {
        return vinToSpawnPoint.get(vin);
    }

    public static Road getDestRoadFromVIN(int vin) {
        return vinToDestRoad.get(vin);
    }

    private VinRegistry() {
    }
}

