/*
 * Decompiled with CFR 0.152.
 */
package aim4.config;

import aim4.config.Constants;
import aim4.config.TrafficSignal;
import aim4.im.v2i.RequestHandler.ApproxNPhasesTrafficSignalRequestHandler;
import aim4.map.GridMap;
import aim4.map.Road;
import aim4.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TrafficSignalPhase {
    private int phaseNum;
    private List<List<Road>> activeRoads;
    private List<Double> greenDurations;
    private List<Double> yellowDurations;
    private List<Double> redDurations;

    public TrafficSignalPhase(GridMap map, List<String> strs) {
        this.phaseNum = strs.size() - 1;
        this.activeRoads = new LinkedList<List<Road>>();
        this.greenDurations = new LinkedList<Double>();
        this.yellowDurations = new LinkedList<Double>();
        this.redDurations = new LinkedList<Double>();
        for (int i = 1; i < strs.size(); ++i) {
            String[] tokens = strs.get(i).split(",");
            ArrayList<Road> roads = new ArrayList<Road>();
            if (tokens[0].contains("N")) {
                for (Road road : map.getRoads()) {
                    if (!road.getName().equals("1st Avenue N")) continue;
                    roads.add(road);
                }
            }
            if (tokens[0].contains("S")) {
                for (Road road : map.getRoads()) {
                    if (!road.getName().equals("1st Avenue S")) continue;
                    roads.add(road);
                }
            }
            if (tokens[0].contains("E")) {
                for (Road road : map.getRoads()) {
                    if (!road.getName().equals("1st Street E")) continue;
                    roads.add(road);
                }
            }
            if (tokens[0].contains("W")) {
                for (Road road : map.getRoads()) {
                    if (!road.getName().equals("1st Street W")) continue;
                    roads.add(road);
                }
            }
            this.activeRoads.add(roads);
            this.greenDurations.add(Double.parseDouble(tokens[1]));
            this.yellowDurations.add(Double.parseDouble(tokens[2]));
            this.redDurations.add(Double.parseDouble(tokens[3]));
        }
    }

    public static TrafficSignalPhase makeFromFile(GridMap map, String csvFileName) {
        List<String> strs = null;
        try {
            strs = Util.readFileToStrArray(csvFileName);
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
        if (strs != null) {
            return new TrafficSignalPhase(map, strs);
        }
        return null;
    }

    public int getPhaseNum() {
        return this.phaseNum;
    }

    public List<Road> getActiveRoads(int phaseId) {
        return this.activeRoads.get(phaseId);
    }

    public double getGreenDurations(int phaseId) {
        return this.greenDurations.get(phaseId);
    }

    public double getYellowDurations(int phaseId) {
        return this.yellowDurations.get(phaseId);
    }

    public double getRedDurations(int phaseId) {
        return this.redDurations.get(phaseId);
    }

    public ApproxNPhasesTrafficSignalRequestHandler.CyclicSignalController calcCyclicSignalController(Road road) {
        double[] durations = new double[this.phaseNum * 3];
        TrafficSignal[] signals = new TrafficSignal[this.phaseNum * 3];
        int j = 0;
        for (int i = 0; i < this.phaseNum; ++i) {
            boolean isActive = false;
            for (Road r : this.activeRoads.get(i)) {
                if (!r.getName().equals(road.getName())) continue;
                isActive = true;
                break;
            }
            if (isActive) {
                durations[j] = this.greenDurations.get(i);
                signals[j] = TrafficSignal.GREEN;
                durations[++j] = this.yellowDurations.get(i);
                signals[j] = TrafficSignal.YELLOW;
                durations[++j] = this.redDurations.get(i);
                signals[j] = TrafficSignal.RED;
                ++j;
                continue;
            }
            int n = j;
            durations[n] = durations[n] + (this.greenDurations.get(i) + this.yellowDurations.get(i) + this.redDurations.get(i));
            signals[j] = TrafficSignal.RED;
            ++j;
        }
        return new ApproxNPhasesTrafficSignalRequestHandler.CyclicSignalController(durations, signals);
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.phaseNum; ++i) {
            s = s + "Phase " + i + ":";
            for (Road r : this.activeRoads.get(i)) {
                s = s + " \"" + r.getName() + "\"";
            }
            s = s + " g=" + Constants.TWO_DEC.format(this.greenDurations.get(i)) + ", ";
            s = s + "y=" + Constants.TWO_DEC.format(this.yellowDurations.get(i)) + ", ";
            s = s + "r=" + Constants.TWO_DEC.format(this.redDurations.get(i)) + "\n";
        }
        return s;
    }
}

