/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver;

import aim4.driver.AutoDriverCoordinatorView;
import aim4.driver.AutoDriverPilotView;
import aim4.driver.Driver;
import aim4.driver.coordinator.Coordinator;
import aim4.driver.coordinator.NoIntersectionCoordinator;
import aim4.driver.coordinator.V2ICoordinator;
import aim4.im.IntersectionManager;
import aim4.map.BasicMap;
import aim4.vehicle.AutoVehicleDriverView;
import java.awt.geom.Area;

public class AutoDriver
extends Driver
implements AutoDriverCoordinatorView,
AutoDriverPilotView {
    private AutoVehicleDriverView vehicle;
    private Coordinator coordinator;
    private BasicMap basicMap;
    private IntersectionManager currentIM;
    private transient Double memoDistanceToNextIntersection;
    private transient Double memoDistanceFromPrevIntersection;
    private transient IntersectionManager memoNextIntersectionManager;
    private transient Boolean memoInCurrentIntersection;

    public AutoDriver(AutoVehicleDriverView vehicle, BasicMap basicMap) {
        this.vehicle = vehicle;
        this.basicMap = basicMap;
        this.coordinator = null;
        this.currentIM = null;
    }

    @Override
    public void act() {
        super.act();
        this.clearMemoizationCaches();
        if (this.coordinator == null || this.coordinator.isTerminated()) {
            IntersectionManager im = this.nextIntersectionManager();
            if (im != null) {
                this.currentIM = im;
                this.coordinator = new V2ICoordinator(this.vehicle, this, this.basicMap);
            } else {
                this.currentIM = null;
                this.coordinator = new NoIntersectionCoordinator(this.vehicle, this);
            }
        }
        if (!this.coordinator.isTerminated()) {
            this.coordinator.act();
        }
    }

    @Override
    public AutoVehicleDriverView getVehicle() {
        return this.vehicle;
    }

    public Coordinator getCurrentCoordinator() {
        return this.coordinator;
    }

    @Override
    public IntersectionManager getCurrentIM() {
        return this.currentIM;
    }

    @Override
    public IntersectionManager nextIntersectionManager() {
        if (this.memoNextIntersectionManager == null) {
            this.memoNextIntersectionManager = super.nextIntersectionManager();
        }
        return this.memoNextIntersectionManager;
    }

    @Override
    public double distanceToNextIntersection() {
        if (this.memoDistanceToNextIntersection == null) {
            this.memoDistanceToNextIntersection = super.distanceToNextIntersection();
        }
        return this.memoDistanceToNextIntersection;
    }

    @Override
    public double distanceFromPrevIntersection() {
        if (this.memoDistanceFromPrevIntersection == null) {
            this.memoDistanceFromPrevIntersection = super.distanceFromPrevIntersection();
        }
        return this.memoDistanceFromPrevIntersection;
    }

    @Override
    public boolean inCurrentIntersection() {
        if (this.memoInCurrentIntersection == null) {
            this.memoInCurrentIntersection = AutoDriver.intersects(this.getVehicle(), this.currentIM.getIntersection().getAreaPlus());
        }
        return this.memoInCurrentIntersection;
    }

    private static boolean intersects(AutoVehicleDriverView v, Area area) {
        if (area.contains(v.gaugePosition()) || area.contains(v.gaugePointAtRear())) {
            return true;
        }
        Area vehicleArea = new Area(v.gaugeShape());
        vehicleArea.intersect(area);
        return !vehicleArea.isEmpty();
    }

    private void clearMemoizationCaches() {
        this.memoNextIntersectionManager = null;
        this.memoInCurrentIntersection = null;
        this.memoDistanceToNextIntersection = null;
        this.memoDistanceFromPrevIntersection = null;
    }
}

