/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver;

import aim4.config.Debug;
import aim4.driver.Driver;
import aim4.map.lane.Lane;
import aim4.vehicle.AutoVehicleDriverView;
import java.awt.geom.Point2D;

public class CrashTestDummy
extends Driver {
    private AutoVehicleDriverView vehicle;
    private Lane departureLane;

    public CrashTestDummy(AutoVehicleDriverView vehicle, Lane arrivalLane, Lane departureLane) {
        this.vehicle = vehicle;
        this.setCurrentLane(arrivalLane);
        this.departureLane = departureLane;
    }

    @Override
    public void act() {
        super.act();
        if (this.getCurrentLane() != this.departureLane) {
            if (Debug.currentMap.getRoad(this.getCurrentLane()) != Debug.currentMap.getRoad(this.departureLane)) {
                if (this.departureLane.nearestDistance(this.getVehicle().gaugePosition()) < this.calculateTraversingLaneChangeDistance()) {
                    this.setCurrentLane(this.departureLane);
                }
            } else {
                this.setCurrentLane(this.departureLane);
            }
        }
        this.followCurrentLane();
    }

    @Override
    public AutoVehicleDriverView getVehicle() {
        return this.vehicle;
    }

    private void followCurrentLane() {
        this.followCurrentLane(0.4);
    }

    private void followCurrentLane(double leadTime) {
        Point2D aimPoint;
        double remaining;
        double leadDist = leadTime * this.vehicle.gaugeVelocity() + 0.2;
        if (leadDist > (remaining = this.getCurrentLane().remainingDistanceAlongLane(this.vehicle.gaugePosition())) && this.getCurrentLane().hasNextLane()) {
            if (remaining <= 0.0) {
                this.setCurrentLane(this.getCurrentLane().getNextLane());
                this.followCurrentLane(leadTime);
                return;
            }
            aimPoint = this.getCurrentLane().getNextLane().getLeadPoint(this.getCurrentLane().getNextLane().getStartPoint(), leadDist - remaining);
        } else {
            aimPoint = this.getCurrentLane().getLeadPoint(this.vehicle.gaugePosition(), leadDist);
        }
        this.turnTowardPoint(aimPoint);
    }

    private void turnTowardPoint(Point2D p) {
        this.vehicle.turnTowardPoint(p);
    }

    public double calculateTraversingLaneChangeDistance() {
        return 1.5 * this.vehicle.gaugeVelocity();
    }
}

