/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver.coordinator;

import aim4.driver.coordinator.ReservationCheckException;
import aim4.util.Util;
import aim4.vehicle.AccelSchedule;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;

public class MaxAccelReservationCheck {
    private static final boolean isDebugging = true;

    public static AccelSchedule check(double time1, double v1, double timeEnd, double vEnd, double dTotal, double vTop, double accel, double decel) throws ReservationCheckException {
        AccelSchedule as = MaxAccelReservationCheck.check0(time1, v1, timeEnd, vEnd, dTotal, vTop, accel, decel);
        assert (MaxAccelReservationCheck.isAccelScheduleValid(time1, v1, timeEnd, vEnd, dTotal, vTop, as));
        return as;
    }

    private static AccelSchedule check0(double time1, double v1, double timeEnd, double vEnd, double dTotal, double vTop, double accel, double decel) throws ReservationCheckException {
        assert (time1 <= timeEnd);
        assert (0.0 <= v1);
        assert (Util.isDoubleEqualOrLess(v1, vTop));
        assert (0.0 <= vEnd);
        assert (vEnd <= vTop);
        assert (0.0 <= dTotal);
        assert (0.0 < accel);
        assert (decel < 0.0);
        if (time1 < timeEnd) {
            double tTotal = timeEnd - time1;
            double t14 = (vEnd - accel * tTotal - v1) / (decel - accel);
            double t15 = tTotal - t14;
            double vDown = v1 + decel * t14;
            double t24 = (vEnd - decel * tTotal - v1) / (accel - decel);
            double t25 = tTotal - t24;
            double vUp = v1 + accel * t24;
            if (Util.isDoubleZero(t14)) {
                assert (Util.isDoubleEqual(v1, vDown));
                assert (Util.isDoubleEqual(vEnd, vUp));
                assert (Util.isDoubleZero(t14) && Util.isDoubleZero(t25));
                double areaR = tTotal * (v1 + vEnd) / 2.0;
                if (Util.isDoubleEqual(dTotal, areaR, 1.0E-6)) {
                    AccelSchedule as = new AccelSchedule();
                    as.add(time1, accel);
                    as.add(time1 + tTotal, 0.0);
                    return as;
                }
                throw new ReservationCheckException("Reservation check failed: can't accelerate linearly to meet the arrival time and the arrival velocity (Case 1)");
            }
            if (t14 > 0.0) {
                if (Util.isDoubleZero(t24)) {
                    double areaL = tTotal * (v1 + vEnd) / 2.0;
                    if (Util.isDoubleEqual(dTotal, areaL)) {
                        AccelSchedule as = new AccelSchedule();
                        as.add(time1, decel);
                        as.add(time1 + tTotal, 0.0);
                        return as;
                    }
                    throw new ReservationCheckException("Reservation check failed: can't decelerate linearly to meet the arrival time and the arrival velocity (Case 2)");
                }
                if (t24 > 0.0) {
                    double t3x;
                    ArrayList<TrapezoidSpec> tzs = new ArrayList<TrapezoidSpec>(3);
                    double area0 = dTotal;
                    double t11 = -v1 / decel;
                    double t13 = vEnd / accel;
                    double t12 = tTotal - t11 - t13;
                    double t21 = (vTop - v1) / accel;
                    double t23 = (vEnd - vTop) / decel;
                    double t22 = tTotal - t21 - t23;
                    if (v1 > vEnd) {
                        t3x = (vEnd - v1) / decel;
                        double t3 = tTotal - t3x;
                        if (0.0 <= vDown) {
                            double areaL = t14 * (v1 + vDown) / 2.0;
                            double areaR = t15 * (vDown + vEnd) / 2.0;
                            if (Util.isDoubleZero(area0 -= areaL + areaR)) {
                                area0 = 0.0;
                            }
                            if (area0 < 0.0) {
                                throw new ReservationCheckException("Reservation check failed: distance too small (Case 5a)");
                            }
                            tzs.add(new TrapezoidSpec(time1 + t14, vDown, vEnd - vDown, 0.0, t3, t14 - t3x));
                        } else if (0.0 < v1) {
                            double areaL = t11 * v1 / 2.0;
                            double areaR = t13 * vEnd / 2.0;
                            if (Util.isDoubleZero(area0 -= areaL + areaR)) {
                                area0 = 0.0;
                            }
                            if (area0 < 0.0) {
                                throw new ReservationCheckException("Reservation check failed: distance too small (Case 5b)");
                            }
                            assert (t12 > 0.0);
                            tzs.add(new TrapezoidSpec(time1 + t11, 0.0, vEnd, t12, t3, t11 - t3x));
                        } else {
                            double areaL = t11 * v1 / 2.0;
                            if (Util.isDoubleZero(area0 -= areaL)) {
                                area0 = 0.0;
                            }
                            if (area0 < 0.0) {
                                throw new ReservationCheckException("Reservation check failed: distance too small (Case 5c)");
                            }
                        }
                        tzs.add(new TrapezoidSpec(time1 + t3x, vEnd, v1 - vEnd, t3, t3, t3x));
                        if (vUp <= vTop) {
                            tzs.add(new TrapezoidSpec(time1, v1, vUp - v1, t3, 0.0, -t24));
                        } else if (vEnd < vTop) {
                            assert (t22 > 0.0);
                            tzs.add(new TrapezoidSpec(time1, v1, vTop - v1, t3, t22, -t21));
                        }
                    } else if (v1 < vEnd) {
                        t3x = (vEnd - v1) / accel;
                        double t3 = tTotal - t3x;
                        if (0.0 <= vDown) {
                            double areaL = t14 * (v1 + vDown) / 2.0;
                            double areaR = t15 * (vDown + vEnd) / 2.0;
                            if (Util.isDoubleZero(area0 -= areaL + areaR)) {
                                area0 = 0.0;
                            }
                            if (area0 < 0.0) {
                                throw new ReservationCheckException("Reservation check failed: distance too small (Case 4a)");
                            }
                            tzs.add(new TrapezoidSpec(time1 + t14, vDown, v1 - vDown, 0.0, t3, t14));
                        } else if (0.0 < v1) {
                            double areaL = t11 * v1 / 2.0;
                            double areaR = t13 * vEnd / 2.0;
                            if (Util.isDoubleZero(area0 -= areaL + areaR)) {
                                area0 = 0.0;
                            }
                            if (area0 < 0.0) {
                                throw new ReservationCheckException("Reservation check failed: distance too small (Case 4b)");
                            }
                            assert (t12 > 0.0);
                            tzs.add(new TrapezoidSpec(time1 + t11, 0.0, v1, t12, t3, t11));
                        } else {
                            double areaR = t13 * vEnd / 2.0;
                            if (Util.isDoubleZero(area0 -= areaR)) {
                                area0 = 0.0;
                            }
                            if (area0 < 0.0) {
                                throw new ReservationCheckException("Reservation check failed: distance too small (Case 4c)");
                            }
                        }
                        tzs.add(new TrapezoidSpec(time1, v1, vEnd - v1, t3, t3, -t3x));
                        if (vUp <= vTop) {
                            tzs.add(new TrapezoidSpec(time1 + t3x, vEnd, vUp - vEnd, t3, 0.0, t3x - t24));
                        } else if (vEnd < vTop) {
                            assert (t22 > 0.0);
                            tzs.add(new TrapezoidSpec(time1 + t3x, vEnd, vTop - vEnd, t3, t22, t3x - t21));
                        }
                    } else {
                        double areaL;
                        if (0.0 <= vDown) {
                            areaL = t14 * (v1 + vDown) / 2.0;
                            double areaR = t15 * (vDown + vEnd) / 2.0;
                            if (Util.isDoubleZero(area0 -= areaL + areaR)) {
                                area0 = 0.0;
                            }
                            if (area0 < 0.0) {
                                throw new ReservationCheckException("Reservation check failed: distance too small (Case 3a)");
                            }
                            tzs.add(new TrapezoidSpec(time1 + t14, vDown, v1 - vDown, 0.0, tTotal, t14));
                        } else if (0.0 < v1) {
                            areaL = t11 * v1 / 2.0;
                            double areaR = t13 * vEnd / 2.0;
                            if (Util.isDoubleZero(area0 -= areaL + areaR)) {
                                area0 = 0.0;
                            }
                            if (area0 < 0.0) {
                                throw new ReservationCheckException("Reservation check failed: distance too small (Case 3b)");
                            }
                            assert (t12 > 0.0);
                            tzs.add(new TrapezoidSpec(time1 + t11, 0.0, v1, t12, tTotal, t11));
                        }
                        if (vUp <= vTop) {
                            tzs.add(new TrapezoidSpec(time1, v1, vUp - v1, tTotal, 0.0, -t24));
                        } else if (vEnd < vTop) {
                            assert (t22 > 0.0);
                            tzs.add(new TrapezoidSpec(time1, v1, vTop - v1, tTotal, t22, -t21));
                        }
                    }
                    Line2D.Double line = MaxAccelReservationCheck.findPartialTrapezoid(tzs, area0);
                    if (line != null) {
                        AccelSchedule as = MaxAccelReservationCheck.makeAccelSchedule(time1, v1, timeEnd, vEnd, accel, decel, line);
                        return as;
                    }
                    throw new ReservationCheckException("Reservation check failed: distance too large (Case 3,4,5)");
                }
                throw new ReservationCheckException("Reservation check failed: can't decelerate to final velocity Case 7)");
            }
            throw new ReservationCheckException("Reservation check failed: can't accelerate to final velocity Case 6)");
        }
        assert (Util.isDoubleEqual(time1, timeEnd));
        if (dTotal > 0.0) {
            throw new ReservationCheckException("Reservation check failed: distance is not zero when there is no time to move");
        }
        assert (Util.isDoubleZero(dTotal));
        if (Util.isDoubleEqual(v1, vEnd)) {
            AccelSchedule as = new AccelSchedule();
            as.add(time1, 0.0);
            return as;
        }
        throw new ReservationCheckException("Reservation check failed: distance is not zero when there is no time to change velocity");
    }

    private static Line2D.Double calcPartialTrapezoid(TrapezoidSpec spec, double area0) {
        double refX = spec.getRefX();
        double refY = spec.getRefY();
        double h = spec.getH();
        double w1 = spec.getW1();
        double w2 = spec.getW2();
        double x = spec.getX();
        double area = spec.getArea();
        assert (0.0 < h);
        assert (0.0 <= w1 && 0.0 < w2 || 0.0 < w1 && 0.0 <= w2);
        assert (Util.isDoubleEqual(area, h * (w1 + w2) / 2.0));
        if (Util.isDoubleZero(area0)) {
            double w0 = w1;
            double h0 = 0.0;
            double x0 = 0.0;
            double p1x = refX - x0;
            double p1y = refY + h0;
            return new Line2D.Double(p1x, p1y, p1x + w0, p1y);
        }
        if (Util.isDoubleEqual(area0, area)) {
            double w0 = w2;
            double h0 = h;
            double x0 = x;
            double p1x = refX - x0;
            double p1y = refY + h0;
            return new Line2D.Double(p1x, p1y, p1x + w0, p1y);
        }
        if (0.0 <= area0 && area0 <= area) {
            if (Util.isDoubleEqual(w1, w2)) {
                double h0 = area0 / w1;
                double w0 = w1;
                double x0 = h0 * x / h;
                double p1x = refX - x0;
                double p1y = refY + h0;
                return new Line2D.Double(p1x, p1y, p1x + w0, p1y);
            }
            double h0 = (Math.sqrt(w1 * w1 * h * h + (w2 - w1) * (2.0 * area0 * h)) - w1 * h) / (w2 - w1);
            double w0 = (w2 - w1) * h0 / h + w1;
            double x0 = h0 * x / h;
            double p1x = refX - x0;
            double p1y = refY + h0;
            return new Line2D.Double(p1x, p1y, p1x + w0, p1y);
        }
        throw new RuntimeException("Error in LevelOffReservationCheck::calcPartialTrapezoid");
    }

    private static Line2D.Double findPartialTrapezoid(List<TrapezoidSpec> trapezoids, double area0) {
        for (TrapezoidSpec spec : trapezoids) {
            if (Util.isDoubleEqual(area0, spec.getArea()) || area0 < spec.getArea()) {
                return MaxAccelReservationCheck.calcPartialTrapezoid(spec, area0);
            }
            area0 -= spec.getArea();
        }
        return null;
    }

    private static AccelSchedule makeAccelSchedule(double time1, double v1, double timeEnd, double vEnd, double accel, double decel, Line2D.Double line) {
        AccelSchedule as = new AccelSchedule();
        if (Util.isDoubleEqual(line.getX1(), time1)) {
            assert (Util.isDoubleEqual(line.getY1(), v1, 1.0E-6));
        } else if (line.getY1() < v1) {
            as.add(time1, decel);
        } else {
            assert (v1 < line.getY1());
            as.add(time1, accel);
        }
        if (Util.isDoubleNotEqual(line.getX1(), line.getX2())) {
            as.add(line.getX1(), 0.0);
        }
        if (Util.isDoubleEqual(line.getX2(), timeEnd)) {
            assert (Util.isDoubleEqual(line.getY2(), vEnd, 1.0E-6));
        } else if (line.getY2() < vEnd) {
            as.add(line.getX2(), accel);
        } else {
            assert (vEnd < line.getY2());
            as.add(line.getX2(), decel);
        }
        as.add(timeEnd, 0.0);
        return as;
    }

    private static boolean isPartialTrapezoidValid(double time1, double v1, double timeEnd, double vEnd, double dTotal, double vTop, double accel, double decel, Line2D.Double line) {
        double v2 = v1 + (v1 <= line.getY1() ? accel : decel) * (line.getX1() - time1);
        if (Util.isDoubleNotEqual(v2, line.getY1())) {
            System.err.printf("Error in isPartialTrapezoidValid(): line.getY1() is incorrect.\n", new Object[0]);
            return false;
        }
        double v3 = vEnd - (line.getY2() <= vEnd ? accel : decel) * (timeEnd - line.getX2());
        if (Util.isDoubleNotEqual(v3, line.getY2())) {
            System.err.printf("Error in isPartialTrapezoidValid(): line.getY2() is incorrect.\n", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean isAccelScheduleValid(double time1, double v1, double timeEnd, double vEnd, double dTotal, double vTop, AccelSchedule as) {
        assert (as != null);
        List<AccelSchedule.TimeAccel> list = as.getList();
        if (as.size() == 0 || as.size() > 4) {
            System.err.printf("Error in isAccelScheduleValid(): Invalid accel schedule size.\n", new Object[0]);
            return false;
        }
        double v = v1;
        double d = 0.0;
        AccelSchedule.TimeAccel ta1 = list.get(0);
        if (!Util.isDoubleEqual(ta1.getTime(), time1)) {
            System.err.printf("Error in isAccelScheduleValid(): Initial time is incorrect.\n", new Object[0]);
            return false;
        }
        for (int i = 1; i < as.size(); ++i) {
            AccelSchedule.TimeAccel ta2 = list.get(i);
            double t = ta2.getTime() - ta1.getTime();
            if (t <= 0.0) {
                System.err.printf("Error in isAccelScheduleValid(): Duration cannot be negative.\n", new Object[0]);
                return false;
            }
            double v2 = v + ta1.getAcceleration() * t;
            if (Util.isDoubleNotEqual(v2, vTop, 1.0E-6) && v2 > vTop) {
                System.err.printf("Error in isAccelScheduleValid(): Velocity is greater than vTop v2 = %.5f > %.5f\n", v2, vTop);
                return false;
            }
            d += t * (v + v2) / 2.0;
            v = v2;
            ta1 = ta2;
        }
        if (Util.isDoubleNotEqual(ta1.getTime(), timeEnd)) {
            System.err.printf("Error in isAccelScheduleValid(): The ending time is incorrect.\n", new Object[0]);
            return false;
        }
        if (Util.isDoubleNotEqual(v, vEnd, 1.0E-6)) {
            System.err.printf("v    = %.10f\n", v);
            System.err.printf("vEnd = %.10f\n", vEnd);
            System.err.printf("Error in isAccelScheduleValid(): The ending velocity is incorrect.\n", new Object[0]);
            return false;
        }
        if (Util.isDoubleNotEqual(d, dTotal, 1.0E-6)) {
            System.err.printf("Error in isAccelScheduleValid(): The total distance is incorrect (actual = %.15f, expected = %.15f)\n", d, dTotal);
            System.err.printf("as = %s\n", as);
            return false;
        }
        return true;
    }

    private static class TrapezoidSpec {
        private double refX;
        private double refY;
        private double h;
        private double w1;
        private double w2;
        private double x;
        private double area;

        public TrapezoidSpec(double refX, double refY, double h, double w1, double w2, double x) {
            this.refX = refX;
            this.refY = refY;
            this.h = h;
            this.w1 = w1;
            this.w2 = w2;
            this.x = x;
            this.area = h * (w1 + w2) / 2.0;
        }

        public double getRefX() {
            return this.refX;
        }

        public double getRefY() {
            return this.refY;
        }

        public double getH() {
            return this.h;
        }

        public double getW1() {
            return this.w1;
        }

        public double getW2() {
            return this.w2;
        }

        public double getX() {
            return this.x;
        }

        public double getArea() {
            return this.area;
        }

        public void print() {
            System.err.printf("TrapezoidSpec:\n", new Object[0]);
            System.err.printf("  w1 = %.10f\n", this.w1);
            System.err.printf("  w2 = %.10f\n", this.w2);
            System.err.printf("  h  = %.10f\n", this.h);
            System.err.printf("  x  = %.10f\n", this.x);
            System.err.printf("  area = %.10f\n", this.area);
            System.err.printf("  refX = %.10f\n", this.refX);
            System.err.printf("  refY = %.10f\n", this.refY);
        }
    }
}

