/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver.coordinator;

import aim4.config.Constants;
import aim4.config.Debug;
import aim4.config.SimConfig;
import aim4.driver.AutoDriver;
import aim4.driver.AutoDriverCoordinatorView;
import aim4.driver.DriverUtil;
import aim4.driver.coordinator.ArrivalEstimationException;
import aim4.driver.coordinator.ArrivalEstimationResult;
import aim4.driver.coordinator.Coordinator;
import aim4.driver.coordinator.MaxAccelReservationCheck;
import aim4.driver.coordinator.ReservationCheckException;
import aim4.driver.coordinator.VelocityFirstArrivalEstimation;
import aim4.driver.navigator.BasicNavigator;
import aim4.driver.navigator.Navigator;
import aim4.driver.pilot.V2IPilot;
import aim4.im.IntersectionManager;
import aim4.map.BasicMap;
import aim4.map.Road;
import aim4.map.lane.Lane;
import aim4.msg.i2v.Confirm;
import aim4.msg.i2v.I2VMessage;
import aim4.msg.i2v.Reject;
import aim4.msg.v2i.Away;
import aim4.msg.v2i.Cancel;
import aim4.msg.v2i.Done;
import aim4.msg.v2i.Request;
import aim4.util.Util;
import aim4.vehicle.AccelSchedule;
import aim4.vehicle.AutoVehicleDriverView;
import aim4.vehicle.VehicleUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Queue;

public class V2ICoordinator
implements Coordinator {
    private static final double MAX_CLOCK_ERROR = 0.5;
    private static final double MAXIMUM_FUTURE_RESERVATION_TIME = 9.5;
    private static final double ARRIVAL_VELOCITY_PRECISION = 3.0;
    private static final double MINIMUM_FUTURE_RESERVATION_TIME = 0.1;
    private static final int MAX_LANES_TO_TRY_PER_ROAD = 1;
    private static final double REQUEST_TIMEOUT = -1.0;
    private static final double SENDING_REQUEST_DELAY = 0.02;
    private static final double CONSIDERING_LANE_CHANGE_DELAY = 1.0;
    private static final double MAX_EXPECTED_IM_REPLY_TIME = 0.04;
    private static final double ARRIVAL_ESTIMATE_ACCEL_SLACK = 1.0;
    private static StateHandler terminalStateHandler = new StateHandler(){

        @Override
        public boolean perform() {
            return false;
        }
    };
    private AutoVehicleDriverView vehicle;
    private AutoDriverCoordinatorView driver;
    private Navigator navigator;
    private V2IPilot pilot;
    private LaneChangeController lcController;
    private State state;
    private double lastStateChangeTime = 0.0;
    private EnumMap<State, StateHandler> stateHandlers;
    private ReservationParameter rparameter;
    private int latestReservationNumber;
    private int nextRequestId;
    private double nextAllowedSendingRequestTime;
    private double nextAllowedConsideringLaneChangeTime;
    private boolean isDebugging;

    public V2ICoordinator(AutoVehicleDriverView vehicle, AutoDriver driver, BasicMap basicMap) {
        this.vehicle = vehicle;
        this.driver = driver;
        this.pilot = new V2IPilot(vehicle, driver);
        this.navigator = new BasicNavigator(vehicle.getSpec(), basicMap);
        this.isDebugging = Debug.isTargetVIN(vehicle.getVIN());
        this.lcController = new LaneChangeController(vehicle, driver, this.pilot, this.navigator);
        this.initStateHandlers();
        assert (driver.nextIntersectionManager() != null);
        this.rparameter = null;
        this.nextAllowedSendingRequestTime = vehicle.gaugeTime();
        this.nextAllowedConsideringLaneChangeTime = vehicle.gaugeTime();
        this.latestReservationNumber = -1;
        this.nextRequestId = 0;
        this.setState(State.V2I_PLANNING);
    }

    @Override
    public void act() {
        this.isDebugging = Debug.isTargetVIN(this.vehicle.getVIN());
        this.messageHandler();
        this.callStateHandlers();
    }

    private void messageHandler() {
        List<I2VMessage> msgs = this.vehicle.pollAllMessagesFromI2VInbox();
        for (I2VMessage msg : msgs) {
            this.processMessages(msg);
        }
    }

    private void callStateHandlers() {
        boolean shouldContinue = true;
        while (shouldContinue) {
            if (this.stateHandlers.containsKey((Object)this.state)) {
                shouldContinue = this.stateHandlers.get((Object)this.state).perform();
                continue;
            }
            throw new RuntimeException("Unknown state.");
        }
    }

    public State getState() {
        return this.state;
    }

    @Override
    public boolean isTerminated() {
        return this.state == State.V2I_TERMINAL_STATE;
    }

    public boolean isAwaitingResponse() {
        return this.state == State.V2I_AWAITING_RESPONSE;
    }

    public ReservationParameter getReservationParameter() {
        return this.rparameter;
    }

    public double timeToReservation() {
        if (this.rparameter != null) {
            return this.rparameter.getArrivalTime() - this.vehicle.gaugeTime();
        }
        return -1.0;
    }

    public boolean getIsDebugging() {
        return this.isDebugging;
    }

    private void processMessages(I2VMessage msg) {
        switch (msg.getMessageType()) {
            case CONFIRM: {
                this.processConfirmMessage((Confirm)msg);
                break;
            }
            case REJECT: {
                this.processRejectMessage((Reject)msg);
                break;
            }
            case ACZ_CONFIRM: {
                throw new RuntimeException("Not implemented yet: " + msg.getMessageType().toString());
            }
            case ACZ_REJECT: {
                throw new RuntimeException("Not implemented yet: " + msg.getMessageType().toString());
            }
        }
    }

    private void processConfirmMessage(Confirm msg) {
        switch (this.state) {
            case V2I_AWAITING_RESPONSE: {
                this.processConfirmMessageForAwaitingResponseState(msg);
                break;
            }
            default: {
                System.err.printf("vin %d receives a confirm message when it is not at the V2I_AWAITING_RESPONSE state\n", this.vehicle.getVIN());
            }
        }
    }

    private void processConfirmMessageForAwaitingResponseState(Confirm msg) {
        AccelSchedule as;
        block6: {
            this.latestReservationNumber = msg.getReservationId();
            this.setReservationParameter(msg);
            double time1 = this.vehicle.gaugeTime();
            double v1 = this.vehicle.gaugeVelocity();
            double timeEnd = this.rparameter.getArrivalTime();
            double vEnd = this.rparameter.getArrivalVelocity();
            double dTotal = this.driver.distanceToNextIntersection();
            double vTop = DriverUtil.calculateMaxFeasibleVelocity(this.vehicle);
            double accel = this.vehicle.getSpec().getMaxAcceleration();
            double decel = this.vehicle.getSpec().getMaxDeceleration();
            if (Debug.isPrintReservationAcceptanceCheck(this.vehicle.getVIN())) {
                System.err.printf("Parameters for reservation acceptance check:\n", new Object[0]);
                System.err.printf("time1   = %.5f\n", time1);
                System.err.printf("v1      = %.5f\n", v1);
                System.err.printf("timeEnd = %.5f\n", timeEnd);
                System.err.printf("vEnd    = %.5f\n", vEnd);
                System.err.printf("dTotal  = %.2f\n", dTotal);
                System.err.printf("vTop    = %.2f\n", vTop);
                System.err.printf("accel   = %.2f\n", accel);
                System.err.printf("decel   = %.2f\n", decel);
            }
            as = null;
            try {
                as = MaxAccelReservationCheck.check(time1, v1, timeEnd, vEnd, dTotal, vTop, accel, decel);
            }
            catch (ReservationCheckException e) {
                if (!this.isDebugging) break block6;
                System.err.printf("Cancel the reservation because vehicle can't accept the reservation.\n", new Object[0]);
                System.err.printf("Reason: %s\n", e.getMessage());
            }
        }
        if (as != null) {
            if (this.isDebugging) {
                System.err.printf("accelSchedule = %s\n", as);
            }
            this.vehicle.setAccelSchedule(as);
            this.setState(State.V2I_MAINTAINING_RESERVATION);
        } else {
            this.sendCancelMessage(this.latestReservationNumber);
            this.removeReservationParameter();
            this.vehicle.removeAccelSchedule();
            this.setState(State.V2I_PLANNING);
        }
    }

    private void processRejectMessage(Reject msg) {
        switch (this.state) {
            case V2I_AWAITING_RESPONSE: {
                this.processRejectMessageForAwaitingResponseState(msg);
                break;
            }
            default: {
                System.err.printf("vin %d receives a reject message when it is not at the V2I_AWAITING_RESPONSE state\n", this.vehicle.getVIN());
            }
        }
    }

    private void processRejectMessageForAwaitingResponseState(Reject msg) {
        switch (msg.getReason()) {
            case NO_CLEAR_PATH: {
                this.goBackToPlanningStateUponRejection(msg);
                break;
            }
            case CONFIRMED_ANOTHER_REQUEST: {
                this.goBackToPlanningStateUponRejection(msg);
                break;
            }
            case BEFORE_NEXT_ALLOWED_COMM: {
                throw new RuntimeException("V2ICoordinator: Cannot send reqest message before the next allowed communication time");
            }
            case ARRIVAL_TIME_TOO_LARGE: {
                System.err.printf("vin %d\n", this.vehicle.getVIN());
                throw new RuntimeException("V2ICoordinator: cannot make reqest whose arrival time is too far in the future");
            }
            case ARRIVAL_TIME_TOO_LATE: {
                throw new RuntimeException("V2ICoordinator: Arrival time of request has already passed.");
            }
            default: {
                System.err.printf("%s\n", new Object[]{msg.getReason()});
                throw new RuntimeException("V2ICoordinator: Unknown reason for rejection.");
            }
        }
    }

    private void goBackToPlanningStateUponRejection(Reject msg) {
        this.nextAllowedSendingRequestTime = Math.max(msg.getNextAllowedCommunication(), this.vehicle.gaugeTime() + 0.02);
        this.vehicle.removeAccelSchedule();
        this.setState(State.V2I_PLANNING);
    }

    private void initStateHandlers() {
        this.stateHandlers = new EnumMap(State.class);
        this.stateHandlers.put(State.V2I_PLANNING, new V2IPlanningStateHandler());
        this.stateHandlers.put(State.V2I_LANE_CHANGE, new V2ILaneChangeStateHandler());
        this.stateHandlers.put(State.V2I_DEFAULT_DRIVING_BEHAVIOR, new V2IDefaultDrivingBehaviorStateHandler());
        this.stateHandlers.put(State.V2I_PREPARING_RESERVATION, new V2IPreparingReservationStateHandler());
        this.stateHandlers.put(State.V2I_AWAITING_RESPONSE, new V2IAwaitingResponseStateHandler());
        this.stateHandlers.put(State.V2I_MAINTAINING_RESERVATION, new V2IMaintainingReservationStateHandler());
        this.stateHandlers.put(State.V2I_TRAVERSING, new V2ITraversingStateHandler());
        this.stateHandlers.put(State.V2I_CLEARING, new V2IClearingStateHandler());
        this.stateHandlers.put(State.V2I_TERMINAL_STATE, terminalStateHandler);
    }

    private void sendRequestMessage(List<Request.Proposal> proposals) {
        if (this.isDebugging) {
            System.err.printf("Sending %d proposals:\n", proposals.size());
            for (Request.Proposal p : proposals) {
                System.err.printf("%s\n", p);
            }
        }
        Request rqst = new Request(this.vehicle.getVIN(), this.driver.getCurrentIM().getId(), this.nextRequestId, new Request.VehicleSpecForRequestMsg(this.vehicle.getSpec()), proposals);
        this.vehicle.send(rqst);
        ++this.nextRequestId;
    }

    private void sendCancelMessage(int reservationID) {
        this.vehicle.send(new Cancel(this.vehicle.getVIN(), this.driver.getCurrentIM().getId(), reservationID));
    }

    private void sendDoneMessage(int reservationID) {
        this.vehicle.send(new Done(this.vehicle.getVIN(), this.driver.getCurrentIM().getId(), reservationID));
    }

    private void sendAwayMessage(int reservationID) {
        this.vehicle.send(new Away(this.vehicle.getVIN(), this.driver.getCurrentIM().getId(), reservationID));
    }

    private void setReservationParameter(Confirm msg) {
        this.rparameter = new ReservationParameter(msg);
    }

    private void removeReservationParameter() {
        this.rparameter = null;
    }

    private void setState(State state) {
        if (Debug.isPrintDriverStateOfVIN(this.vehicle.getVIN())) {
            System.err.printf("At time %.2f, vin %d changes state to %s\n", new Object[]{this.vehicle.gaugeTime(), this.vehicle.getVIN(), state});
        }
        this.state = state;
        this.lastStateChangeTime = this.vehicle.gaugeTime();
    }

    private double timeSinceStateChange() {
        return this.vehicle.gaugeTime() - this.lastStateChangeTime;
    }

    private boolean isLaneClearToIntersection() {
        double d1 = this.driver.distanceToNextIntersection();
        if (d1 >= Double.MAX_VALUE) {
            return true;
        }
        double d2 = VehicleUtil.distanceToCarInFront(this.vehicle);
        if (d2 >= Double.MAX_VALUE) {
            return true;
        }
        double d3 = d1 - d2;
        return d3 <= V2IPilot.DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION;
    }

    private AccelSchedule decelToStopAtIntersection() {
        double dTotal = this.driver.distanceToNextIntersection() - V2IPilot.DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION;
        if (dTotal > 0.0) {
            double time1 = this.vehicle.gaugeTime();
            double v1 = this.vehicle.gaugeVelocity();
            double vTop = DriverUtil.calculateMaxFeasibleVelocity(this.vehicle);
            double vEndMax = 0.0;
            double accel = this.vehicle.getSpec().getMaxAcceleration();
            double decel = this.vehicle.getSpec().getMaxDeceleration();
            ArrivalEstimationResult result = null;
            try {
                result = VelocityFirstArrivalEstimation.estimate(time1, v1, dTotal, vTop, vEndMax, accel, decel);
            }
            catch (ArrivalEstimationException e) {
                if (this.isDebugging) {
                    System.err.printf("vin %d: arrival estimation in decelToStopAtIntersection() failed: %s", this.vehicle.getVIN(), e.getMessage());
                }
                return null;
            }
            return result.getAccelSchedule();
        }
        return null;
    }

    private class V2IClearingStateHandler
    implements StateHandler {
        private V2IClearingStateHandler() {
        }

        @Override
        public boolean perform() {
            if (V2ICoordinator.this.driver.distanceFromPrevIntersection() > V2ICoordinator.this.rparameter.getACZDistance()) {
                V2ICoordinator.this.sendAwayMessage(V2ICoordinator.this.latestReservationNumber);
                V2ICoordinator.this.setState(State.V2I_TERMINAL_STATE);
                V2ICoordinator.this.pilot.followCurrentLane();
                V2ICoordinator.this.pilot.simpleThrottleAction();
                return false;
            }
            V2ICoordinator.this.pilot.followCurrentLane();
            V2ICoordinator.this.pilot.simpleThrottleAction();
            return false;
        }
    }

    private class V2ITraversingStateHandler
    implements StateHandler {
        private V2ITraversingStateHandler() {
        }

        @Override
        public boolean perform() {
            if (!V2ICoordinator.this.driver.inCurrentIntersection()) {
                if (V2ICoordinator.this.isDebugging) {
                    System.err.printf("Sent done message at time %.2f\n", V2ICoordinator.this.vehicle.gaugeTime());
                }
                V2ICoordinator.this.sendDoneMessage(V2ICoordinator.this.latestReservationNumber);
                V2ICoordinator.this.setState(State.V2I_CLEARING);
                return true;
            }
            V2ICoordinator.this.pilot.takeSteeringActionForTraversing(V2ICoordinator.this.rparameter);
            V2ICoordinator.this.pilot.followAccelerationProfile(V2ICoordinator.this.rparameter);
            return false;
        }
    }

    private class V2IMaintainingReservationStateHandler
    implements StateHandler {
        private V2IMaintainingReservationStateHandler() {
        }

        private boolean checkArrivalTime() {
            double a1 = V2ICoordinator.this.vehicle.gaugeTime() - 0.02;
            double a2 = V2ICoordinator.this.vehicle.gaugeTime();
            double b1 = V2ICoordinator.this.rparameter.getArrivalTime() - V2ICoordinator.this.rparameter.getEarlyError();
            double b2 = V2ICoordinator.this.rparameter.getArrivalTime() + V2ICoordinator.this.rparameter.getLateError();
            if (a1 < b1 && b1 <= a2) {
                return true;
            }
            if (a1 < b2 && b2 <= a2) {
                return true;
            }
            return b1 <= a1 && a2 < b2;
        }

        private boolean checkArrivalVelocity() {
            double v1 = V2ICoordinator.this.rparameter.getArrivalVelocity();
            double v2 = V2ICoordinator.this.vehicle.gaugeVelocity();
            return Util.isDoubleEqual(v1, v2, 3.0);
        }

        @Override
        public boolean perform() {
            if (V2ICoordinator.this.driver.inCurrentIntersection()) {
                if (!this.checkArrivalTime()) {
                    System.err.printf("At time %.2f, the arrival time of vin %d is incorrect.\n", V2ICoordinator.this.vehicle.gaugeTime(), V2ICoordinator.this.vehicle.getVIN());
                    System.err.printf("The arrival time is time %.5f,\n", V2ICoordinator.this.rparameter.getArrivalTime());
                    System.err.printf("but the vehicle arrives at time %.5f\n", V2ICoordinator.this.vehicle.gaugeTime());
                    System.err.printf("distance to next intersection = %.5f\n", V2ICoordinator.this.vehicle.getDriver().distanceToNextIntersection());
                    throw new RuntimeException("The arrival time is incorrect.\n");
                }
                if (!this.checkArrivalVelocity()) {
                    System.err.printf("At time %.2f, the arrival velocity of vin %d is incorrect:\n", V2ICoordinator.this.vehicle.gaugeTime(), V2ICoordinator.this.vehicle.getVIN());
                    throw new RuntimeException("The arrival velocity is incorrect.\n");
                }
                if (V2ICoordinator.this.isDebugging) {
                    System.err.printf("At time %.2f, vin %d, starts traversing\n", V2ICoordinator.this.vehicle.gaugeTime(), V2ICoordinator.this.vehicle.getVIN());
                }
                V2ICoordinator.this.setState(State.V2I_TRAVERSING);
                return true;
            }
            if (V2ICoordinator.this.isLaneClearToIntersection()) {
                V2ICoordinator.this.pilot.followCurrentLane();
                return false;
            }
            if (V2ICoordinator.this.isDebugging) {
                System.err.printf("vin %d, can't keep up with the accel profile.\n", V2ICoordinator.this.vehicle.getVIN());
            }
            V2ICoordinator.this.sendCancelMessage(V2ICoordinator.this.latestReservationNumber);
            V2ICoordinator.this.removeReservationParameter();
            V2ICoordinator.this.vehicle.removeAccelSchedule();
            V2ICoordinator.this.setState(State.V2I_PLANNING);
            return true;
        }
    }

    private class V2IAwaitingResponseStateHandler
    implements StateHandler {
        private V2IAwaitingResponseStateHandler() {
        }

        @Override
        public boolean perform() {
            if (V2ICoordinator.this.vehicle.getAccelSchedule() != null) {
                if (V2ICoordinator.this.isLaneClearToIntersection()) {
                    return false;
                }
                double stoppingDistance = VehicleUtil.calcDistanceToStop(V2ICoordinator.this.vehicle.gaugeVelocity(), V2ICoordinator.this.vehicle.getSpec().getMaxDeceleration());
                double followingDistance = stoppingDistance + V2IPilot.MINIMUM_FOLLOWING_DISTANCE;
                if (VehicleUtil.distanceToCarInFront(V2ICoordinator.this.vehicle) > followingDistance) {
                    return false;
                }
                V2ICoordinator.this.vehicle.removeAccelSchedule();
                V2ICoordinator.this.pilot.followCurrentLane();
                V2ICoordinator.this.pilot.simpleThrottleAction();
                return false;
            }
            V2ICoordinator.this.pilot.followCurrentLane();
            V2ICoordinator.this.pilot.simpleThrottleAction();
            return false;
        }
    }

    private class V2IPreparingReservationStateHandler
    implements StateHandler {
        private V2IPreparingReservationStateHandler() {
        }

        private ArrivalEstimationResult estimateArrival(double maxArrivalVelocity) {
            double time1 = V2ICoordinator.this.vehicle.gaugeTime();
            double v1 = V2ICoordinator.this.vehicle.gaugeVelocity();
            double dTotal = V2ICoordinator.this.driver.distanceToNextIntersection();
            double vTop = DriverUtil.calculateMaxFeasibleVelocity(V2ICoordinator.this.vehicle);
            double vEndMax = Math.min(vTop, maxArrivalVelocity);
            double accel = V2ICoordinator.this.vehicle.getSpec().getMaxAcceleration();
            double decel = V2ICoordinator.this.vehicle.getSpec().getMaxDeceleration();
            AccelSchedule estimateToStop = V2ICoordinator.this.vehicle.getAccelSchedule();
            if (estimateToStop != null) {
                double[] vd = estimateToStop.calcFinalDistanceAndVelocity(time1, v1, time1 + 0.04);
                double d2 = vd[0];
                double v2 = vd[1];
                if (d2 <= dTotal) {
                    time1 += 0.04;
                    v1 = v2;
                    dTotal -= d2;
                } else {
                    throw new RuntimeException("Error in V2ICoordinator::V2IPreparingReservationStateHandler::estimateArrival: vehicle should not have been able to reach the intersection before the IM reply ");
                }
                if (Util.isDoubleZero(v1)) {
                    v1 = 0.0;
                }
            } else if (Util.isDoubleNotZero(v1)) {
                accel -= 1.0;
                decel += 1.0;
                if (accel < 0.0) {
                    accel = 0.0;
                }
                if (decel > 0.0) {
                    decel = 0.0;
                }
            } else {
                time1 += 0.04;
            }
            if (Debug.isPrintArrivalEstimationParameters(V2ICoordinator.this.vehicle.getVIN())) {
                System.err.printf("Parameters for arrival estimation:\n", new Object[0]);
                System.err.printf("time1   = %.5f\n", time1);
                System.err.printf("v1      = %.5f\n", v1);
                System.err.printf("dTotal  = %.5f\n", dTotal);
                System.err.printf("vTop    = %.5f\n", vTop);
                System.err.printf("vEndMax = %.5f\n", vEndMax);
                System.err.printf("accel   = %.5f\n", accel);
                System.err.printf("decel   = %.5f\n", decel);
            }
            ArrivalEstimationResult result = null;
            try {
                result = VelocityFirstArrivalEstimation.estimate(time1, v1, dTotal, vTop, vEndMax, accel, decel);
            }
            catch (ArrivalEstimationException e) {
                if (V2ICoordinator.this.isDebugging) {
                    System.err.printf("vin %d: arrival estimation failed: %s", V2ICoordinator.this.vehicle.getVIN(), e.getMessage());
                }
                return null;
            }
            if (V2ICoordinator.this.isDebugging) {
                System.err.printf("accelSchedule = %s\n", result.getAccelSchedule());
            }
            return result;
        }

        private List<Request.Proposal> prepareProposals() {
            List<Lane> departureLanes = this.getDepartureLanes();
            int n = departureLanes.size();
            Lane l = V2ICoordinator.this.driver.getCurrentLane().getLaneIM().laneToNextIntersection(V2ICoordinator.this.vehicle.gaugePosition());
            ArrayList<Lane> arrivalLanes = new ArrayList<Lane>(n);
            for (int i = 0; i < n; ++i) {
                arrivalLanes.add(l);
            }
            ArrayList<Double> maximumVelocities = new ArrayList<Double>(n);
            for (int i = 0; i < n; ++i) {
                maximumVelocities.add(VehicleUtil.maxTurnVelocity(V2ICoordinator.this.vehicle.getSpec(), (Lane)arrivalLanes.get(i), departureLanes.get(i), V2ICoordinator.this.driver.getCurrentIM()));
            }
            ArrayList<Double> arrivalTimes = new ArrayList<Double>(n);
            ArrayList<Double> arrivalVelocities = new ArrayList<Double>(n);
            double minArrivalTime = V2ICoordinator.this.vehicle.gaugeTime() + 0.1;
            for (int i = 0; i < n; ++i) {
                ArrivalEstimationResult result = this.estimateArrival((Double)maximumVelocities.get(i));
                arrivalVelocities.add(result.getArrivalVelocity());
                arrivalTimes.add(Math.max(result.getArrivalTime(), minArrivalTime));
            }
            ArrayList<Integer> arrivalLaneIDs = new ArrayList<Integer>(n);
            for (Lane lane : arrivalLanes) {
                arrivalLaneIDs.add(lane.getId());
            }
            ArrayList<Integer> departureLaneIDs = new ArrayList<Integer>(n);
            for (Lane departureLane : departureLanes) {
                departureLaneIDs.add(departureLane.getId());
            }
            ArrayList<Request.Proposal> arrayList = new ArrayList<Request.Proposal>(n);
            for (int i = 0; i < n; ++i) {
                if (!((Double)arrivalTimes.get(i) < V2ICoordinator.this.vehicle.gaugeTime() + 9.5)) continue;
                arrayList.add(new Request.Proposal((Integer)arrivalLaneIDs.get(i), (Integer)departureLaneIDs.get(i), (Double)arrivalTimes.get(i), (Double)arrivalVelocities.get(i), (Double)maximumVelocities.get(i)));
            }
            if (arrayList.size() > 0) {
                return arrayList;
            }
            return null;
        }

        private List<Lane> getDepartureLanes() {
            ArrayList<Lane> departureLanes = new ArrayList<Lane>(1);
            Road departureRoad = V2ICoordinator.this.navigator.navigate(Debug.currentMap.getRoad(V2ICoordinator.this.driver.getCurrentLane()), V2ICoordinator.this.driver.getCurrentIM(), V2ICoordinator.this.driver.getDestination());
            List<Lane> lanePriorities = V2ICoordinator.this.driver.getCurrentIM().getSortedDepartureLanes(V2ICoordinator.this.driver.getCurrentLane(), departureRoad);
            int numLanesToTry = Math.min(1, lanePriorities.size());
            for (int i = 0; i < numLanesToTry; ++i) {
                departureLanes.add(lanePriorities.get(i));
            }
            return departureLanes;
        }

        @Override
        public boolean perform() {
            if (V2ICoordinator.this.vehicle.getAccelSchedule() != null) {
                System.err.printf("vin %d should not have an acceleration schedule when it consider preparing a proposal.", V2ICoordinator.this.vehicle.getVIN());
            }
            assert (V2ICoordinator.this.vehicle.getAccelSchedule() == null);
            AccelSchedule accelScheduleToStop = V2ICoordinator.this.decelToStopAtIntersection();
            if (accelScheduleToStop != null) {
                V2ICoordinator.this.vehicle.setAccelSchedule(accelScheduleToStop);
            } else {
                double dTotal;
                V2ICoordinator.this.pilot.followCurrentLane();
                V2ICoordinator.this.vehicle.slowToStop();
                if (V2ICoordinator.this.isDebugging && (dTotal = V2ICoordinator.this.driver.distanceToNextIntersection() - V2IPilot.DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION) < 0.0) {
                    System.err.printf("vin %d passed point of no return\n", V2ICoordinator.this.vehicle.getVIN());
                }
            }
            List<Request.Proposal> proposals = null;
            if (V2ICoordinator.this.isLaneClearToIntersection()) {
                proposals = this.prepareProposals();
                if (V2ICoordinator.this.isDebugging && proposals == null) {
                    System.err.printf("At time %.2f, vin %d failed to prepare a proposal: no feasible proposal.\n", V2ICoordinator.this.vehicle.gaugeTime(), V2ICoordinator.this.vehicle.getVIN());
                }
            } else if (V2ICoordinator.this.isDebugging) {
                System.err.printf("At time %.2f, vin %d failed to prepare a proposal: other vehicle in front\n", V2ICoordinator.this.vehicle.gaugeTime(), V2ICoordinator.this.vehicle.getVIN());
            }
            if (proposals != null) {
                V2ICoordinator.this.sendRequestMessage(proposals);
                V2ICoordinator.this.setState(State.V2I_AWAITING_RESPONSE);
                return true;
            }
            V2ICoordinator.this.nextAllowedSendingRequestTime = V2ICoordinator.this.vehicle.gaugeTime() + 0.02;
            V2ICoordinator.this.setState(State.V2I_PLANNING);
            V2ICoordinator.this.vehicle.removeAccelSchedule();
            return true;
        }
    }

    private class V2IDefaultDrivingBehaviorStateHandler
    implements StateHandler {
        private V2IDefaultDrivingBehaviorStateHandler() {
        }

        @Override
        public boolean perform() {
            V2ICoordinator.this.pilot.followCurrentLane();
            V2ICoordinator.this.pilot.simpleThrottleAction();
            V2ICoordinator.this.setState(State.V2I_PLANNING);
            return false;
        }
    }

    private class V2ILaneChangeStateHandler
    implements StateHandler {
        private V2ILaneChangeStateHandler() {
        }

        @Override
        public boolean perform() {
            V2ICoordinator.this.lcController.step();
            if (V2ICoordinator.this.lcController.isTerminated()) {
                if (V2ICoordinator.this.lcController.isSucceeded()) {
                    V2ICoordinator.this.nextAllowedConsideringLaneChangeTime = V2ICoordinator.this.vehicle.gaugeTime();
                } else {
                    V2ICoordinator.this.nextAllowedConsideringLaneChangeTime = V2ICoordinator.this.vehicle.gaugeTime() + 1.0;
                }
                V2ICoordinator.this.setState(State.V2I_PLANNING);
                return false;
            }
            return false;
        }
    }

    private class V2IPlanningStateHandler
    implements StateHandler {
        private V2IPlanningStateHandler() {
        }

        @Override
        public boolean perform() {
            V2ICoordinator.this.removeReservationParameter();
            if (V2ICoordinator.this.vehicle.gaugeTime() >= V2ICoordinator.this.nextAllowedSendingRequestTime && (!SimConfig.MUST_STOP_BEFORE_INTERSECTION || V2ICoordinator.this.driver.distanceToNextIntersection() <= V2IPilot.DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION + 0.01)) {
                V2ICoordinator.this.setState(State.V2I_PREPARING_RESERVATION);
                return true;
            }
            V2ICoordinator.this.setState(State.V2I_DEFAULT_DRIVING_BEHAVIOR);
            return true;
        }
    }

    public static class ReservationParameter {
        private Lane arrivalLane;
        private Lane departureLane;
        private double arrivalTime;
        private double earlyError;
        private double lateError;
        private double arrivalVelocity;
        private double aczDistance;
        private Queue<double[]> accelerationProfile;

        public ReservationParameter(Confirm msg) {
            this.arrivalLane = Debug.currentMap.getLaneRegistry().get(msg.getArrivalLaneID());
            this.departureLane = Debug.currentMap.getLaneRegistry().get(msg.getDepartureLaneID());
            this.arrivalTime = msg.getArrivalTime();
            this.earlyError = msg.getEarlyError();
            this.lateError = msg.getLateError();
            this.arrivalVelocity = msg.getArrivalVelocity();
            this.aczDistance = msg.getACZDistance();
            this.accelerationProfile = msg.getAccelerationProfile();
        }

        public Lane getArrivalLane() {
            return this.arrivalLane;
        }

        public Lane getDepartureLane() {
            return this.departureLane;
        }

        public double getArrivalTime() {
            return this.arrivalTime;
        }

        public double getEarlyError() {
            return this.earlyError;
        }

        public double getLateError() {
            return this.lateError;
        }

        public double getArrivalVelocity() {
            return this.arrivalVelocity;
        }

        public double getACZDistance() {
            return this.aczDistance;
        }

        public Queue<double[]> getAccelerationProfile() {
            return this.accelerationProfile;
        }
    }

    private static class LaneChangeController {
        private static final double MIN_LANE_CHANGE_FOLLOWING_DISTANCE = 0.5;
        private static final double MIN_VELOCITY_FOR_LANE_CHANGE = 15.0;
        private static final double MIN_DIST_FROM_IM_FOR_LANE_CHANGE = 30.0;
        private static final double LC_INITIATE_TIME_LIMIT = 3.0;
        private State state;
        private Constants.TurnDirection turnDirection;
        private boolean hasBegun;
        private boolean shouldChangeLane;
        private double initiateTimeLimit;
        private boolean isLaneChangeSuccessful;
        private EnumMap<State, StateHandler> stateHandlers;
        private AutoVehicleDriverView vehicle;
        private AutoDriverCoordinatorView driver;
        private V2IPilot pilot;
        private Navigator navigator;

        public LaneChangeController(AutoVehicleDriverView vehicle, AutoDriverCoordinatorView driver, V2IPilot pilot, Navigator navigator) {
            this.vehicle = vehicle;
            this.driver = driver;
            this.pilot = pilot;
            this.navigator = navigator;
            this.stateHandlers = new EnumMap(State.class);
            this.stateHandlers.put(State.LC_WAITING_LANE_CHANGE, new LcWaitingLaneChangeStateHandler());
            this.stateHandlers.put(State.LC_CHANGING_LANE, new LcChangingLaneStateHandler());
            this.stateHandlers.put(State.LC_TERMINAL_STATE, terminalStateHandler);
        }

        public void reset() {
            this.turnDirection = this.getTurnDirection(this.navigator);
            switch (this.turnDirection) {
                case STRAIGHT: {
                    this.shouldChangeLane = false;
                    break;
                }
                case U_TURN: {
                    throw new RuntimeException("The car cannot make a U-turn (yet).");
                }
                case LEFT: {
                    this.shouldChangeLane = this.driver.getCurrentLane().hasLeftNeighbor();
                    break;
                }
                case RIGHT: {
                    this.shouldChangeLane = this.driver.getCurrentLane().hasRightNeighbor();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown turn direction.");
                }
            }
            if (this.shouldChangeLane) {
                this.shouldChangeLane = this.driver.distanceToNextIntersection() >= 30.0;
            }
            this.hasBegun = false;
        }

        public boolean shouldChangeLaneIfPossible() {
            return this.shouldChangeLane;
        }

        public void step() {
            if (!this.hasBegun) {
                assert (this.shouldChangeLane);
                this.vehicle.setVehicleTracking(true);
                if (this.turnDirection == Constants.TurnDirection.LEFT) {
                    this.vehicle.setTargetLaneForVehicleTracking(this.driver.getCurrentLane().getLeftNeighbor());
                } else {
                    this.vehicle.setTargetLaneForVehicleTracking(this.driver.getCurrentLane().getRightNeighbor());
                }
                this.initiateTimeLimit = this.vehicle.gaugeTime() + 3.0;
                this.isLaneChangeSuccessful = false;
                this.setState(State.LC_WAITING_LANE_CHANGE);
                this.hasBegun = true;
            } else {
                if (Debug.isPrintDriverStateOfVIN(this.vehicle.getVIN())) {
                    System.err.printf("LaneChangeController state of vin %d: %s\n", new Object[]{this.vehicle.getVIN(), this.state});
                }
                boolean shouldContinue = true;
                while (shouldContinue) {
                    if (this.stateHandlers.containsKey((Object)this.state)) {
                        shouldContinue = this.stateHandlers.get((Object)this.state).perform();
                        continue;
                    }
                    throw new RuntimeException("Unknown state.");
                }
            }
        }

        public boolean interrupt() {
            switch (this.state) {
                case LC_WAITING_LANE_CHANGE: {
                    this.vehicle.setVehicleTracking(false);
                    this.isLaneChangeSuccessful = false;
                    this.setState(State.LC_TERMINAL_STATE);
                    return true;
                }
                case LC_CHANGING_LANE: {
                    return false;
                }
                case LC_TERMINAL_STATE: {
                    throw new RuntimeException("Interrupt lane changing process after the process has terminated.");
                }
            }
            throw new RuntimeException("Unknown state.");
        }

        public boolean isTerminated() {
            return this.state == State.LC_TERMINAL_STATE;
        }

        public boolean isSucceeded() {
            return this.isLaneChangeSuccessful;
        }

        private Constants.TurnDirection getTurnDirection(Navigator navigator) {
            IntersectionManager im = this.driver.nextIntersectionManager();
            Lane currentLane = this.driver.getCurrentLane();
            Road currentRoad = Debug.currentMap.getRoad(currentLane);
            Road departureRoad = navigator.navigate(currentRoad, im, this.driver.getDestination());
            Lane departureLane = departureRoad.getIndexLane();
            return im.getIntersection().calcTurnDirection(currentLane, departureLane);
        }

        private void setState(State state) {
            if (Debug.isPrintDriverStateOfVIN(this.vehicle.getVIN())) {
                System.err.printf("vin %d changes state to %s\n", new Object[]{this.vehicle.getVIN(), state});
            }
            this.state = state;
        }

        private class LcChangingLaneStateHandler
        implements StateHandler {
            private LcChangingLaneStateHandler() {
            }

            @Override
            public boolean perform() {
                boolean isDone = LaneChangeController.this.turnDirection == Constants.TurnDirection.LEFT ? LaneChangeController.this.driver.getCurrentLane().contains(LaneChangeController.this.vehicle.gaugeRearRightCornerPoint()) : LaneChangeController.this.driver.getCurrentLane().contains(LaneChangeController.this.vehicle.gaugeRearLeftCornerPoint());
                if (isDone) {
                    LaneChangeController.this.driver.setCurrentLane(LaneChangeController.this.driver.getCurrentLane());
                    LaneChangeController.this.isLaneChangeSuccessful = true;
                    LaneChangeController.this.setState(State.LC_TERMINAL_STATE);
                    return false;
                }
                LaneChangeController.this.pilot.followNewLane();
                LaneChangeController.this.pilot.simpleThrottleAction();
                return false;
            }
        }

        private class LcWaitingLaneChangeStateHandler
        implements StateHandler {
            private LcWaitingLaneChangeStateHandler() {
            }

            private boolean isLaneChangingOkay() {
                if (LaneChangeController.this.vehicle.gaugeVelocity() >= 15.0 && LaneChangeController.this.driver.distanceToNextIntersection() >= 30.0) {
                    double leadDist = DriverUtil.getLeadDistance(LaneChangeController.this.vehicle);
                    double stopDist = VehicleUtil.calcDistanceToStop(LaneChangeController.this.vehicle.gaugeVelocity(), LaneChangeController.this.vehicle.getSpec().getMaxDeceleration());
                    double d1 = LaneChangeController.this.vehicle.getFrontVehicleDistanceSensor().read();
                    if (d1 < Math.max(leadDist, stopDist) + 0.5) {
                        return false;
                    }
                    double d2 = LaneChangeController.this.vehicle.getRearVehicleDistanceSensor().read();
                    return !(d2 < LaneChangeController.this.vehicle.getSpec().getLength() + 0.5);
                }
                return false;
            }

            @Override
            public boolean perform() {
                if (this.isLaneChangingOkay()) {
                    LaneChangeController.this.vehicle.setVehicleTracking(false);
                    Lane currentLane = LaneChangeController.this.driver.getCurrentLane();
                    Lane targetLane = LaneChangeController.this.turnDirection == Constants.TurnDirection.LEFT ? currentLane.getLeftNeighbor() : currentLane.getRightNeighbor();
                    LaneChangeController.this.driver.setCurrentLane(targetLane);
                    LaneChangeController.this.driver.addCurrentlyOccupiedLane(currentLane);
                    LaneChangeController.this.setState(State.LC_CHANGING_LANE);
                    return true;
                }
                if (LaneChangeController.this.vehicle.gaugeTime() > LaneChangeController.this.initiateTimeLimit) {
                    LaneChangeController.this.vehicle.setVehicleTracking(false);
                    LaneChangeController.this.isLaneChangeSuccessful = false;
                    LaneChangeController.this.setState(State.LC_TERMINAL_STATE);
                    return false;
                }
                LaneChangeController.this.pilot.followCurrentLane();
                LaneChangeController.this.pilot.simpleThrottleAction();
                return false;
            }
        }

        private static enum State {
            LC_WAITING_LANE_CHANGE,
            LC_CHANGING_LANE,
            LC_TERMINAL_STATE;

        }
    }

    public static enum State {
        V2I_PLANNING,
        V2I_DEFAULT_DRIVING_BEHAVIOR,
        V2I_LANE_CHANGE,
        V2I_PREPARING_RESERVATION,
        V2I_AWAITING_RESPONSE,
        V2I_MAINTAINING_RESERVATION,
        V2I_TRAVERSING,
        V2I_CLEARING,
        V2I_TERMINAL_STATE;

    }

    private static interface StateHandler {
        public boolean perform();
    }
}

