/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver.navigator;

import aim4.config.Debug;
import aim4.driver.navigator.Navigator;
import aim4.im.IntersectionManager;
import aim4.map.BasicMap;
import aim4.map.Road;
import aim4.map.track.WayPoint;
import aim4.util.Util;
import aim4.vehicle.VehicleSpec;
import aim4.vehicle.VehicleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class BasicNavigator
implements Navigator {
    private BasicMap basicMap;
    private VehicleSpec vehicleSpec;
    private Map<List<Integer>, Road> fastestMap = new HashMap<List<Integer>, Road>();

    public BasicNavigator(VehicleSpec vehicleSpec, BasicMap basicMap) {
        this.vehicleSpec = vehicleSpec;
        this.basicMap = basicMap;
    }

    @Override
    public Road navigate(Road current, IntersectionManager im, Road destination) {
        return this.fastestPath(current, im, destination);
    }

    private Road fastestPath(Road currentRoad, IntersectionManager im, Road destinationRoad) {
        List<Integer> key = Arrays.asList(currentRoad.getIndexLane().getId(), im.getId(), destinationRoad.getIndexLane().getId());
        if (!this.fastestMap.containsKey(key)) {
            Node np = this.aStarSearchFastest(currentRoad, im, destinationRoad);
            List<Integer> path = np.getPath();
            List<Integer> pathIMs = np.getPathIMs();
            for (int i = 1; i < path.size(); ++i) {
                List<Integer> currKey = Arrays.asList(path.get(i - 1), pathIMs.get(i - 1), destinationRoad.getIndexLane().getId());
                this.fastestMap.put(currKey, Debug.currentMap.getRoad(path.get(i)));
            }
        }
        return this.fastestMap.get(key);
    }

    private Node aStarSearchFastest(Road currentRoad, IntersectionManager im, Road destRoad) {
        PriorityQueue<Node> queue = new PriorityQueue<Node>();
        WayPoint initPoint = im.getIntersection().getEntryPoint(currentRoad.getIndexLane());
        double estMeas = initPoint.distance(destRoad.getIndexLane().getEndPoint()) / currentRoad.getMaximumConnectedSpeedLimit();
        Node initialNode = new Node(currentRoad.getIndexLane().getId(), im.getId(), 0.0, estMeas);
        queue.add(initialNode);
        while (!queue.isEmpty() && !((Node)queue.peek()).isComplete()) {
            Node node = (Node)queue.poll();
            IntersectionManager nodeIM = this.basicMap.getImRegistry().get(node.getLastIMid());
            Road nodeRoad = node.getLastRoad();
            for (Road r : nodeIM.getIntersection().getExitRoads()) {
                double estRemainingMeas;
                double maxTurnVelocity;
                if (r == nodeRoad.getDual() || Util.isDoubleZero(maxTurnVelocity = VehicleUtil.maxTurnVelocity(this.vehicleSpec, nodeRoad.getIndexLane(), r.getIndexLane(), nodeIM))) continue;
                double actualMeas = nodeIM.traversalDistance(nodeRoad, r) / maxTurnVelocity;
                IntersectionManager nextIM = r.getIndexLane().getLaneIM().nextIntersectionManager(nodeIM);
                if (nextIM != null) {
                    estRemainingMeas = initPoint.distance(destRoad.getIndexLane().getEndPoint()) / currentRoad.getMaximumConnectedSpeedLimit();
                    queue.add(node.makeUpdatedNode(r.getIndexLane().getId(), nextIM.getId(), actualMeas += r.getIndexLane().getLaneIM().timeToNextIntersectionManager(nodeIM, this.vehicleSpec.getMaxVelocity()), estRemainingMeas));
                    continue;
                }
                if (r != destRoad) continue;
                estRemainingMeas = 0.0;
                queue.add(node.makeUpdatedNode(r.getIndexLane().getId(), -1, actualMeas += r.getIndexLane().getLaneIM().remainingDistanceFromLastIntersection() / Math.min(r.getIndexLane().getSpeedLimit(), this.vehicleSpec.getMaxVelocity()), estRemainingMeas));
            }
        }
        return (Node)queue.peek();
    }

    private class Node
    implements Comparable<Node> {
        private List<Integer> path;
        private List<Integer> pathIMs;
        private double actualMeasure;
        private double estimatedRemainingMeasure;

        public Node(int nodeId, int pathIM, double actualMeasure, double estimatedRemainingMeasure) {
            this.path = new ArrayList<Integer>();
            this.pathIMs = new ArrayList<Integer>();
            this.path.add(nodeId);
            this.pathIMs.add(pathIM);
            this.actualMeasure = actualMeasure;
            this.estimatedRemainingMeasure = estimatedRemainingMeasure;
        }

        public Node(List<Integer> path, List<Integer> pathIMs, double actualMeasure, double estimatedRemainingMeasure) {
            this.path = path;
            this.pathIMs = pathIMs;
            this.actualMeasure = actualMeasure;
            this.estimatedRemainingMeasure = estimatedRemainingMeasure;
        }

        @Override
        public int compareTo(Node np) {
            return Double.compare(this.actualMeasure + this.estimatedRemainingMeasure, np.actualMeasure + np.estimatedRemainingMeasure);
        }

        public Node makeUpdatedNode(int pathAddition, int pathIM, double additionMeasure, double estimatedRemainingMeasure) {
            ArrayList<Integer> nextPath = new ArrayList<Integer>(this.path);
            nextPath.add(pathAddition);
            ArrayList<Integer> nextPathIMs = new ArrayList<Integer>(this.pathIMs);
            nextPathIMs.add(pathIM);
            return new Node(nextPath, nextPathIMs, this.actualMeasure + additionMeasure, estimatedRemainingMeasure);
        }

        public boolean isComplete() {
            return this.estimatedRemainingMeasure == 0.0;
        }

        public List<Integer> getPath() {
            return this.path;
        }

        public List<Integer> getPathIMs() {
            return this.pathIMs;
        }

        public Road getLastRoad() {
            return Debug.currentMap.getRoad(this.path.get(this.path.size() - 1));
        }

        public int getLastIMid() {
            return this.pathIMs.get(this.pathIMs.size() - 1);
        }
    }
}

