/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui;

import aim4.config.Debug;
import aim4.config.DebugPoint;
import aim4.driver.AutoDriver;
import aim4.driver.coordinator.V2ICoordinator;
import aim4.gui.Viewer;
import aim4.im.IntersectionManager;
import aim4.im.v2i.RequestHandler.TrafficSignalRequestHandler;
import aim4.im.v2i.V2IManager;
import aim4.im.v2i.policy.BasePolicy;
import aim4.im.v2i.policy.Policy;
import aim4.map.BasicMap;
import aim4.map.DataCollectionLine;
import aim4.map.Road;
import aim4.map.lane.Lane;
import aim4.map.track.ArcTrack;
import aim4.map.track.LineTrack;
import aim4.map.track.PathTrack;
import aim4.map.track.WayPoint;
import aim4.sim.Simulator;
import aim4.util.Util;
import aim4.vehicle.AutoVehicleSimView;
import aim4.vehicle.VehicleSimView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Canvas
extends JPanel
implements ComponentListener,
MouseListener,
MouseWheelListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final double SCALE_FACTOR = 1.1;
    private static final int ZOOM_IN_SCALE_NUM = 10;
    private static final int ZOOM_OUT_SCALE_NUM = 25;
    private static final int SCALE_NUM = 36;
    private static final int VIEW_MARGIN = 50;
    private static final String GRASS_TILE_FILE = "/images/grass128.png";
    private static final String ASPHALT_TILE_FILE = "/images/asphalt32.png";
    public static final Color GRASS_COLOR = Color.GREEN.darker().darker();
    public static final Color ASPHALT_COLOR = Color.BLACK.brighter();
    public static final Color BACKGROUND_COLOR = Color.gray;
    private static final Stroke VEHICLE_STROKE = new BasicStroke(0.1f);
    private static final Color VEHICLE_COLOR = Color.YELLOW;
    private static final Color VEHICLE_HAS_RESERVATION_COLOR = Color.WHITE;
    private static final Color VEHICLE_WAITING_FOR_RESPONSE_COLOR = Color.blue.brighter().brighter().brighter();
    private static final int MARVIN_VEHICLE_VIN = 42;
    private static final Color MARVIN_VEHICLE_COLOR = Color.RED;
    private static final Color VEHICLE_SELECTED_COLOR = Color.ORANGE;
    private static final Color TIRE_COLOR = Color.BLACK;
    private static final Stroke TIRE_STROKE = new BasicStroke(0.1f);
    private static final Color VEHICLE_INFO_STRING_COLOR = Color.RED;
    private static final Font VEHICLE_INFO_STRING_FONT = new Font("Monospaced", 0, 5);
    private static final Color IM_OUTLINE_COLOR = Color.CYAN;
    private static final Color SELECTED_IM_OUTLINE_COLOR = Color.ORANGE;
    private static final Stroke IM_OUTLINE_STROKE = new BasicStroke(0.3f);
    private static final Color ROAD_BOUNDARY_COLOR = Color.YELLOW;
    private static final Stroke ROAD_BOUNDARY_STROKE = new BasicStroke(0.3f);
    private static final Color LANE_SEPARATOR_COLOR = Color.WHITE;
    private static final Stroke LANE_SEPARATOR_STROKE = new BasicStroke(0.3f, 0, 2, 0.0f, new float[]{1.0f, 3.0f}, 0.0f);
    private static final Color DCL_COLOR = Color.WHITE;
    private static final Stroke DCL_STROKE = new BasicStroke(0.3f);
    private static final double TRAFFIC_LIGHT_RADIUS = 2.0;
    private static final Color IM_DEBUG_SHAPE_COLOR = Color.CYAN;
    private static final Color SIMULATION_TIME_STRING_COLOR = Color.YELLOW;
    private static final Font SIMULATION_TIME_STRING_FONT = new Font("Monospaced", 0, 18);
    private static final int SIMULATION_TIME_LOCATION_X = 12;
    private static final int SIMULATION_TIME_LOCATION_Y = 24;
    private static final Color HIGHLIGHTED_VEHICLE_COLOR = Color.GREEN;
    private static final Stroke HIGHLIGHTED_VEHICLE_STROKE = new BasicStroke(0.3f);
    private static final Stroke DEBUG_POINT_STROKE = new BasicStroke(0.3f);
    private static final Font DEBUG_POINT_FONT = new Font("Monospaced", 0, 5);
    private static final double DEBUG_POINT_RADIUS = 0.5;
    private static final Color TRACK_COLOR = Color.RED;
    private static final Stroke TRACK_STROKE = new BasicStroke(0.3f);
    private BasicMap basicMap;
    private int posOfOriginX;
    private int posOfOriginY;
    private int scaleIndex;
    private double[] scaleTable;
    private int lastCursorX;
    private int lastCursorY;
    private BufferedImage grassImage;
    private BufferedImage asphaltImage;
    private Image[] mapImageTable;
    private Image displayImage;
    private Graphics2D displayBuffer;
    private Viewer viewer;
    private boolean canUpdateCanvas;
    private boolean isShowSimulationTime;
    private boolean isShowVin;
    private boolean isShowIMDebugShapes;

    public Canvas(Viewer viewer) {
        this.viewer = viewer;
        this.basicMap = null;
        this.posOfOriginX = 0;
        this.posOfOriginY = 0;
        this.scaleIndex = 0;
        this.scaleTable = null;
        this.lastCursorX = -1;
        this.lastCursorY = -1;
        this.grassImage = this.loadImage(GRASS_TILE_FILE);
        if (this.grassImage == null) {
            System.err.println("Could not load image from file: /images/grass128.png");
        }
        this.asphaltImage = this.loadImage(ASPHALT_TILE_FILE);
        if (this.asphaltImage == null) {
            System.err.println("Could not load image from file: /images/asphalt32.png");
        }
        this.mapImageTable = null;
        this.displayImage = null;
        this.displayBuffer = null;
        this.canUpdateCanvas = false;
        this.isShowSimulationTime = true;
        this.isShowVin = false;
        this.isShowIMDebugShapes = false;
        this.addMouseListener(viewer);
        this.addKeyListener(viewer);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
    }

    private BufferedImage loadImage(String imageFileName) {
        InputStream is = this.getClass().getResourceAsStream(imageFileName);
        BufferedImage image = null;
        if (is != null) {
            try {
                image = ImageIO.read(is);
            }
            catch (IOException e) {
                image = null;
            }
        }
        return image;
    }

    public void initWithGivenMap(BasicMap basicMap) {
        this.basicMap = basicMap;
        this.posOfOriginX = 0;
        this.posOfOriginY = 0;
        this.setupScale();
        this.lastCursorX = -1;
        this.lastCursorY = -1;
        this.makeDisplayBuffer();
        this.mapImageTable = new Image[36];
        for (int i = 0; i < 36; ++i) {
            this.mapImageTable[i] = null;
        }
        this.mapImageTable[this.scaleIndex] = this.createMapImage(basicMap, this.scaleTable[this.scaleIndex]);
        this.canUpdateCanvas = true;
    }

    private void makeDisplayBuffer() {
        this.displayImage = this.createImage(this.getWidth(), this.getHeight());
        this.displayBuffer = (Graphics2D)this.displayImage.getGraphics();
        this.displayBuffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void paintEntireBuffer(Graphics2D buffer, Color color) {
        AffineTransform tf = buffer.getTransform();
        buffer.setTransform(IDENTITY_TRANSFORM);
        buffer.setPaint(color);
        buffer.fillRect(0, 0, this.getSize().width, this.getSize().height);
        buffer.setTransform(tf);
    }

    private void resetAffineTransform() {
        AffineTransform tf = new AffineTransform();
        tf.translate(this.posOfOriginX, this.posOfOriginY);
        tf.scale(this.scaleTable[this.scaleIndex], this.scaleTable[this.scaleIndex]);
        this.displayBuffer.setTransform(tf);
    }

    private void moveOriginToStayWithinView() {
        int w;
        Rectangle2D r = this.basicMap.getDimensions();
        if (this.getWidth() >= 50) {
            if (this.posOfOriginX > this.getWidth() - 50) {
                this.posOfOriginX = this.getWidth() - 50;
            } else {
                w = (int)(r.getWidth() * this.scaleTable[this.scaleIndex]);
                if (this.posOfOriginX + w < 50) {
                    this.posOfOriginX = 50 - w;
                }
            }
        }
        if (this.getHeight() >= 50) {
            if (this.posOfOriginY > this.getHeight() - 50) {
                this.posOfOriginY = this.getHeight() - 50;
            } else {
                w = (int)(r.getHeight() * this.scaleTable[this.scaleIndex]);
                if (this.posOfOriginY + w < 50) {
                    this.posOfOriginY = 50 - w;
                }
            }
        }
    }

    private void setupScale() {
        int i;
        Rectangle2D mapRect = this.basicMap.getDimensions();
        this.scaleTable = new double[36];
        this.scaleIndex = 10;
        this.scaleTable[this.scaleIndex] = Math.min((double)this.getWidth() / mapRect.getWidth(), (double)this.getHeight() / mapRect.getHeight());
        for (i = this.scaleIndex - 1; i >= 0; --i) {
            this.scaleTable[i] = this.scaleTable[i + 1] * 1.1;
        }
        for (i = this.scaleIndex + 1; i < 36; ++i) {
            this.scaleTable[i] = this.scaleTable[i - 1] / 1.1;
        }
    }

    private Image getMapImageTable(int scaleIndex) {
        if (this.mapImageTable[scaleIndex] == null) {
            this.mapImageTable[scaleIndex] = this.createMapImage(this.basicMap, this.scaleTable[scaleIndex]);
        }
        return this.mapImageTable[scaleIndex];
    }

    private Image createMapImage(BasicMap map, double scale) {
        Rectangle2D mapRect = this.basicMap.getDimensions();
        Image bgImage = this.createImage((int)(mapRect.getWidth() * scale), (int)(mapRect.getHeight() * scale));
        Graphics2D bgBuffer = (Graphics2D)bgImage.getGraphics();
        AffineTransform tf = new AffineTransform();
        tf.translate(0.0, 0.0);
        tf.scale(scale, scale);
        bgBuffer.setTransform(tf);
        TexturePaint grassTexture = this.makeScaledTexture(this.grassImage, scale);
        TexturePaint asphaltTexture = this.makeScaledTexture(this.asphaltImage, scale);
        this.paintEntireBuffer(bgBuffer, Color.RED);
        this.drawGrass(bgBuffer, mapRect, grassTexture);
        for (Road road : map.getRoads()) {
            this.drawRoad(bgBuffer, road, asphaltTexture);
        }
        for (IntersectionManager im : map.getIntersectionManagers()) {
            this.drawIntersectionManager(bgBuffer, im, asphaltTexture);
        }
        this.drawDataCollectionLines(bgBuffer, map.getDataCollectionLines());
        return bgImage;
    }

    private TexturePaint makeScaledTexture(BufferedImage image, double scale) {
        if (image != null) {
            Rectangle2D.Double textureRect = new Rectangle2D.Double(0.0, 0.0, (double)image.getWidth() / scale, (double)image.getHeight() / scale);
            return new TexturePaint(image, textureRect);
        }
        return null;
    }

    private void drawGrass(Graphics2D buffer, Rectangle2D rect, TexturePaint grassTexture) {
        if (grassTexture == null) {
            buffer.setPaint(GRASS_COLOR);
        } else {
            buffer.setPaint(grassTexture);
        }
        buffer.fill(rect);
    }

    private void drawRoad(Graphics2D bgBuffer, Road road, TexturePaint asphaltTexture) {
        for (Lane lane : road.getLanes()) {
            this.drawLane(bgBuffer, lane, asphaltTexture);
        }
    }

    private void drawLane(Graphics2D bgBuffer, Lane lane, TexturePaint asphaltTexture) {
        if (asphaltTexture == null) {
            bgBuffer.setPaint(ASPHALT_COLOR);
        } else {
            bgBuffer.setPaint(asphaltTexture);
        }
        bgBuffer.fill(lane.getShape());
        if (lane.hasLeftNeighbor()) {
            bgBuffer.setPaint(LANE_SEPARATOR_COLOR);
            bgBuffer.setStroke(LANE_SEPARATOR_STROKE);
        } else {
            bgBuffer.setPaint(ROAD_BOUNDARY_COLOR);
            bgBuffer.setStroke(ROAD_BOUNDARY_STROKE);
        }
        bgBuffer.draw(lane.leftBorder());
        if (lane.hasRightNeighbor()) {
            bgBuffer.setPaint(LANE_SEPARATOR_COLOR);
            bgBuffer.setStroke(LANE_SEPARATOR_STROKE);
        } else {
            bgBuffer.setPaint(ROAD_BOUNDARY_COLOR);
            bgBuffer.setStroke(ROAD_BOUNDARY_STROKE);
        }
        bgBuffer.draw(lane.rightBorder());
    }

    private void drawIntersectionManager(Graphics2D bgBuffer, IntersectionManager im, TexturePaint asphaltTexture) {
        boolean selected;
        boolean bl = selected = Debug.getTargetIMid() == im.getId();
        if (asphaltTexture == null) {
            bgBuffer.setPaint(ASPHALT_COLOR);
        } else {
            bgBuffer.setPaint(asphaltTexture);
        }
        bgBuffer.fill(im.getIntersection().getArea());
        if (im instanceof V2IManager) {
            if (selected) {
                bgBuffer.setPaint(SELECTED_IM_OUTLINE_COLOR);
            } else {
                bgBuffer.setPaint(IM_OUTLINE_COLOR);
            }
            bgBuffer.setStroke(IM_OUTLINE_STROKE);
            bgBuffer.draw(im.getIntersection().getArea());
        }
    }

    private void drawDataCollectionLines(Graphics2D bgBuffer, List<DataCollectionLine> dataCollectionLines) {
        for (DataCollectionLine line : dataCollectionLines) {
            bgBuffer.setPaint(DCL_COLOR);
            bgBuffer.setStroke(DCL_STROKE);
            bgBuffer.draw(line.getShape());
        }
    }

    public synchronized void cleanUp() {
        this.paintEntireBuffer(this.displayBuffer, BACKGROUND_COLOR);
        for (int i = 0; i < 36; ++i) {
            this.mapImageTable[i] = null;
        }
        this.repaint();
    }

    public void update() {
        if (this.canUpdateCanvas) {
            this.updateCanvas();
        }
    }

    private synchronized void updateCanvas() {
        this.resetAffineTransform();
        this.paintEntireBuffer(this.displayBuffer, BACKGROUND_COLOR);
        this.drawImageOnBuffer(this.displayBuffer, this.getMapImageTable(this.scaleIndex));
        Simulator sim = this.viewer.getSimulator();
        if (sim != null) {
            List<IntersectionManager> ims = sim.getMap().getIntersectionManagers();
            if (this.isShowIMDebugShapes) {
                for (IntersectionManager im : ims) {
                    this.drawIMDebugShapes(this.displayBuffer, im);
                }
            }
            for (VehicleSimView v : sim.getActiveVehicles()) {
                this.drawVehicle(this.displayBuffer, v, sim.getSimulationTime());
            }
            for (IntersectionManager im : ims) {
                this.drawTrafficLights(this.displayBuffer, im);
            }
            if (this.isShowSimulationTime) {
                this.drawSimulationTime(this.displayBuffer, sim.getSimulationTime());
            }
            this.drawDebugPoints(this.displayBuffer, Debug.getLongTermDebugPoints());
            this.drawDebugPoints(this.displayBuffer, Debug.getShortTermDebugPoints());
            for (VehicleSimView v : sim.getActiveVehicles()) {
                this.drawVehicleInfoString(this.displayBuffer, v, sim.getSimulationTime());
            }
            this.repaint();
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.displayImage != null) {
            g.drawImage(this.displayImage, 0, 0, this);
        }
    }

    private void drawImageOnBuffer(Graphics2D buffer, Image image) {
        AffineTransform tf = buffer.getTransform();
        buffer.setTransform(IDENTITY_TRANSFORM);
        buffer.drawImage(image, this.posOfOriginX, this.posOfOriginY, null);
        buffer.setTransform(tf);
    }

    private void drawVehicle(Graphics2D buffer, VehicleSimView vehicle, double currentTime) {
        boolean selectedVehicle;
        boolean bl = selectedVehicle = Debug.getTargetVIN() == vehicle.getVIN();
        if (selectedVehicle) {
            buffer.setPaint(VEHICLE_SELECTED_COLOR);
        } else if (vehicle.getVIN() == 42) {
            buffer.setPaint(MARVIN_VEHICLE_COLOR);
        } else if (Debug.getVehicleColor(vehicle.getVIN()) != null) {
            buffer.setPaint(Debug.getVehicleColor(vehicle.getVIN()));
        } else if (Debug.SHOW_VEHICLE_COLOR_BY_MSG_STATE) {
            if (vehicle.getDriver() instanceof AutoDriver) {
                AutoDriver autoDriver = (AutoDriver)vehicle.getDriver();
                if (autoDriver.getCurrentCoordinator() instanceof V2ICoordinator) {
                    V2ICoordinator coordinator = (V2ICoordinator)autoDriver.getCurrentCoordinator();
                    if (coordinator.isAwaitingResponse()) {
                        buffer.setPaint(VEHICLE_WAITING_FOR_RESPONSE_COLOR);
                    } else if (coordinator.getReservationParameter() != null) {
                        buffer.setPaint(VEHICLE_HAS_RESERVATION_COLOR);
                    } else {
                        buffer.setPaint(VEHICLE_COLOR);
                    }
                } else {
                    buffer.setPaint(VEHICLE_COLOR);
                }
            } else {
                buffer.setPaint(VEHICLE_COLOR);
            }
        } else {
            buffer.setPaint(VEHICLE_COLOR);
        }
        buffer.setStroke(VEHICLE_STROKE);
        buffer.fill(vehicle.getShape());
        if (selectedVehicle) {
            buffer.setPaint(TIRE_COLOR);
            buffer.setStroke(TIRE_STROKE);
            for (Shape wheel : vehicle.getWheelShapes()) {
                buffer.fill(wheel);
            }
        }
    }

    private void drawVehicleInfoString(Graphics2D buffer, VehicleSimView vehicle, double currentTime) {
        AutoDriver da;
        LinkedList<String> infos = new LinkedList<String>();
        if (this.isShowVin) {
            infos.add(Integer.toString(vehicle.getVIN()));
        }
        if (vehicle instanceof AutoVehicleSimView && vehicle.getDriver() instanceof AutoDriver && (da = (AutoDriver)vehicle.getDriver()).getCurrentCoordinator() instanceof V2ICoordinator) {
            V2ICoordinator v2ICoordinator = (V2ICoordinator)da.getCurrentCoordinator();
        }
        if (infos.size() > 0) {
            Point2D centerPoint = vehicle.getCenterPoint();
            buffer.setColor(VEHICLE_INFO_STRING_COLOR);
            buffer.setFont(VEHICLE_INFO_STRING_FONT);
            buffer.drawString(Util.concatenate(infos, ","), (float)centerPoint.getX(), (float)centerPoint.getY());
        }
    }

    private void drawTrafficLights(Graphics2D buffer, IntersectionManager im) {
        BasePolicy basePolicy;
        Policy policy;
        if (im instanceof V2IManager && (policy = ((V2IManager)im).getPolicy()) instanceof BasePolicy && (basePolicy = (BasePolicy)policy).getRequestHandler() instanceof TrafficSignalRequestHandler) {
            TrafficSignalRequestHandler requestHandler = (TrafficSignalRequestHandler)basePolicy.getRequestHandler();
            for (Lane entryLane : im.getIntersection().getEntryLanes()) {
                switch (requestHandler.getSignal(entryLane.getId())) {
                    case GREEN: {
                        buffer.setPaint(Color.GREEN);
                        break;
                    }
                    case YELLOW: {
                        buffer.setPaint(Color.YELLOW);
                        break;
                    }
                    case RED: {
                        buffer.setPaint(Color.RED);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown traffic signals.\n");
                    }
                }
                Arc2D.Double lightShape = new Arc2D.Double(im.getIntersection().getEntryPoint(entryLane).getX() - 2.0, im.getIntersection().getEntryPoint(entryLane).getY() - 2.0, 4.0, 4.0, 90.0 - Math.toDegrees(im.getIntersection().getEntryHeading(entryLane)), 180.0, 2);
                buffer.fill(lightShape);
            }
        }
    }

    private void drawIMDebugShapes(Graphics2D buffer, IntersectionManager im) {
        for (Shape shape : im.getDebugShapes()) {
            buffer.setPaint(IM_DEBUG_SHAPE_COLOR);
            buffer.fill(shape);
        }
    }

    private void drawSimulationTime(Graphics2D buffer, double currentTime) {
        AffineTransform tf = buffer.getTransform();
        buffer.setTransform(IDENTITY_TRANSFORM);
        buffer.setColor(SIMULATION_TIME_STRING_COLOR);
        buffer.setFont(SIMULATION_TIME_STRING_FONT);
        buffer.drawString(String.format("%.2fs", currentTime), 12, 24);
        buffer.setTransform(tf);
    }

    private void drawDebugPoints(Graphics2D buffer, List<DebugPoint> debugPoints) {
        for (DebugPoint p : debugPoints) {
            this.drawDebugPoint(buffer, p);
        }
    }

    private void drawDebugPoint(Graphics2D buffer, DebugPoint p) {
        if (p.getPoint() != null) {
            buffer.setPaint(p.getColor());
            buffer.setStroke(DEBUG_POINT_STROKE);
            if (p.hasStartPoint()) {
                buffer.draw(new Line2D.Double(p.getStartPoint(), p.getPoint()));
            }
            buffer.fill(new Ellipse2D.Double(p.getPoint().getX() - 0.5, p.getPoint().getY() - 0.5, 1.0, 1.0));
            if (p.hasText()) {
                buffer.setFont(DEBUG_POINT_FONT);
                buffer.drawString(p.getText(), (float)(p.getPoint().getX() - 0.5), (float)(p.getPoint().getY() - 0.5));
            }
        }
    }

    private void drawTracks(Graphics2D buffer) {
        PathTrack track = new PathTrack();
        track.add(new ArcTrack(new WayPoint(50.0, 100.0), new WayPoint(100.0, 50.0), new WayPoint(100.0, 100.0), true));
        track.add(new LineTrack(new WayPoint(100.0, 50.0), new WayPoint(200.0, 50.0)));
        track.add(new ArcTrack(new WayPoint(200.0, 50.0), new WayPoint(250.0, 100.0), new WayPoint(200.0, 100.0), false));
        buffer.setPaint(TRACK_COLOR);
        buffer.setStroke(TRACK_STROKE);
        buffer.draw(track.getShape());
        PathTrack pathTrack = track;
        pathTrack.getClass();
        PathTrack.Position pos = new PathTrack.Position(pathTrack, 0.0);
        buffer.setPaint(Color.MAGENTA);
        do {
            double x = pos.getX();
            double y = pos.getY();
            double slope = pos.getTangentSlope();
            double d = 30.0;
            double x2 = x + d * Math.cos(slope);
            double y2 = y + d * Math.sin(slope);
            buffer.draw(new Line2D.Double(x, y, x2, y2));
            double r = 2.0;
            buffer.draw(new Ellipse2D.Double(x - r, y - r, 2.0 * r, 2.0 * r));
        } while (pos.move(10.0) == 0.0);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public synchronized void componentResized(ComponentEvent e) {
        this.canUpdateCanvas = false;
        this.makeDisplayBuffer();
        if (this.basicMap != null) {
            this.moveOriginToStayWithinView();
            this.updateCanvas();
            this.canUpdateCanvas = true;
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastCursorX = e.getX();
        this.lastCursorY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastCursorX = -1;
        this.lastCursorY = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.canUpdateCanvas) {
            Canvas canvas = this;
            synchronized (canvas) {
                this.canUpdateCanvas = false;
                Point2D p = this.getMapPosition(e.getX(), e.getY());
                int notches = e.getWheelRotation();
                this.scaleIndex += notches;
                if (this.scaleIndex < 0) {
                    this.scaleIndex = 0;
                }
                if (this.scaleIndex >= 36) {
                    this.scaleIndex = 35;
                }
                this.posOfOriginX = (int)((double)e.getX() - this.scaleTable[this.scaleIndex] * p.getX());
                this.posOfOriginY = (int)((double)e.getY() - this.scaleTable[this.scaleIndex] * p.getY());
                this.moveOriginToStayWithinView();
                this.updateCanvas();
                this.canUpdateCanvas = true;
            }
        }
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.lastCursorX >= 0 && this.lastCursorY >= 0) {
            this.canUpdateCanvas = false;
            this.posOfOriginX += e.getX() - this.lastCursorX;
            this.posOfOriginY += e.getY() - this.lastCursorY;
            this.moveOriginToStayWithinView();
            this.updateCanvas();
            this.canUpdateCanvas = true;
        }
        this.lastCursorX = e.getX();
        this.lastCursorY = e.getY();
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
    }

    public void setIsShowSimulationTime(boolean b) {
        this.isShowSimulationTime = b;
    }

    public void setIsShowVin(boolean b) {
        this.isShowVin = b;
    }

    public void setIsShowIMDebugShapes(boolean useIMDebugShapes) {
        this.isShowIMDebugShapes = useIMDebugShapes;
    }

    public void saveScreenShot(String outFileName) {
        File outfile = new File(outFileName);
        try {
            if (!ImageIO.write((RenderedImage)((BufferedImage)this.displayImage), "png", outfile)) {
                System.err.printf("Error in Canvas::saveScreenShot(): no appropriate writer is found\n", new Object[0]);
            }
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe);
        }
    }

    public Point2D getMapPosition(int screenPosX, int screenPosY) {
        return new Point2D.Double((double)(screenPosX - this.posOfOriginX) / this.scaleTable[this.scaleIndex], (double)(screenPosY - this.posOfOriginY) / this.scaleTable[this.scaleIndex]);
    }

    public void highlightVehicle(int vin) {
        VehicleSimView vehicle;
        Simulator sim = this.viewer.getSimulator();
        if (sim != null && (vehicle = sim.getActiveVehicle(vin)) != null) {
            this.displayBuffer.setPaint(HIGHLIGHTED_VEHICLE_COLOR);
            this.displayBuffer.setStroke(HIGHLIGHTED_VEHICLE_STROKE);
            this.displayBuffer.fill(vehicle.getShape());
            this.repaint();
        }
    }
}

