/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui;

import aim4.gui.StatusPanelInterface;
import aim4.gui.Viewer;
import aim4.gui.statuspanel.AdminControlPanel;
import aim4.gui.statuspanel.ConsolePanel;
import aim4.gui.statuspanel.SimControlPanel;
import aim4.gui.statuspanel.StatPanel;
import aim4.gui.statuspanel.SystemPanel;
import aim4.gui.statuspanel.VehicleInfoPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StatusPanelContainer
extends JTabbedPane
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    SimControlPanel controlPanel;
    StatPanel statPanel;
    SystemPanel systemPanel;
    ConsolePanel consolePanel;
    VehicleInfoPanel vehicleInfoPanel;
    AdminControlPanel adminControlPanel;

    public StatusPanelContainer(Viewer viewer) {
        this.controlPanel = new SimControlPanel(viewer);
        this.add("Simulation", this.controlPanel);
        this.statPanel = new StatPanel(viewer);
        this.add("Statistics", this.statPanel);
        this.systemPanel = new SystemPanel();
        this.add("System", this.systemPanel);
        this.consolePanel = new ConsolePanel();
        this.add("Console", this.consolePanel);
        this.vehicleInfoPanel = new VehicleInfoPanel();
        this.add("Vehicle", this.vehicleInfoPanel);
        this.adminControlPanel = new AdminControlPanel(viewer);
        this.add("Admin", this.adminControlPanel);
        this.addChangeListener(this);
    }

    public void init() {
        this.clear();
    }

    public void update() {
        StatusPanelInterface selectedPanel = (StatusPanelInterface)((Object)this.getSelectedComponent());
        selectedPanel.update();
    }

    public void clear() {
        this.controlPanel.clear();
        this.statPanel.clear();
        this.systemPanel.clear();
        this.consolePanel.clear();
        this.vehicleInfoPanel.clear();
    }

    public void writeToConsole(String str) {
        this.consolePanel.append(str);
    }

    public double getSimSpeed() {
        return this.controlPanel.getSimSpeed();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.update();
    }
}

