/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui.component;

import aim4.util.Util;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LabeledSlider
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private double minValue;
    private double maxValue;
    private double defaultValue;
    private double majorTick;
    private double minorTick;
    private String labelFormat;
    private String tickLabelFormat;
    private Map<Integer, String> specialTickLabelTable;
    private Map<Integer, String> specialTickLabelFormatTable;
    private ChangeListener changeListener;
    JLabel label;
    JSlider slider;

    public LabeledSlider(double minValue, double maxValue, double defaultValue, double majorTick, double minorTick, String labelFormat, String tickLabelFormat, ChangeListener changeListener) {
        this(minValue, maxValue, defaultValue, majorTick, minorTick, labelFormat, tickLabelFormat);
        this.changeListener = changeListener;
    }

    public LabeledSlider(double minValue, double maxValue, double defaultValue, double majorTick, double minorTick, String labelFormat, String tickLabelFormat) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.majorTick = majorTick;
        this.minorTick = minorTick;
        this.labelFormat = labelFormat;
        this.tickLabelFormat = tickLabelFormat;
        this.specialTickLabelTable = new HashMap<Integer, String>();
        this.specialTickLabelFormatTable = new HashMap<Integer, String>();
        this.setLayout(new BoxLayout(this, 3));
        this.label = new JLabel();
        this.setLabel((int)(defaultValue / minorTick));
        this.label.setAlignmentX(0.5f);
        this.add(this.label);
        this.slider = new JSlider(0, (int)(minValue / minorTick), (int)(maxValue / minorTick), (int)(defaultValue / minorTick));
        this.slider.setMajorTickSpacing((int)(majorTick / minorTick));
        this.slider.setMinorTickSpacing(1);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(this);
        this.slider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        double r = minValue;
        while (Util.isDoubleEqualOrLess(r, maxValue)) {
            labelTable.put((int)(r / minorTick), new JLabel(String.format(tickLabelFormat, r)));
            r += majorTick;
        }
        this.slider.setLabelTable(labelTable);
        this.add(this.slider);
        this.changeListener = null;
    }

    public double getValue() {
        return (double)this.slider.getValue() * this.minorTick;
    }

    public void setTickLabel(double value, String l, String fmt) {
        int vid = (int)(value / this.minorTick);
        Hashtable labelTable = (Hashtable)this.slider.getLabelTable();
        ((Dictionary)labelTable).put(vid, new JLabel(l));
        this.slider.setLabelTable(labelTable);
        this.specialTickLabelTable.put(vid, l);
        this.specialTickLabelFormatTable.put(vid, fmt);
        this.setLabel(this.slider.getValue());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        this.setLabel(source.getValue());
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private void setLabel(int vid) {
        double value = (double)vid * this.minorTick;
        if (this.specialTickLabelFormatTable.containsKey(vid)) {
            this.label.setText(String.format(this.specialTickLabelFormatTable.get(vid), this.specialTickLabelTable.get(vid)));
        } else {
            this.label.setText(String.format(this.labelFormat, value));
        }
    }
}

