/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui.parampanel;

import aim4.gui.component.LabeledSlider;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class TrafficSignalParamPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    LabeledSlider trafficRateSlider;
    LabeledSlider greenLightDurationSlider;
    LabeledSlider yelloLightDurationSlider;
    LabeledSlider lanesPerRoadSlider;

    public TrafficSignalParamPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.trafficRateSlider = new LabeledSlider(0.0, 2500.0, 800.0, 500.0, 100.0, "Traffic Level: %.0f vehicles/hour/lane", "%.0f");
        this.add(this.trafficRateSlider);
        this.lanesPerRoadSlider = new LabeledSlider(1.0, 8.0, 3.0, 1.0, 1.0, "Number of Lanes per Road: %.0f", "%.0f");
        this.add(this.lanesPerRoadSlider);
        this.greenLightDurationSlider = new LabeledSlider(0.0, 60.0, 30.0, 5.0, 1.0, "Green Signal Duration: %.1f seconds", "%.0f");
        this.add(this.greenLightDurationSlider);
        this.yelloLightDurationSlider = new LabeledSlider(0.0, 60.0, 5.0, 5.0, 1.0, "Yellow Signal Duration: %.1f seconds", "%.0f");
        this.add(this.yelloLightDurationSlider);
    }

    public double getTrafficRate() {
        return this.trafficRateSlider.getValue() / 3600.0;
    }

    public double getGreenLightDuration() {
        return this.greenLightDurationSlider.getValue();
    }

    public double getYellowLightDuration() {
        return this.yelloLightDurationSlider.getValue();
    }

    public int getLanesPerRoad() {
        return (int)this.lanesPerRoadSlider.getValue();
    }
}

