/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui.statuspanel;

import aim4.config.Debug;
import aim4.gui.StatusPanelInterface;
import aim4.gui.Viewer;
import aim4.im.IntersectionManager;
import aim4.im.v2i.RequestHandler.AllStopRequestHandler;
import aim4.im.v2i.RequestHandler.FCFSRequestHandler;
import aim4.im.v2i.RequestHandler.GoStraightRequestHandler;
import aim4.im.v2i.V2IManager;
import aim4.im.v2i.policy.BasePolicy;
import aim4.sim.Simulator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class AdminControlPanel
extends JPanel
implements StatusPanelInterface,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton fcfsButton;
    private JButton stopButton;
    private JButton straightButton;
    private JButton mixedLightButton;
    Viewer viewer;

    public AdminControlPanel(Viewer viewer) {
        this.viewer = viewer;
        this.fcfsButton = new JButton("FCFS");
        this.stopButton = new JButton("Stop");
        this.straightButton = new JButton("Alternate");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.fcfsButton).addComponent(this.stopButton).addComponent(this.straightButton));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.fcfsButton).addComponent(this.stopButton).addComponent(this.straightButton));
        this.fcfsButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.straightButton.addActionListener(this);
    }

    @Override
    public void update() {
    }

    @Override
    public void clear() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int imId;
        if ((e.getSource() == this.fcfsButton || e.getSource() == this.stopButton || e.getSource() == this.straightButton) && (imId = Debug.getTargetIMid()) >= 0) {
            V2IManager im;
            Simulator sim = this.viewer.getSimulator();
            IntersectionManager im0 = sim.getMap().getIntersectionManagers().get(imId);
            assert (im0.getId() == imId);
            if (im0 instanceof V2IManager && (im = (V2IManager)im0).getPolicy() instanceof BasePolicy) {
                BasePolicy policy = (BasePolicy)im.getPolicy();
                if (e.getSource() == this.fcfsButton) {
                    policy.setRequestHandler(new FCFSRequestHandler());
                } else if (e.getSource() == this.stopButton) {
                    policy.setRequestHandler(new AllStopRequestHandler());
                } else if (e.getSource() == this.straightButton) {
                    policy.setRequestHandler(new GoStraightRequestHandler());
                }
            }
        }
    }
}

