/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui.statuspanel;

import aim4.gui.StatusPanelInterface;
import aim4.gui.Viewer;
import aim4.gui.component.FormattedLabel;
import aim4.sim.Simulator;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

public class StatPanel
extends JPanel
implements StatusPanelInterface {
    private static final long serialVersionUID = 1L;
    private FormattedLabel currentTimeLabel = new FormattedLabel("Current Time: ", "%8.2f s", 10);
    private FormattedLabel overallCompletedVehiclesLabel = new FormattedLabel("Completed Vehicles: ", "%5d", 5);
    private FormattedLabel overallAverageTransmittedLabel = new FormattedLabel("Average Data Transmitted: ", "%5.2f kB", 8);
    private FormattedLabel overallAverageReceivedLabel = new FormattedLabel("Average Data Received: ", "%5.2f kB", 8);
    private Viewer viewer;

    public StatPanel(Viewer viewer) {
        this.viewer = viewer;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        gridbag.setConstraints(this.currentTimeLabel, c);
        this.add(this.currentTimeLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this.overallCompletedVehiclesLabel, c);
        this.add(this.overallCompletedVehiclesLabel);
        c.gridwidth = 1;
        gridbag.setConstraints(this.overallAverageTransmittedLabel, c);
        this.add(this.overallAverageTransmittedLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this.overallAverageReceivedLabel, c);
        this.add(this.overallAverageReceivedLabel);
    }

    @Override
    public void update() {
        Simulator sim = this.viewer.getSimulator();
        if (sim != null) {
            this.currentTimeLabel.update(sim.getSimulationTime());
            this.overallCompletedVehiclesLabel.update(sim.getNumCompletedVehicles());
            this.overallAverageTransmittedLabel.update(sim.getAvgBitsTransmittedByCompletedVehicles() / 8192.0);
            this.overallAverageReceivedLabel.update(sim.getAvgBitsReceivedByCompletedVehicles() / 8192.0);
        } else {
            this.clear();
        }
    }

    @Override
    public void clear() {
        this.currentTimeLabel.clear();
        this.overallCompletedVehiclesLabel.clear();
        this.overallAverageTransmittedLabel.clear();
        this.overallAverageReceivedLabel.clear();
    }
}

