/*
 * Decompiled with CFR 0.152.
 */
package aim4.im;

import aim4.config.Debug;
import aim4.im.RoadBasedIntersection;
import aim4.im.TrackModel;
import aim4.map.Road;
import aim4.map.lane.Lane;
import aim4.map.track.WayPoint;
import aim4.util.GeomMath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RoadBasedTrackModel
implements TrackModel {
    private RoadBasedIntersection intersection;
    private Map<Lane, Map<Road, List<Lane>>> lanePriorities = new HashMap<Lane, Map<Road, List<Lane>>>();
    private Map<List<Integer>, Double> memoTraversalDistance = new HashMap<List<Integer>, Double>();
    private Set<List<Integer>> laneConflicts = new HashSet<List<Integer>>();

    public RoadBasedTrackModel(RoadBasedIntersection intersection) {
        this.intersection = intersection;
        this.calculateLanePriorities();
        this.calculateLaneConflicts();
    }

    private void calculateLanePriorities() {
        for (Lane entryLane : this.intersection.getEntryLanes()) {
            HashMap<Road, ArrayList<Lane>> exitPriorities = new HashMap<Road, ArrayList<Lane>>();
            for (Road exitRoad : this.intersection.getExitRoads()) {
                ArrayList<Lane> exitLanes = new ArrayList<Lane>(exitRoad.getLanes());
                ExitPointDistanceComparator c = new ExitPointDistanceComparator(entryLane);
                Collections.sort(exitLanes, c);
                exitPriorities.put(exitRoad, exitLanes);
            }
            this.lanePriorities.put(entryLane, exitPriorities);
        }
    }

    private List<Line2D> inIntersectionSegments(Lane l1, Lane l2) {
        ArrayList<Line2D> segments = new ArrayList<Line2D>();
        if (l1 == l2) {
            segments.add(new Line2D.Double(this.intersection.getEntryPoint(l1), this.intersection.getExitPoint(l2)));
        } else {
            Line2D.Double l2InIntersection;
            Point2D l1End = this.intersection.isExitedBy(l1) ? this.intersection.getExitPoint(l1) : l1.getEndPoint();
            Point2D l2Start = this.intersection.isEnteredBy(l2) ? this.intersection.getEntryPoint(l2) : l2.getStartPoint();
            Line2D.Double l1InIntersection = new Line2D.Double(this.intersection.getEntryPoint(l1), l1End);
            if (l1InIntersection.intersectsLine(l2InIntersection = new Line2D.Double(l2Start, this.intersection.getExitPoint(l2)))) {
                Point2D ixn = GeomMath.findLineLineIntersection(l1InIntersection, l2InIntersection);
                segments.add(new Line2D.Double(this.intersection.getEntryPoint(l1), ixn));
                segments.add(new Line2D.Double(ixn, this.intersection.getExitPoint(l2)));
            } else {
                segments.add(l1InIntersection);
                segments.add(l2InIntersection);
            }
        }
        return segments;
    }

    private void calculateLaneConflicts() {
        for (Lane l11 : this.intersection.getEntryLanes()) {
            for (Lane l12 : this.intersection.getExitLanes()) {
                List<Line2D> l1Segments = this.inIntersectionSegments(l11, l12);
                for (Lane l21 : this.intersection.getEntryLanes()) {
                    block3: for (Lane l22 : this.intersection.getExitLanes()) {
                        if (l11 == l21 || l12 == l22) {
                            List<Integer> key = Arrays.asList(l11.getId(), l12.getId(), l21.getId(), l22.getId());
                            this.laneConflicts.add(key);
                            continue;
                        }
                        List<Line2D> l2Segments = this.inIntersectionSegments(l21, l22);
                        for (Line2D l1Seg : l1Segments) {
                            for (Line2D l2Seg : l2Segments) {
                                if (!l1Seg.intersectsLine(l2Seg)) continue;
                                List<Integer> key = Arrays.asList(l11.getId(), l12.getId(), l21.getId(), l22.getId());
                                this.laneConflicts.add(key);
                                continue block3;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public RoadBasedIntersection getIntersection() {
        return this.intersection;
    }

    @Override
    public List<Lane> getSortedDepartureLanes(Lane arrivalLane, Road departure) {
        return this.lanePriorities.get(arrivalLane).get(departure);
    }

    @Override
    public boolean trajectoriesConflict(int l11, int l12, int l21, int l22) {
        List<Integer> lookupKey = Arrays.asList(l11, l12, l21, l22);
        return this.laneConflicts.contains(lookupKey);
    }

    @Override
    public double traversalDistance(Road arrival, Road departure) {
        return this.traversalDistance(arrival.getIndexLane(), departure.getIndexLane());
    }

    @Override
    public double traversalDistance(Lane arrival, Lane departure) {
        List<Integer> key = Arrays.asList(arrival.getId(), departure.getId());
        if (!this.memoTraversalDistance.containsKey(key)) {
            double totalDistance = 0.0;
            List<Line2D> segments = this.inIntersectionSegments(arrival, departure);
            for (Line2D line : segments) {
                totalDistance += line.getP1().distance(line.getP2());
            }
            this.memoTraversalDistance.put(key, totalDistance);
        }
        return this.memoTraversalDistance.get(key);
    }

    @Override
    public double traversalDistance(int arrivalID, int departureID) {
        List<Integer> key = Arrays.asList(arrivalID, departureID);
        Lane arrival = Debug.currentMap.getLaneRegistry().get(arrivalID);
        Lane departure = Debug.currentMap.getLaneRegistry().get(departureID);
        return this.traversalDistance(arrival, departure);
    }

    private class ExitPointDistanceComparator
    implements Comparator<Lane> {
        private Point2D entry;

        public ExitPointDistanceComparator(Lane entryLane) {
            this.entry = RoadBasedTrackModel.this.intersection.getEntryPoint(entryLane);
        }

        @Override
        public int compare(Lane l1, Lane l2) {
            if (!RoadBasedTrackModel.this.intersection.isExitedBy(l1) || !RoadBasedTrackModel.this.intersection.isExitedBy(l2)) {
                throw new IllegalArgumentException("Both lanes being compared must exit this intersection!");
            }
            WayPoint l1Exit = RoadBasedTrackModel.this.intersection.getExitPoint(l1);
            WayPoint l2Exit = RoadBasedTrackModel.this.intersection.getExitPoint(l2);
            return Double.compare(this.entry.distance(l1Exit), this.entry.distance(l2Exit));
        }
    }
}

