/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.RequestHandler;

import aim4.config.Debug;
import aim4.im.v2i.RequestHandler.RequestHandler;
import aim4.im.v2i.policy.BasePolicy;
import aim4.im.v2i.policy.BasePolicyCallback;
import aim4.im.v2i.policy.ExtendedBasePolicyCallback;
import aim4.map.Road;
import aim4.msg.i2v.Reject;
import aim4.msg.v2i.Request;
import aim4.sim.StatCollector;
import java.util.List;
import java.util.ListIterator;

public class ApproxStopSignRequestHandler
implements RequestHandler {
    public static final double DEFAULT_TIME_WINDOW_BEFORE_LAST_EXIT_VEHICLE = 0.1;
    private ExtendedBasePolicyCallback basePolicy;
    private double timeWindowBeforeLastExitVehicle = 0.1;
    private String nextRoadName = null;

    @Override
    public void setBasePolicyCallback(BasePolicyCallback basePolicy) {
        if (!(basePolicy instanceof ExtendedBasePolicyCallback)) {
            throw new RuntimeException("The BasePolicyCallback for AllStopRequestHandler must be ExtendedBasePolicyCallback.");
        }
        this.basePolicy = (ExtendedBasePolicyCallback)basePolicy;
    }

    @Override
    public void act(double timeStep) {
    }

    @Override
    public void processRequestMsg(Request msg) {
        int vin = msg.getVin();
        if (this.basePolicy.hasReservation(vin)) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.CONFIRMED_ANOTHER_REQUEST);
            return;
        }
        BasePolicy.ProposalFilterResult filterResult = BasePolicy.standardProposalsFilter(msg.getProposals(), this.basePolicy.getCurrentTime());
        if (filterResult.isNoProposalLeft()) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), filterResult.getReason());
        }
        List<Request.Proposal> proposals = filterResult.getProposals();
        this.removeProposalWithInvalidArrivalTime(vin, proposals);
        if (proposals.isEmpty()) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
            return;
        }
        if (!this.canEnterFromLane(proposals.get(0).getArrivalLaneID())) {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
            return;
        }
        BasePolicy.ReserveParam reserveParam = this.basePolicy.findReserveParam(msg, proposals);
        if (reserveParam != null) {
            this.basePolicy.sendComfirmMsg(msg.getRequestId(), reserveParam);
        } else {
            this.basePolicy.sendRejectMsg(vin, msg.getRequestId(), Reject.Reason.NO_CLEAR_PATH);
        }
    }

    @Override
    public StatCollector<?> getStatCollector() {
        return null;
    }

    private void removeProposalWithInvalidArrivalTime(int vin, List<Request.Proposal> proposals) {
        ListIterator<Request.Proposal> tpIter = proposals.listIterator();
        while (tpIter.hasNext()) {
            Request.Proposal prop = (Request.Proposal)tpIter.next();
            if (this.canEnterAtArrivalTime(vin, prop.getArrivalTime())) continue;
            tpIter.remove();
        }
    }

    private boolean canEnterAtArrivalTime(int vin, double arrivalTime) {
        double lastReservedTime = this.basePolicy.getReservationGrid().getLastReservedTime();
        return !(lastReservedTime - this.timeWindowBeforeLastExitVehicle > arrivalTime);
    }

    private boolean canEnterFromLane(int laneId) {
        Road road = Debug.currentMap.getRoad(laneId);
        String roadName = road.getName();
        if (this.nextRoadName != null) {
            double lastReservedTime = this.basePolicy.getReservationGrid().getLastReservedTime();
            if (roadName.equals(this.nextRoadName) || lastReservedTime <= this.basePolicy.getCurrentTime()) {
                if (this.nextRoadName.equals("1st Avenue N")) {
                    this.nextRoadName = "1st Street W";
                } else if (this.nextRoadName.equals("1st Street W")) {
                    this.nextRoadName = "1st Avenue S";
                } else if (this.nextRoadName.equals("1st Avenue S")) {
                    this.nextRoadName = "1st Street E";
                } else if (this.nextRoadName.equals("1st Street E")) {
                    this.nextRoadName = "1st Avenue N";
                } else {
                    throw new RuntimeException("Error in ApproxStopSignFCFSPolicy.canEnterFromRoad()");
                }
                return true;
            }
            return false;
        }
        this.nextRoadName = roadName;
        return false;
    }
}

