/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i;

import aim4.config.Debug;
import aim4.im.Intersection;
import aim4.im.IntersectionManager;
import aim4.im.TrackModel;
import aim4.im.v2i.V2IManagerCallback;
import aim4.im.v2i.policy.Policy;
import aim4.im.v2i.reservation.AczManager;
import aim4.im.v2i.reservation.AdmissionControlZone;
import aim4.im.v2i.reservation.ReservationGrid;
import aim4.im.v2i.reservation.ReservationGridManager;
import aim4.map.lane.Lane;
import aim4.msg.i2v.I2VMessage;
import aim4.msg.v2i.V2IMessage;
import aim4.sim.StatCollector;
import aim4.util.Registry;
import aim4.util.TiledArea;
import java.awt.Shape;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class V2IManager
extends IntersectionManager
implements V2IManagerCallback {
    public static final double MAXIMUM_FUTURE_RESERVATION_TIME = 10.0;
    private static final double DEFAULT_TRANSMISSION_POWER = 350.0;
    private static final double DEFAULT_ACZ_SIZE = 40.0;
    private static final double ACZ_DISTANCE_SHAPE_LENGTH = 1.0;
    private Policy policy;
    private double transmissionPower = 350.0;
    private List<V2IMessage> inbox = new ArrayList<V2IMessage>();
    private List<I2VMessage> outbox = new ArrayList<I2VMessage>();
    private int bitsReceived;
    private int bitsTransmitted;
    private TiledArea tiledArea;
    private ReservationGrid reservationGrid;
    private ReservationGridManager reservationGridManager;
    private Map<Integer, AdmissionControlZone> aczs = new LinkedHashMap<Integer, AdmissionControlZone>();
    private Map<Integer, AczManager> aczManagers = new LinkedHashMap<Integer, AczManager>();

    public V2IManager(Intersection intersection, TrackModel trackModel, double currentTime, ReservationGridManager.Config config, Registry<IntersectionManager> registry) {
        super(intersection, trackModel, currentTime, registry);
        this.tiledArea = new TiledArea(intersection.getArea(), config.getGranularity());
        this.reservationGrid = new ReservationGrid(this.tiledArea.getXNum(), this.tiledArea.getYNum(), config.getGridTimeStep());
        this.reservationGridManager = new ReservationGridManager(config, intersection, this.tiledArea, this.reservationGrid);
        for (Lane l : this.getIntersection().getExitLanes()) {
            AdmissionControlZone acz = new AdmissionControlZone(40.0);
            this.aczs.put(l.getId(), acz);
            this.aczManagers.put(l.getId(), new AczManager(acz));
        }
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    @Override
    public void act(double timeStep) {
        Iterator<V2IMessage> iter = this.inboxIterator();
        while (iter.hasNext()) {
            V2IMessage msg = iter.next();
            if (Debug.isPrintIMInboxMessageOfVIN(msg.getVin())) {
                System.err.printf("im %d process message of vin %d: %s\n", this.getId(), msg.getVin(), msg);
            }
            this.processV2IMessage(msg);
        }
        this.clearInbox();
        this.policy.act(timeStep);
        this.reservationGridManager.act(timeStep);
        super.act(timeStep);
    }

    public double getTransmissionPower() {
        return this.transmissionPower;
    }

    public Iterator<V2IMessage> inboxIterator() {
        return this.inbox.iterator();
    }

    public void clearInbox() {
        this.inbox.clear();
    }

    public Iterator<I2VMessage> outboxIterator() {
        return this.outbox.iterator();
    }

    public void clearOutbox() {
        this.outbox.clear();
    }

    public void receive(V2IMessage msg) {
        this.inbox.add(msg);
        this.bitsReceived += msg.getSize();
    }

    public int getBitsReceived() {
        return this.bitsReceived;
    }

    public int getBitsTransmitted() {
        return this.bitsTransmitted;
    }

    @Override
    public ReservationGrid getReservationGrid() {
        return this.reservationGrid;
    }

    @Override
    public ReservationGridManager getReservationGridManager() {
        return this.reservationGridManager;
    }

    @Override
    public AdmissionControlZone getACZ(int laneId) {
        return this.aczs.get(laneId);
    }

    @Override
    public AczManager getAczManager(int laneId) {
        return this.aczManagers.get(laneId);
    }

    @Override
    public void sendI2VMessage(I2VMessage msg) {
        if (Debug.isPrintIMOutboxMessageOfVIN(msg.getVin())) {
            System.err.printf("im %d sends a message to vin %d: %s\n", this.getId(), msg.getVin(), msg);
        }
        this.outbox.add(msg);
        this.bitsTransmitted += msg.getSize();
    }

    private void processV2IMessage(V2IMessage msg) {
        this.policy.processV2IMessage(msg);
    }

    @Override
    public void printData(String outFileName) {
        PrintStream outfile = null;
        try {
            outfile = new PrintStream(outFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (outfile != null) {
            StatCollector<ReservationGridManager> gridStatCollector;
            StatCollector<?> statCollector = this.policy.getStatCollector();
            if (statCollector != null) {
                statCollector.print(outfile);
            }
            if ((gridStatCollector = this.reservationGridManager.getStatCollector()) != null) {
                gridStatCollector.print(outfile);
            }
        }
    }

    @Override
    public List<? extends Shape> getDebugShapes() {
        List<Shape> dbg = this.getACZDebugShapes();
        dbg.addAll(this.reservationGridManager.getDebugShapes());
        return dbg;
    }

    private List<Shape> getACZDebugShapes() {
        ArrayList<Shape> laneShapes = new ArrayList<Shape>();
        for (Lane lane : this.getIntersection().getExitLanes()) {
            double aczCapPos;
            double aczEndPos = lane.normalizedDistanceAlongLane(this.getIntersection().getExitPoint(lane)) + this.aczs.get(lane.getId()).getMaxSize() / lane.getLength();
            if (aczEndPos > 0.0) {
                double end = aczEndPos + 1.0 / lane.getLength();
                laneShapes.add(lane.getShape(aczEndPos, end));
            }
            if (!((aczCapPos = lane.normalizedDistanceAlongLane(this.getIntersection().getExitPoint(lane)) + (this.aczs.get(lane.getId()).getMaxSize() - this.aczs.get(lane.getId()).getCurrentSize()) / lane.getLength()) > 0.0)) continue;
            double end = aczCapPos + 1.0 / lane.getLength();
            laneShapes.add(lane.getShape(aczCapPos, end));
        }
        return laneShapes;
    }
}

